package org.lsst.ccs.subsystem.power.data;

import java.io.Serializable;
import java.util.List;
import org.lsst.ccs.bus.annotations.SkipEncoding;

/**
 *  Contains the state of a general power supply subsystem
 *
 *  @author Owen Saxton
 */
@SkipEncoding
public class PowerState implements Serializable {
    
    public final static String KEY = "PowerState";

    private final int tickMillis;         // Data status update period (ms)
    private final List<PowerChanState> chanState;  // State of the channels
 
    public PowerState(int tickMillis, List<PowerChanState> chanState) {
        this.tickMillis = tickMillis;
        this.chanState = chanState;
    }
    
    public int getTickMillis() {
        return tickMillis;
    }

    public List<PowerChanState> getChanState() {
        return chanState;
    }

    private static final long serialVersionUID = 8139256993515030641L;
}
