package org.lsst.ccs.subsystem.power.data;

import java.io.Serializable;
import org.lsst.ccs.subsystem.monitor.data.MonitorFullState;

/**
 ***************************************************************************
 **
 **  Contains information describing the full REB power supply state.
 **
 **  Sent on the status bus upon request.
 **
 **  @author Owen Saxton
 **
 ***************************************************************************
 */
public class RebPsFullState implements Serializable {
    
    private final RebPsState rebPsState;
    private final MonitorFullState monitorState;

    public RebPsFullState(RebPsState rState, MonitorFullState mState) {
        rebPsState = rState;
        monitorState = mState;
    }

    public RebPsState getRebPsState() {
        return rebPsState;
    }

    public MonitorFullState getMonitorFullState() {
        return monitorState;
    }

    private static final long serialVersionUID = -7953026930755318760L;
}
