/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.pathfinder;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.drivers.ascii.Multidrop;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.mks.Model9XX;
import org.lsst.ccs.framework.ClearAlertHandler;
import org.lsst.ccs.monitor.Device;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystem.common.ErrorUtils;
import org.lsst.ccs.subsystem.pathfinder.constants.RelayAlert;

public class Mks9xxDevice
extends Device {
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AlertService alertService;
    @ConfigurationParameter(name="devcId", category="Cryo", isFinal=true)
    private volatile String devcId;
    @ConfigurationParameter(name="busAddr", category="Cryo", isFinal=true)
    private volatile int busAddr = 253;
    @ConfigurationParameter(name="relayTrip", category="Cryo", maxLength=3, isFinal=true)
    private volatile double[] relayTrip;
    private final Multidrop.ConnType connType = Multidrop.ConnType.SERIAL;
    private final int baudRate = 9600;
    private static final Logger LOG = Logger.getLogger(Mks9xxDevice.class.getName());
    private final Model9XX mks = new Model9XX();
    private int errorCount = 0;
    private boolean initError = false;
    private final Map<String, Boolean> activeAlerts = new HashMap<String, Boolean>();

    public void initDevice() {
        if (this.devcId == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"devcId", (String)"is missing");
        }
        this.fullName = "MKS model 9XX (" + this.devcId + ":" + this.busAddr + ")";
        ClearAlertHandler clearAlertHandler = new ClearAlertHandler(){

            public ClearAlertHandler.ClearAlertCode canClearAlert(Alert alert, AlertState alertState) {
                return alertState == AlertState.ALARM ? ClearAlertHandler.ClearAlertCode.DONT_CLEAR_ALERT : ClearAlertHandler.ClearAlertCode.CLEAR_ALERT;
            }
        };
        for (int rNum = 1; rNum <= this.relayTrip.length; ++rNum) {
            this.alertService.registerAlert(RelayAlert.RELAY_DIRN_BAD.getAlert(this.name, rNum), clearAlertHandler);
            this.alertService.registerAlert(RelayAlert.RELAY_NOT_ENAB.getAlert(this.name, rNum), clearAlertHandler);
            this.alertService.registerAlert(RelayAlert.RELAY_TRIP_BAD.getAlert(this.name, rNum), clearAlertHandler);
        }
    }

    public void initialize() {
        try {
            this.mks.setRetryLimit(3);
            this.mks.open(this.connType, this.devcId, 9600, this.busAddr);
            this.mks.setLock(false);
            this.mks.setPressureUnit(Model9XX.Unit.TORR);
            this.mks.setLock(true);
            this.errorCount = 0;
            this.initSensors();
            this.checkRelays();
            LOG.log(Level.INFO, "Connected to {0}: model = {1}, serial no. = {2}", new Object[]{this.fullName, this.mks.getModel(), this.mks.getSerialNumber()});
            this.initError = false;
            this.setOnline(true);
        }
        catch (DriverException e) {
            if (!this.initError) {
                LOG.log(Level.SEVERE, "Error connecting to {0}: {1}", new Object[]{this.fullName, e});
                this.initError = true;
            }
            try {
                this.mks.close();
            }
            catch (DriverException driverException) {
                // empty catch block
            }
        }
    }

    public void close() {
        try {
            this.mks.close();
        }
        catch (DriverException e) {
            LOG.log(Level.SEVERE, "Error disconnecting from {0}: {1}", new Object[]{this.fullName, e});
        }
    }

    public double readChannel(int hwChan, int type) {
        double value;
        block3: {
            value = Double.NaN;
            if (this.isOnline()) {
                try {
                    value = this.mks.readPressure(Model9XX.Sensor.COMB4);
                    this.errorCount = 0;
                }
                catch (DriverException e) {
                    LOG.log(Level.SEVERE, "Error reading pressure from {0}: {1}", new Object[]{this.fullName, e});
                    if (++this.errorCount < 5) break block3;
                    this.setOnline(false);
                }
            }
        }
        return value;
    }

    private void checkRelays() throws DriverException {
        for (int rNum = 1; rNum <= this.relayTrip.length; ++rNum) {
            Model9XX.Direction dirn = this.mks.getRelayDirection(rNum);
            if (dirn != Model9XX.Direction.BELOW) {
                this.raiseAlarm(RelayAlert.RELAY_DIRN_BAD.getAlert(this.name, rNum), String.format("%s relay %s direction is %s", this.name, rNum, dirn));
            } else {
                this.lowerAlarm(RelayAlert.RELAY_DIRN_BAD.getAlert(this.name, rNum), String.format("%s relay %s direction is %s", this.name, rNum, dirn));
            }
            Model9XX.Enable enable = this.mks.getRelayEnable(rNum);
            if (enable == Model9XX.Enable.OFF) {
                this.raiseAlarm(RelayAlert.RELAY_NOT_ENAB.getAlert(this.name, rNum), String.format("%s relay %s enable is %s", this.name, rNum, enable));
            } else {
                this.lowerAlarm(RelayAlert.RELAY_NOT_ENAB.getAlert(this.name, rNum), String.format("%s relay %s enable is %s", this.name, rNum, enable));
            }
            double trip = this.mks.getRelayTrip(rNum);
            if (trip != this.relayTrip[rNum - 1]) {
                this.raiseAlarm(RelayAlert.RELAY_TRIP_BAD.getAlert(this.name, rNum), String.format("%s relay %s trip point (%.5g) should be %.5g", this.name, rNum, trip, this.relayTrip[rNum - 1]));
                continue;
            }
            this.lowerAlarm(RelayAlert.RELAY_TRIP_BAD.getAlert(this.name, rNum), String.format("%s relay %s trip point is %.5g", this.name, rNum, trip));
        }
    }

    private void raiseAlarm(Alert alert, String cause) {
        Boolean active = this.activeAlerts.get(alert.getAlertId());
        if (active != Boolean.TRUE) {
            this.alertService.raiseAlert(alert, AlertState.ALARM, cause);
            this.activeAlerts.put(alert.getAlertId(), true);
        }
    }

    private void lowerAlarm(Alert alert, String cause) {
        Boolean active = this.activeAlerts.get(alert.getAlertId());
        if (active == Boolean.TRUE) {
            this.alertService.raiseAlert(alert, AlertState.NOMINAL, cause);
            this.activeAlerts.put(alert.getAlertId(), false);
        }
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Read the pressure")
    public double readPressure(@Argument(description="Sensor name") Model9XX.Sensor sensor) throws DriverException {
        return this.mks.readPressure(sensor);
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Read the Micropirani temperature")
    public double readTemperature() throws DriverException {
        return this.mks.readTemperature();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Get a relay trip point")
    public double getRelayTrip(@Argument(description="Relay number") int relay) throws DriverException {
        return this.mks.getRelayTrip(relay);
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Get a relay hysteresis value")
    public double getRelayHyst(int relay) throws DriverException {
        return this.mks.getRelayHyst(relay);
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Get a relay trip direction")
    public Model9XX.Direction getRelayDirection(@Argument(description="Relay number") int relay) throws DriverException {
        return this.mks.getRelayDirection(relay);
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Get a relay enabled state")
    public Model9XX.Enable getRelayEnable(@Argument(description="Relay number") int relay) throws DriverException {
        return this.mks.getRelayEnable(relay);
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Get whether a relay is active")
    public boolean isRelayActive(@Argument(description="Relay number") int relay) throws DriverException {
        return this.mks.isRelayActive(relay);
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Get an analog output setting")
    public String getAnalogOut(@Argument(description="Channel number") int chan) throws DriverException {
        return this.mks.getAnalogOut(chan);
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Get the calibration gas")
    public Model9XX.Gas getCalibrationGas() throws DriverException {
        return this.mks.getCalibrationGas();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Get the device type")
    public String getDeviceType() throws DriverException {
        return this.mks.getDeviceType();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Get the firmware version")
    public String getFirmwareVersion() throws DriverException {
        return this.mks.getFirmwareVersion();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Get the hardware version")
    public String getHardwareVersion() throws DriverException {
        return this.mks.getHardwareVersion();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Get the manufacturer")
    public String getManufacturer() throws DriverException {
        return this.mks.getManufacturer();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Get the model")
    public String getModel() throws DriverException {
        return this.mks.getModel();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Get the part number")
    public String getPartNumber() throws DriverException {
        return this.mks.getPartNumber();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Get the serial number")
    public String getSerialNumber() throws DriverException {
        return this.mks.getSerialNumber();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Get the transducer time on (hours)")
    public int getTimeOn() throws DriverException {
        return this.mks.getTimeOn();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Get the sensor time on (hours)")
    public int getSensorTimeOn() throws DriverException {
        return this.mks.getSensorTimeOn();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Get the sensor pressure dose")
    public double getSensorDose() throws DriverException {
        return this.mks.getSensorDose();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Get the transducer status")
    public String getTransStatus() throws DriverException {
        return this.mks.getTransStatus();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Get the pressure unit")
    public Model9XX.Unit getPressureUnit() throws DriverException {
        return this.mks.getPressureUnit();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Get the baud rate")
    public int getBaudRate() throws DriverException {
        return this.mks.getBaudRate();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Get the user tag")
    public String getUserTag() throws DriverException {
        return this.mks.getUserTag();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Get the switch enabled state")
    public boolean isSwitchEnabled() throws DriverException {
        return this.mks.isSwitchEnabled();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Get the RS-485 delayed response state")
    public boolean isResponseDelayed() throws DriverException {
        return this.mks.isResponseDelayed();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Get the relay trip delayed state")
    public boolean isRelayDelayed() throws DriverException {
        return this.mks.isRelayDelayed();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Get the identify state")
    public boolean isIdentifying() throws DriverException {
        return this.mks.isIdentifying();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Get the atmospheric pressure calibration factor")
    public double getAtmospheric() throws DriverException {
        return this.mks.getAtmospheric();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Get the MicroPirani auto zero limit")
    public double getAutoZeroLimit() throws DriverException {
        return this.mks.getAutoZeroLimit();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Get the cold cathode full-scale pressure calibration factor")
    public double getFullScale() throws DriverException {
        return this.mks.getFullScale();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Get cold cathode turn-on pressure")
    public double getOnPressureCC() throws DriverException {
        return this.mks.getOnPressureCC();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Get cold cathode turn-off pressure")
    public double getOffPressureCC() throws DriverException {
        return this.mks.getOffPressureCC();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Get the low integration pressure")
    public double getLowIntPressure() throws DriverException {
        return this.mks.getLowIntPressure();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Get the high integration pressure")
    public double getHighIntPressure() throws DriverException {
        return this.mks.getHighIntPressure();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Get cold cathode auto power state")
    public boolean isCCAutoPowerOn() throws DriverException {
        return this.mks.isCCAutoPowerOn();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Get cold cathode power state")
    public boolean isCCPowerOn() throws DriverException {
        return this.mks.isCCPowerOn();
    }

    @Command(type=Command.CommandType.ACTION, level=10, description="Set cold cathode power state")
    public void setCCPower(@Argument(description="ON or OFF") OnOff onOff) throws DriverException {
        this.mks.setLock(false);
        this.mks.setCCPower(onOff == OnOff.ON);
        this.mks.setLock(true);
    }

    @Command(type=Command.CommandType.ACTION, level=10, description="Set cold cathode auto power on state")
    public void setCCAutoPower(@Argument(description="ON or OFF") OnOff onOff) throws DriverException {
        this.mks.setLock(false);
        this.mks.setCCAutoPower(onOff == OnOff.ON);
        this.mks.setLock(true);
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Get cold cathode protection delay")
    public int getCCProtDelay() throws DriverException {
        return this.mks.getCCProtDelay();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Get cold cathode pressure dose limit")
    public double getSensorDoseLimit() throws DriverException {
        return this.mks.getSensorDoseLimit();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Get read buffer contents")
    public String getReadBuffer() throws DriverException {
        return this.mks.getReadBuffer();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Format read buffer contents")
    public String formatReadBuffer() throws DriverException {
        return this.mks.formatReadBuffer();
    }

    @Command(type=Command.CommandType.ACTION, level=50, description="Set read timeout")
    public void setTimeout(@Argument(description="The timeout (secs)") double timeout) throws DriverException {
        this.mks.setTimeout(timeout);
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Get command retry limit")
    public int getRetryLimit() {
        return this.mks.getRetryLimit();
    }

    @Command(type=Command.CommandType.ACTION, level=50, description="Set command retry limit")
    public void setRetryLimit(@Argument(description="The retry limit") int limit) {
        this.mks.setRetryLimit(limit);
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Get command retry count")
    public int getRetryCount() {
        return this.mks.getRetryCount();
    }

    @Command(type=Command.CommandType.ACTION, level=50, description="Clear command retry count")
    public void clearRetryCount() {
        this.mks.clearRetryCount();
    }

    protected static enum OnOff {
        ON,
        OFF;

    }
}

