/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.pathfinder;

import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.ConfigurationParameterChanger;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupPath;
import org.lsst.ccs.config.ConfigurationParameterDescription;
import org.lsst.ccs.framework.AgentPeriodicTask;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.monitor.Channel;
import org.lsst.ccs.services.AgentPeriodicTaskService;
import org.lsst.ccs.subsystem.common.ErrorUtils;
import org.lsst.ccs.subsystem.common.PIController;
import org.lsst.ccs.subsystem.common.devices.dataforth.Maq20PWMControl;

public class FanControl
implements HasLifecycle {
    private static final String PIC = "Pic";
    @ConfigurationParameter(category="Pic")
    private volatile double gain = Double.NaN;
    @ConfigurationParameter(category="Pic", isFinal=true)
    private volatile double timeConst = Double.NaN;
    @ConfigurationParameter(category="Pic", isFinal=true)
    private volatile double smoothTime = Double.NaN;
    @ConfigurationParameter(category="Pic", isFinal=true)
    private volatile double awGain = Double.NaN;
    @ConfigurationParameter(category="Pic", isFinal=true)
    private volatile double baseDuty = Double.NaN;
    @ConfigurationParameter(category="Pic", isFinal=true)
    private volatile double tolerance = Double.NaN;
    @ConfigurationParameter(category="Pic", isFinal=true)
    private volatile double minInput = -50.0;
    @ConfigurationParameter(category="Pic", isFinal=true)
    private volatile double maxInput = 50.0;
    @ConfigurationParameter(category="Pic", isFinal=true)
    private volatile double minOutput = 0.0;
    @ConfigurationParameter(category="Pic", isFinal=true)
    private volatile double maxOutput = 1.0;
    @ConfigurationParameter(category="Pic")
    private volatile double setTemp = Double.NaN;
    @ConfigurationParameter(category="Pic", isFinal=true)
    private volatile boolean useAbsTemp = false;
    private String ambientTemp;
    private String UTTemp;
    private String[] fanCntrl;
    @LookupPath
    private String name;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPeriodicTaskService pts;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private Map<String, Channel> allChannels = new HashMap<String, Channel>();
    @LookupField(strategy=LookupField.Strategy.TREE)
    private Map<String, Maq20PWMControl> allFans = new HashMap<String, Maq20PWMControl>();
    private volatile Channel ambChannel;
    private volatile Channel cabChannel;
    private List<Maq20PWMControl> maqControl = new ArrayList<Maq20PWMControl>();
    private static final Logger LOG = Logger.getLogger(FanControl.class.getName());
    private PIController pic;
    private volatile double lastDuty;
    private volatile boolean active;
    private boolean tempError = false;

    public void build() {
        ConfigurationParameterDescription desc = new ConfigurationParameterDescription().withCategory(PIC).withName("updateTime");
        AgentPeriodicTask pt = new AgentPeriodicTask(this.name + "-iterate", () -> this.iterateLoop()).withPeriod(Duration.ofMillis(10000L)).withPeriodParameterDescription(desc);
        this.pts.scheduleAgentPeriodicTask(pt);
    }

    public void postInit() {
        if (Double.isNaN(this.gain)) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"gain", (String)"is missing");
        }
        if (Double.isNaN(this.timeConst)) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"timeConst", (String)"is missing");
        }
        if (Double.isNaN(this.smoothTime)) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"smoothTime", (String)"is missing");
        }
        if (Double.isNaN(this.awGain)) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"awGain", (String)"is missing");
        }
        if (Double.isNaN(this.baseDuty)) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"baseDuty", (String)"is missing");
        }
        if (Double.isNaN(this.tolerance)) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"tolerance", (String)"is missing");
        }
        Channel channel = this.ambChannel = this.ambientTemp == null ? null : this.allChannels.get(this.ambientTemp);
        if (this.ambChannel == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"ambientTemp", (String)"is missing or is not a Channel");
        }
        Channel channel2 = this.cabChannel = this.UTTemp == null ? null : this.allChannels.get(this.UTTemp);
        if (this.cabChannel == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"UTTemp", (String)"is missing or is not a Channel");
        }
        if (Double.isNaN(this.setTemp)) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"setTemp", (String)"is missing");
        }
        if (this.fanCntrl == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"fanCntrl", (String)"is missing");
        }
        for (String cName : this.fanCntrl) {
            if (cName == null) continue;
            Maq20PWMControl ctrl = this.allFans.get(cName);
            if (ctrl == null) {
                ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"fanCntrl", (String)("element (" + cName + ") is not a Maq20PWMControl"));
            }
            this.maqControl.add(ctrl);
        }
        this.pic = new PIController(-this.gain, this.timeConst);
        this.pic.setSmoothTime(this.smoothTime);
        this.pic.setAwGain(this.awGain);
        this.pic.setBaseOutput(this.baseDuty);
        this.pic.setInputRange(this.minInput, this.maxInput);
        this.pic.setOutputRange(this.minOutput, this.maxOutput);
        this.pic.setTolerance(this.tolerance);
        this.pic.setSetpoint(this.setTemp);
    }

    @ConfigurationParameterChanger
    public void setSetTemp(double temp) {
        this.setTemp = temp;
        if (this.pic != null) {
            this.pic.setSetpoint(this.setTemp);
        }
    }

    public double getSetTemp() {
        return this.setTemp;
    }

    @ConfigurationParameterChanger
    public void setGain(double gain) {
        this.gain = gain;
        if (this.pic != null) {
            this.pic.setPID(-gain, this.timeConst);
        }
    }

    public double getGain() {
        return this.gain;
    }

    public void setTimeConstant(double time) {
        this.timeConst = time;
        this.pic.setPID(-this.gain, this.timeConst);
    }

    public double getTimeConstant() {
        return this.timeConst;
    }

    public synchronized void startLoop(double duty) {
        if (this.active) {
            return;
        }
        this.lastDuty = duty;
        this.startLoop();
    }

    public synchronized void startLoop() {
        if (this.active) {
            return;
        }
        this.pic.reset();
        this.pic.setIntegral(this.lastDuty - this.baseDuty);
        this.active = true;
    }

    public void stopLoop() {
        this.active = false;
        this.setDutyCycle(0.0);
    }

    public boolean isLoopActive() {
        return this.active;
    }

    public void reset() {
        this.pic.reset();
    }

    private void setDutyCycle(double duty) {
        try {
            for (Maq20PWMControl ctrl : this.maqControl) {
                ctrl.setDutyCycle1(duty);
            }
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Error setting {0} fan speed: {1}", new Object[]{this.name, ex});
        }
    }

    private synchronized void iterateLoop() {
        if (!this.active) {
            return;
        }
        double tempDiff = this.cabChannel.getValue() - (this.useAbsTemp ? 0.0 : this.ambChannel.getValue());
        if (!Double.isNaN(tempDiff)) {
            if (this.tempError) {
                LOG.log(Level.INFO, "{0} control loop iteration succeeded again", this.name);
                this.tempError = false;
            }
            double tod = (double)System.currentTimeMillis() / 1000.0;
            this.lastDuty = this.pic.performPI(new double[]{tempDiff}, tod);
            this.setDutyCycle(this.lastDuty);
        } else if (!this.tempError) {
            LOG.log(Level.SEVERE, "{0} control loop iteration failed: temperature values not available", this.name);
            this.tempError = true;
        }
    }
}

