/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.auxelex;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.lsst.ccs.drivers.auxelex.Srp;
import org.lsst.ccs.drivers.commons.DriverException;

public class BfrComCam
extends Srp {
    public static final int RELAY_PTH_CMC_SCR_00 = 0;
    public static final int RELAY_AUX_CMC_DPP_01 = 2;
    public static final int RELAY_PTH_CMC_SCR_01 = 3;
    public static final int RELAY_SHT_SHT_PSW_00 = 4;
    public static final int RELAY_VCR_CMC_PCT_00 = 5;
    public static final int RELAY_DPP_01 = 6;
    public static final int RELAY_PWS_2 = 7;
    public static final int RELAY_PWS_3 = 8;
    public static final int RELAY_PWS_4 = 4;
    public static final int RELAY_PWS_16 = 9;
    public static final int RELAY_PWS_17 = 6;
    public static final int RELAY_PWS_18 = 7;
    public static final int RELAY_PWS_19 = 8;
    public static final int RELAY_PWS_25 = 9;
    public static final int RELAY_PWS_20 = 10;
    public static final int RELAY_PWS_21 = 11;
    public static final int NUM_RELAYS = 17;
    public static final int SENSOR_HTRS = 0;
    public static final int SENSOR_PWS_1 = 1;
    public static final int SENSOR_PWS_3 = 7;
    public static final int SENSOR_PWS_4 = 3;
    public static final int SENSOR_PWS_16 = 8;
    public static final int SENSOR_PWS_17 = 5;
    public static final int SENSOR_PWS_18 = 6;
    public static final int SENSOR_PWS_19 = 7;
    public static final int SENSOR_PWS_25 = 8;
    public static final int SENSOR_PWS_20_21 = 9;
    public static final int SENSOR_PROT = 10;
    public static final int NUM_SENSORS = 11;
    private static final Map<String, Integer> relayMap = new HashMap<String, Integer>();
    private static final int REG_RELAYS = 65536;
    private static final int REG_MBUS_CMND = 131072;
    private static final int REG_MBUS_RESP = 131074;
    private static final int REG_MBUS_RESP_RDY = 131100;
    private static final int MBUS_ADDRESS = 1;
    private static final int MBUS_FUNC_READ = 3;
    private static final int MBUS_FUNC_WRITE = 6;
    private static final int BASE_ADDR_INST = 0;
    private static final int BASE_ADDR_MIN = 1024;
    private static final int BASE_ADDR_MAX = 2048;
    private static final int BASE_ADDR_HOLD = 3072;
    private static final int OFF_ADDR_RMS = 0;
    private static final int OFF_ADDR_AC = 256;
    private static final int OFF_ADDR_DC = 512;
    private static final int TRIGGER_ADDR = 12304;
    private static final int SENSOR_READ_TMO = 170;
    private static final Map<CurrentType, Integer> offsetMap;
    private static final List<Srp.BoardType> validTypes;
    static String[] relayNames;

    public BfrComCam() {
        this.setValidBoardTypes(validTypes);
    }

    public void setRelayOn(int relay) throws DriverException {
        this.writeReg(65536 + this.checkRelayNumber(relay), 1);
    }

    public void setRelayOn(String relay) throws DriverException {
        this.writeReg(65536 + this.getRelayNumber(relay), 1);
    }

    public void setRelayOn(int ... relays) throws DriverException {
        for (int relay : relays) {
            this.checkRelayNumber(relay);
        }
        for (int relay : relays) {
            this.writeReg(65536 + relay, 1);
        }
    }

    public void setRelayOn(String ... relays) throws DriverException {
        ArrayList<Integer> numbers = new ArrayList<Integer>();
        for (String relay : relays) {
            numbers.add(this.getRelayNumber(relay));
        }
        Iterator iterator = numbers.iterator();
        while (iterator.hasNext()) {
            int number = (Integer)iterator.next();
            this.writeReg(65536 + number, 1);
        }
    }

    public void setRelayOn() throws DriverException {
        for (int relay = 0; relay < 17; ++relay) {
            this.writeReg(65536 + relay, 1);
        }
    }

    public void setRelayOff(int relay) throws DriverException {
        this.writeReg(65536 + this.checkRelayNumber(relay), 0);
    }

    public void setRelayOff(String relay) throws DriverException {
        this.writeReg(65536 + this.getRelayNumber(relay), 0);
    }

    public void setRelayOff(int ... relays) throws DriverException {
        for (int relay : relays) {
            this.checkRelayNumber(relay);
        }
        for (int relay : relays) {
            this.writeReg(65536 + relay, 0);
        }
    }

    public void setRelayOff(String ... relays) throws DriverException {
        ArrayList<Integer> numbers = new ArrayList<Integer>();
        for (String relay : relays) {
            numbers.add(this.getRelayNumber(relay));
        }
        Iterator iterator = numbers.iterator();
        while (iterator.hasNext()) {
            int number = (Integer)iterator.next();
            this.writeReg(65536 + number, 0);
        }
    }

    public void setRelayOff() throws DriverException {
        for (int relay = 0; relay < 17; ++relay) {
            this.writeReg(65536 + relay, 0);
        }
    }

    public boolean isRelayOn(int relay) throws DriverException {
        return (this.readReg(65536 + this.checkRelayNumber(relay)) & 1) != 0;
    }

    public boolean isRelayOn(String relay) throws DriverException {
        return (this.readReg(65536 + this.getRelayNumber(relay)) & 1) != 0;
    }

    public boolean[] isRelayOn() throws DriverException {
        int[] regs = this.readRegs(65536, 17);
        boolean[] state = new boolean[17];
        for (int relay = 0; relay < 17; ++relay) {
            state[relay] = (regs[relay] & 1) != 0;
        }
        return state;
    }

    public double[] readCurrent(CurrentType type, int sensor, int count) throws DriverException {
        return this.readSensor(0 + offsetMap.get((Object)type), sensor, count);
    }

    public double readCurrent(CurrentType type, int sensor) throws DriverException {
        return this.readCurrent(type, sensor, 1)[0];
    }

    public double[] readCurrent(CurrentType type) throws DriverException {
        return this.readCurrent(type, 0, 11);
    }

    public double[] readMinCurrent(CurrentType type, int sensor, int count) throws DriverException {
        return this.readSensor(1024 + offsetMap.get((Object)type), sensor, count);
    }

    public double readMinCurrent(CurrentType type, int sensor) throws DriverException {
        return this.readMinCurrent(type, sensor, 1)[0];
    }

    public double[] readMinCurrent(CurrentType type) throws DriverException {
        return this.readMinCurrent(type, 0, 11);
    }

    public double[] readMaxCurrent(CurrentType type, int sensor, int count) throws DriverException {
        return this.readSensor(2048 + offsetMap.get((Object)type), sensor, count);
    }

    public double readMaxCurrent(CurrentType type, int sensor) throws DriverException {
        return this.readMaxCurrent(type, sensor, 1)[0];
    }

    public double[] readMaxCurrent(CurrentType type) throws DriverException {
        return this.readMaxCurrent(type, 0, 11);
    }

    public double[] readHeldCurrent(CurrentType type, int sensor, int count) throws DriverException {
        return this.readSensor(3072 + offsetMap.get((Object)type), sensor, count);
    }

    public double readHeldCurrent(CurrentType type, int sensor) throws DriverException {
        return this.readHeldCurrent(type, sensor, 1)[0];
    }

    public double[] readHeldCurrent(CurrentType type) throws DriverException {
        return this.readHeldCurrent(type, 0, 11);
    }

    public void resetExtrema() throws DriverException {
        int[] cmnd = new int[]{17182736, 65536};
        this.writeRegs(131072, cmnd);
    }

    public void triggerHold() throws DriverException {
        int[] cmnd = new int[]{17182736, 0x100000};
        this.writeRegs(131072, cmnd);
    }

    public static String[] getRelayNames() throws DriverException {
        return relayNames;
    }

    private double[] readSensor(int addr, int sensor, int count) throws DriverException {
        if (sensor < 0 || sensor >= 11) {
            throw new DriverException("Invalid sensor number: " + sensor);
        }
        if (count <= 0 || sensor + count > 11) {
            throw new DriverException("Invalid sensor count: " + count);
        }
        int[] cmnd = new int[]{0x1030000 | addr + sensor, count << 16};
        this.writeRegs(131072, cmnd);
        long endTime = System.currentTimeMillis() + 1000L;
        int resp = 0;
        while (System.currentTimeMillis() < endTime && ((resp = this.readReg(131100)) & 1) == 0) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (!(resp & true) || resp >>> 24 == 170) {
            throw new DriverException("Current sensor read timed out");
        }
        int[] data = this.readRegs(131074, (2 * count + 6) / 4);
        int func = data[0] >> 16 & 0xFF;
        int nBytes = data[0] >> 8 & 0xFF;
        if (func >> 7 != 0) {
            throw new DriverException("Modbus read error: " + nBytes);
        }
        if (nBytes != 2 * count) {
            throw new DriverException("Incorrect returned data length: " + nBytes);
        }
        double[] values = new double[count];
        for (int j = 0; j < count; ++j) {
            values[j] = (j & 1) == 0 ? (double)(data[j / 2] << 24 >> 16 | data[j / 2 + 1] >>> 24) * 0.01 : (double)(data[j / 2 + 1] << 8 >> 16) * 0.01;
        }
        return values;
    }

    private int checkRelayNumber(int relay) throws DriverException {
        if (relay < 0 || relay > 17) {
            throw new DriverException("Invalid relay number: " + relay);
        }
        return relay;
    }

    private int getRelayNumber(String relay) throws DriverException {
        Integer number = relayMap.get(relay);
        if (number == null) {
            throw new DriverException("Invalid relay name: " + relay);
        }
        return number;
    }

    @Override
    protected void simInitialize() {
        super.simInitialize();
        this.putSimRegMap(131100, 1);
    }

    @Override
    protected void simWriteRegs(int addr, int[] value, int count) {
        int j = 0;
        while (j < count) {
            this.putSimRegMap(addr, value[j]);
            if (addr == 131073) {
                this.putSimRegMap(131074, value[j] >> 7);
            }
            ++j;
            ++addr;
        }
    }

    static {
        relayMap.put("scr1200", 0);
        relayMap.put("vatvalve", 2);
        relayMap.put("scr400", 3);
        relayMap.put("shutter", 4);
        relayMap.put("cryoturbo", 5);
        relayMap.put("scrollpump", 6);
        relayMap.put("pws02-48VD", 7);
        relayMap.put("pws03-24VD", 8);
        relayMap.put("pws04-shutter", 4);
        relayMap.put("pws16-ps0-2", 9);
        relayMap.put("pws17-ps3-5", 6);
        relayMap.put("pws18-ps6-8", 7);
        relayMap.put("pws19-ps9-10", 8);
        relayMap.put("pws25-psSpre", 9);
        relayMap.put("pws20-24VC", 10);
        relayMap.put("pws21-5V", 11);
        offsetMap = new HashMap<CurrentType, Integer>();
        offsetMap.put(CurrentType.RMS, 0);
        offsetMap.put(CurrentType.AC, 256);
        offsetMap.put(CurrentType.DC, 512);
        validTypes = new ArrayList<Srp.BoardType>();
        validTypes.add(Srp.BoardType.BFR);
        validTypes.add(Srp.BoardType.SIMULATED);
        relayNames = new String[17];
        Iterator<String> iterator = relayMap.keySet().iterator();
        while (iterator.hasNext()) {
            String name;
            BfrComCam.relayNames[BfrComCam.relayMap.get((Object)name).intValue()] = name = iterator.next();
        }
    }

    public static enum CurrentType {
        RMS,
        AC,
        DC;

    }
}

