/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.monitor;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.bus.states.DataProviderState;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.monitor.Channel;
import org.lsst.ccs.monitor.Monitor;
import org.lsst.ccs.services.alert.AlertService;

public class Alarm
implements HasLifecycle {
    private static final Logger LOG = Logger.getLogger(Alarm.class.getName());
    public static final int EVENT_TRIP = 0;
    public static final int EVENT_LIMBO = 1;
    public static final int EVENT_LIMBO_FROM_ERROR = 1;
    public static final int EVENT_LIMBO_FROM_GOOD = 2;
    public static final int EVENT_RESET = 3;
    private final Map<Channel, DataProviderState> currentChannelStates = new ConcurrentHashMap<Channel, DataProviderState>();
    private final Map<Channel, DataProviderState> channelStatesToBeProcessed = new ConcurrentHashMap<Channel, DataProviderState>();
    private final Map<Channel, AtomicInteger> consecutiveReadingsBelowCurrentState = new ConcurrentHashMap<Channel, AtomicInteger>();
    private final Map<Channel, String> channelCausesToBeProcessed = new ConcurrentHashMap<Channel, String>();
    protected String description = " ";
    protected int eventParm;
    protected boolean ignoreAlarmHandlers = false;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private List<Monitor.AlarmHandler> alarmHandlers = new ArrayList<Monitor.AlarmHandler>();
    private DataProviderState state = DataProviderState.NOMINAL;
    private DataProviderState oldstate = DataProviderState.NOMINAL;
    private final Object updateStateLock = new Object();
    @LookupName
    protected String name;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AlertService alertService;
    private Alert alertToBeRaised;
    Monitor.AlarmHandler defaultHandler = new Monitor.AlarmHandler(){

        @Override
        public boolean processAlarm(int event, int parm, String cause, String name) {
            return true;
        }
    };

    public Alarm() {
        this(null);
    }

    public Alarm(Alert alert) {
        this.alertToBeRaised = alert;
    }

    @Override
    public void build() {
        if (this.alertService == null) {
            throw new RuntimeException("Alarm instances must be part of the agent object tree. The AlertService instance must be non null.");
        }
    }

    @Override
    public void init() {
        this.alertService.registerAlert(this.getAlert(AlertState.NOMINAL, AlertState.NOMINAL));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateState(Channel ch, DataProviderState value, String cause) {
        Object object = this.updateStateLock;
        synchronized (object) {
            DataProviderState currentChannelState = this.currentChannelStates.get(ch);
            AtomicInteger consecutiveReadings = this.consecutiveReadingsBelowCurrentState.computeIfAbsent(ch, k -> new AtomicInteger(0));
            boolean processStateTransition = false;
            if (currentChannelState == null) {
                processStateTransition = true;
                consecutiveReadings.set(0);
            } else if (value.ordinal() > currentChannelState.ordinal()) {
                processStateTransition = true;
                consecutiveReadings.set(0);
            } else if (value.ordinal() < currentChannelState.ordinal()) {
                processStateTransition = consecutiveReadings.incrementAndGet() >= 5;
            } else if (value.ordinal() == currentChannelState.ordinal()) {
                consecutiveReadings.set(0);
            }
            if (processStateTransition) {
                this.channelStatesToBeProcessed.put(ch, value);
                this.channelCausesToBeProcessed.put(ch, cause);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setState() {
        Object object = this.updateStateLock;
        synchronized (object) {
            if (this.channelStatesToBeProcessed.size() > 0) {
                String alarmCause = "";
                for (Channel ch : this.channelStatesToBeProcessed.keySet()) {
                    DataProviderState channelStateToBeProcessed = this.channelStatesToBeProcessed.remove(ch);
                    String channelCauseToBeProcessed = this.channelCausesToBeProcessed.remove(ch);
                    DataProviderState currentChannelState = this.currentChannelStates.get(ch);
                    if (currentChannelState != null && currentChannelState == channelStateToBeProcessed) continue;
                    this.currentChannelStates.put(ch, channelStateToBeProcessed);
                    alarmCause = alarmCause + channelCauseToBeProcessed + "\n";
                }
                DataProviderState newState = DataProviderState.OFF_LINE;
                for (DataProviderState channelState : this.currentChannelStates.values()) {
                    if (channelState.ordinal() <= newState.ordinal()) continue;
                    newState = channelState;
                }
                if (newState != this.state && this.currentChannelStates.size() > 0) {
                    this.oldstate = this.state;
                    this.state = newState;
                    this.processAlarmTrigger(alarmCause);
                }
            }
        }
    }

    void processAlarmTrigger(String alarmCause) {
        DataProviderState newState = this.getAlarmState();
        DataProviderState oldState = this.getAlarmState();
        Integer event = null;
        if (newState == DataProviderState.ALARM) {
            event = 0;
        } else if (oldState == DataProviderState.ALARM) {
            event = newState == DataProviderState.NOMINAL ? 3 : 1;
        } else if (newState == DataProviderState.NOMINAL) {
            event = 3;
        } else if (newState == DataProviderState.WARNING) {
            event = 2;
        }
        boolean alertRaised = false;
        if (this.eventParm >= 0 && event != null && !this.ignoreAlarmHandlers) {
            for (Monitor.AlarmHandler alarmHandler : this.alarmHandlers) {
                if (!alarmHandler.processAlarm(event, this.eventParm, alarmCause, this.name)) continue;
                alertRaised = true;
                break;
            }
        }
        if (!alertRaised) {
            AlertState oldAlertState;
            AlertState alertState = Alarm.getAlertState(this.getAlarmState());
            Alert alert = this.getAlert(alertState, oldAlertState = Alarm.getAlertState(this.getAlarmPreviousState()));
            if (alert != null) {
                LOG.log(Alarm.getLogLevel(this.getAlarmState()), "Processing \"{0}\" at level {1}.\nRaising Alert {2} with AlertState {3} caused by {4}.", new Object[]{alert.getDescription(), this.getAlarmState(), alert.getAlertId(), alertState, alarmCause});
                this.alertService.raiseAlert(alert, alertState, alarmCause);
            } else {
                LOG.log(Level.WARNING, "Null Alert provided, so no Alert is raised.");
            }
        }
    }

    public Alert getAlert(AlertState alertState, AlertState previousAlertState) {
        if (this.alertToBeRaised == null) {
            return new Alert(this.name, this.getDescription());
        }
        return this.alertToBeRaised;
    }

    public static AlertState getAlertStateFromEventId(int event) {
        switch (event) {
            case 0: {
                return AlertState.ALARM;
            }
            case 1: {
                return AlertState.WARNING;
            }
            case 2: {
                return AlertState.WARNING;
            }
            case 3: {
                return AlertState.NOMINAL;
            }
        }
        throw new RuntimeException("Unkwnown event value " + event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearState() {
        Object object = this.updateStateLock;
        synchronized (object) {
            this.state = DataProviderState.NOMINAL;
            this.currentChannelStates.clear();
        }
    }

    public boolean canClearState() {
        return this.state.compareTo((Enum)DataProviderState.WARNING) <= 0;
    }

    String getDescription() {
        return this.description;
    }

    public String getName() {
        return this.name;
    }

    DataProviderState getAlarmState() {
        return this.state;
    }

    DataProviderState getAlarmPreviousState() {
        return this.oldstate;
    }

    int getAlarmId() {
        return this.eventParm;
    }

    private static AlertState getAlertState(DataProviderState state) {
        switch (state) {
            case ALARM: {
                return AlertState.ALARM;
            }
            case WARNING: {
                return AlertState.WARNING;
            }
            case NOMINAL: {
                return AlertState.NOMINAL;
            }
        }
        throw new IllegalArgumentException("Cannot convert Alarm state " + state + " to an AlertState");
    }

    private static Level getLogLevel(DataProviderState state) {
        switch (state) {
            case ALARM: {
                return Level.SEVERE;
            }
            case WARNING: {
                return Level.WARNING;
            }
            case NOMINAL: {
                return Level.INFO;
            }
        }
        throw new IllegalArgumentException("Cannot convert Alarm state " + state + " to an log Level");
    }
}

