package org.lsst.ccs.subsystem.ocsbridge;

import java.util.concurrent.TimeUnit;
import org.lsst.sal.camera.event.HeartbeatEvent;

/**
 * Create a SAL heartbeat event once per second,
 * @author tonyj
 */
class SALHeartbeatGenerator {

    private final OCSBridge ocsBridge;

    public SALHeartbeatGenerator(OCSBridge bridge) {
        this.ocsBridge = bridge;
    }

    void start() {
        ocsBridge.getCCS().schduleAtFixedRate(1, TimeUnit.SECONDS, () -> beat());
    }

    private void beat() {
        HeartbeatEvent heartBeat = new HeartbeatEvent(OCSBridge.DEFAULT_EVENT_PRIORITY, true);
        ocsBridge.getOcsCommandExecutor().sendEvent(heartBeat);
    }
}
