/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.auxiliary.remote.http.client;

import java.io.IOException;
import org.apache.commons.jcs3.auxiliary.remote.http.client.RemoteHttpCacheAttributes;
import org.apache.commons.jcs3.log.Log;
import org.apache.commons.jcs3.log.LogManager;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.impl.client.HttpClientBuilder;

public abstract class AbstractHttpClient {
    private final HttpClient httpClient;
    private HttpVersion httpVersion;
    private final RemoteHttpCacheAttributes remoteHttpCacheAttributes;
    private static final Log log = LogManager.getLog(AbstractHttpClient.class);

    public AbstractHttpClient(RemoteHttpCacheAttributes remoteHttpCacheAttributes) {
        this.remoteHttpCacheAttributes = remoteHttpCacheAttributes;
        String httpVersion = this.getRemoteHttpCacheAttributes().getHttpVersion();
        if ("1.1".equals(httpVersion)) {
            this.httpVersion = HttpVersion.HTTP_1_1;
        } else if ("1.0".equals(httpVersion)) {
            this.httpVersion = HttpVersion.HTTP_1_0;
        } else {
            log.warn("Unrecognized value for 'httpVersion': [{0}], defaulting to 1.1", httpVersion);
            this.httpVersion = HttpVersion.HTTP_1_1;
        }
        HttpClientBuilder builder = HttpClientBuilder.create();
        this.configureClient(builder);
        this.httpClient = builder.build();
    }

    protected void configureClient(HttpClientBuilder builder) {
        if (this.getRemoteHttpCacheAttributes().getMaxConnectionsPerHost() > 0) {
            builder.setMaxConnTotal(this.getRemoteHttpCacheAttributes().getMaxConnectionsPerHost());
            builder.setMaxConnPerRoute(this.getRemoteHttpCacheAttributes().getMaxConnectionsPerHost());
        }
        builder.setDefaultRequestConfig(RequestConfig.custom().setConnectTimeout(this.getRemoteHttpCacheAttributes().getConnectionTimeoutMillis()).setSocketTimeout(this.getRemoteHttpCacheAttributes().getSocketTimeoutMillis()).setCookieSpec("ignoreCookies").build());
    }

    protected final HttpResponse doWebserviceCall(RequestBuilder builder) throws IOException {
        this.preProcessWebserviceCall(builder.setVersion((ProtocolVersion)this.httpVersion));
        HttpUriRequest request = builder.build();
        HttpResponse httpResponse = this.httpClient.execute(request);
        this.postProcessWebserviceCall(request, httpResponse);
        return httpResponse;
    }

    protected abstract void preProcessWebserviceCall(RequestBuilder var1) throws IOException;

    protected abstract void postProcessWebserviceCall(HttpUriRequest var1, HttpResponse var2) throws IOException;

    protected RemoteHttpCacheAttributes getRemoteHttpCacheAttributes() {
        return this.remoteHttpCacheAttributes;
    }
}

