package org.lsst.ccs.subsystem.ocsbridge;

/**
 * A base class for all CCS command executors. This class is abstract and is
 * extended by specific executors for each supported command.
 *
 * @author tonyj
 */
public abstract class CCSExecutor extends CCSExecutorWithReturn<Void> {


    /**
     * Actually perform the command
     *
     * @throws java.lang.Exception If the command fails.
     */
    protected abstract void execute() throws Exception;

    @Override
    protected Void executeAndReturn() throws Exception {
        execute();
        return null;
    }
}
