/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.samp.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.astrogrid.samp.Client;
import org.astrogrid.samp.gui.ClientListCellRenderer;
import org.astrogrid.samp.gui.ClientTransmissionHolder;
import org.astrogrid.samp.gui.IconBox;
import org.astrogrid.samp.gui.Transmission;
import org.astrogrid.samp.gui.TransmissionCellRenderer;

class MessageTrackerListCellRenderer
extends ClientListCellRenderer {
    private final ClientTransmissionHolder transHolder_;
    private final int msgGap_;
    private final IconBox iconBox_;
    private final IconListModel iconListModel_;
    private final Object separator_;
    static /* synthetic */ Class class$org$astrogrid$samp$gui$MessageTrackerListCellRenderer;

    public MessageTrackerListCellRenderer(ClientTransmissionHolder transHolder) {
        this.transHolder_ = transHolder;
        this.iconListModel_ = new IconListModel();
        this.msgGap_ = 10;
        this.separator_ = new Object();
        this.iconBox_ = new IconBox(16);
        this.iconBox_.setOpaque(false);
        this.iconBox_.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.iconBox_.setModel(this.iconListModel_);
        this.iconBox_.setRenderer(new TransmissionCellRenderer(){
            static final /* synthetic */ boolean $assertionsDisabled;

            public String getToolTipText(IconBox iconBox, Object value, int index) {
                if (value instanceof Transmission) {
                    Transmission trans = (Transmission)value;
                    String mtype = trans.getMessage().getMType();
                    Client client = ((MessageTrackerListCellRenderer)MessageTrackerListCellRenderer.this).iconListModel_.client_;
                    if (client == trans.getSender()) {
                        return mtype + " -> " + trans.getReceiver();
                    }
                    if (client == trans.getReceiver()) {
                        return mtype + " <- " + trans.getSender();
                    }
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                    return null;
                }
                return null;
            }

            static {
                $assertionsDisabled = !(class$org$astrogrid$samp$gui$MessageTrackerListCellRenderer == null ? (class$org$astrogrid$samp$gui$MessageTrackerListCellRenderer = MessageTrackerListCellRenderer.class$("org.astrogrid.samp.gui.MessageTrackerListCellRenderer")) : class$org$astrogrid$samp$gui$MessageTrackerListCellRenderer).desiredAssertionStatus();
            }
        });
    }

    public void setTransmissionCellRenderer(IconBox.CellRenderer transRend) {
        this.iconBox_.setRenderer(transRend);
    }

    public IconBox.CellRenderer getTransmissionCellRenderer() {
        return this.iconBox_.getRenderer();
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.iconListModel_.client_ != null) {
            Point p = this.getIconBoxPosition();
            Dimension boxSize = this.iconBox_.getPreferredSize();
            if (g.hitClip(p.x, p.y, boxSize.width, boxSize.height)) {
                g.translate(p.x, p.y);
                this.iconBox_.paintComponent(g);
                g.translate(-p.x, -p.y);
            }
        }
    }

    public Dimension getPreferredSize() {
        Dimension prefSize = super.getPreferredSize();
        if (this.iconListModel_.client_ != null) {
            Dimension boxSize = this.iconBox_.getPreferredSize();
            prefSize.width += this.iconBox_.getPreferredSize().width + this.msgGap_;
        }
        return prefSize;
    }

    public String getToolTipText(MouseEvent evt) {
        Point boxPos = this.getIconBoxPosition();
        evt.translatePoint(-boxPos.x, -boxPos.y);
        return this.iconBox_.getToolTipText(evt);
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSel, boolean hasFocus) {
        Component c = super.getListCellRendererComponent(list, value, index, isSel, hasFocus);
        if (value instanceof Client) {
            this.iconListModel_.setClient((Client)value);
            int size = c.getPreferredSize().height;
            if (c instanceof JComponent) {
                Insets cInsets = ((JComponent)c).getInsets();
                size -= cInsets.top + cInsets.bottom;
                Insets bInsets = this.iconBox_.getInsets();
                size -= bInsets.top + bInsets.bottom;
            }
            this.iconBox_.setTransverseSize(size);
        } else {
            this.iconListModel_.setClient(null);
        }
        return c;
    }

    private Point getIconBoxPosition() {
        Insets insets = this.getInsets();
        return new Point(insets.left + super.getPreferredSize().width + this.msgGap_, insets.top);
    }

    private class IconListModel
    implements ListModel {
        Client client_;
        ListModel rxModel_;
        ListModel txModel_;
        private final ListDataListener rxListener_;
        private final ListDataListener txListener_;
        private final List listenerList_ = new ArrayList();
        static final /* synthetic */ boolean $assertionsDisabled;

        IconListModel() {
            this.rxListener_ = new ListDataForwarder(){

                public int getOffset() {
                    return 0;
                }
            };
            this.txListener_ = new ListDataForwarder(){

                public int getOffset() {
                    return (IconListModel.this.rxModel_ == null ? 0 : IconListModel.this.rxModel_.getSize()) + 1;
                }
            };
        }

        public void setClient(Client client) {
            if (this.rxModel_ != null) {
                this.rxModel_.removeListDataListener(this.rxListener_);
            }
            if (this.txModel_ != null) {
                this.txModel_.removeListDataListener(this.txListener_);
            }
            this.client_ = client;
            this.rxModel_ = MessageTrackerListCellRenderer.this.transHolder_.getRxListModel(client);
            this.txModel_ = MessageTrackerListCellRenderer.this.transHolder_.getTxListModel(client);
            if (this.rxModel_ != null) {
                this.rxModel_.addListDataListener(this.rxListener_);
            }
            if (this.txModel_ != null) {
                this.txModel_.addListDataListener(this.txListener_);
            }
            this.fireEvent(new ListDataEvent(this, 0, -1, -1));
        }

        public int getSize() {
            return (this.rxModel_ == null ? 0 : this.rxModel_.getSize()) + 1 + (this.txModel_ == null ? 0 : this.txModel_.getSize());
        }

        public Object getElementAt(int index) {
            int txSize;
            int rxSize;
            int n = rxSize = this.rxModel_ == null ? 0 : this.rxModel_.getSize();
            if (index < rxSize) {
                return this.rxModel_.getElementAt(index);
            }
            if ((index -= rxSize) < 1) {
                return MessageTrackerListCellRenderer.this.separator_;
            }
            int n2 = txSize = this.txModel_ == null ? 0 : this.txModel_.getSize();
            if (--index < txSize) {
                return this.txModel_.getElementAt(index);
            }
            index -= txSize;
            throw new IllegalArgumentException();
        }

        public void addListDataListener(ListDataListener listener) {
            this.listenerList_.add(listener);
        }

        public void removeListDataListener(ListDataListener listener) {
            this.listenerList_.remove(listener);
        }

        private void fireEvent(ListDataEvent evt) {
            Iterator it = this.listenerList_.iterator();
            block5: while (it.hasNext()) {
                ListDataListener listener = (ListDataListener)it.next();
                switch (evt.getType()) {
                    case 1: {
                        listener.intervalAdded(evt);
                        continue block5;
                    }
                    case 2: {
                        listener.intervalRemoved(evt);
                        continue block5;
                    }
                    case 0: {
                        listener.contentsChanged(evt);
                        continue block5;
                    }
                }
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
            }
        }

        static {
            $assertionsDisabled = !(class$org$astrogrid$samp$gui$MessageTrackerListCellRenderer == null ? (class$org$astrogrid$samp$gui$MessageTrackerListCellRenderer = MessageTrackerListCellRenderer.class$("org.astrogrid.samp.gui.MessageTrackerListCellRenderer")) : class$org$astrogrid$samp$gui$MessageTrackerListCellRenderer).desiredAssertionStatus();
        }

        private abstract class ListDataForwarder
        implements ListDataListener {
            private ListDataForwarder() {
            }

            abstract int getOffset();

            public void intervalAdded(ListDataEvent evt) {
                this.forwardEvent(evt);
            }

            public void intervalRemoved(ListDataEvent evt) {
                this.forwardEvent(evt);
            }

            public void contentsChanged(ListDataEvent evt) {
                this.forwardEvent(evt);
            }

            private void forwardEvent(ListDataEvent evt) {
                Object src = evt.getSource();
                int i0 = evt.getIndex0();
                int i1 = evt.getIndex1();
                if (0 <= i0 && i0 <= i1) {
                    int offset = this.getOffset();
                    IconListModel.this.fireEvent(new ListDataEvent(evt.getSource(), evt.getType(), evt.getIndex0() + offset, evt.getIndex1() + offset));
                } else {
                    IconListModel.this.fireEvent(evt);
                }
            }
        }
    }
}

