/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge.sim;

import java.io.Serializable;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.data.KeyValueDataList;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusStateChangeNotification;
import org.lsst.ccs.bus.states.StateBundle;
import org.lsst.ccs.subsystem.ocsbridge.events.CCSEvent;
import org.lsst.ccs.subsystem.ocsbridge.events.CCSFilterSwapEvent;
import org.lsst.ccs.subsystem.ocsbridge.events.CCSSetFilterEvent;
import org.lsst.ccs.subsystem.ocsbridge.sim.ComCamFilterChangerSubsystemLayer;
import org.lsst.ccs.subsystem.ocsbridge.sim.ControlledSubsystem;
import org.lsst.ccs.subsystem.ocsbridge.sim.FilterChangerInterface;
import org.lsst.ccs.subsystem.ocsbridge.sim.MCMConfig;
import org.lsst.ccs.subsystem.ocsbridge.states.FcsPowerState;
import org.lsst.ccs.subsystem.ocsbridge.states.FilterState;
import org.lsst.ccs.subsystem.ocsbridge.util.CCS;
import org.lsst.ccs.subsystem.ocsbridge.util.State;
import org.lsst.ccs.subsystems.fcs.states.AutochangerInclinationState;
import org.lsst.ccs.subsystems.fcs.states.AutochangerTrucksState;
import org.lsst.ccs.subsystems.fcs.states.CarouselPowerState;
import org.lsst.ccs.subsystems.fcs.states.FcsState;
import org.lsst.ccs.subsystems.fcs.states.ObservatoryFilterState;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;

public class MainCameraFilterChangerSubsystemLayer
extends ControlledSubsystem
implements FilterChangerInterface {
    private static final Logger LOG = Logger.getLogger(ComCamFilterChangerSubsystemLayer.class.getName());
    private static final Map<ObservatoryFilterState, FilterState> FCS_TO_FILTER_STATE = new HashMap<ObservatoryFilterState, FilterState>();
    private static final Map<CarouselPowerState, FcsPowerState> CAROUSEL_TO_FCS_POWER_STATE = new HashMap<CarouselPowerState, FcsPowerState>();
    private final AtomicBoolean isFirstFcsPublication = new AtomicBoolean(true);
    private volatile CCSSetFilterEvent ccsSetFilterEvent;
    private volatile CCSFilterSwapEvent ccsFilterSwapEvent;
    private String previousFilter = "";
    private static final FilterStateConverter converter;
    private static final PowerStateConverter powerConverter;

    private void translateFcsStateToFilterState(CCSTimeStamp when, ObservatoryFilterState value, String cause) {
        if (value == null) {
            value = ObservatoryFilterState.LOADED;
        }
        FilterState converted = converter.convertState(value);
        LOG.log(Level.INFO, "FilterState was converted to {0} ", converted);
        if (converted != null) {
            this.ccs.getAggregateStatus().add(when, new State<FilterState>(converted, cause));
        }
    }

    private void translateCarouselPowerStateToFcsPowerState(CCSTimeStamp when, CarouselPowerState value, String cause) {
        if (value == null) {
            value = CarouselPowerState.LOW_POWER;
        }
        FcsPowerState converted = powerConverter.convertState(value);
        LOG.log(Level.INFO, "CarouselPowerState was converted to {0} ", converted);
        if (converted != null) {
            this.ccs.getAggregateStatus().add(when, new State<FcsPowerState>(converted, cause));
        }
    }

    public MainCameraFilterChangerSubsystemLayer(Subsystem mcm, CCS ccs, MCMConfig config) {
        super(mcm, config.getFilterChangerSubsystemName(), ccs, config);
    }

    private void waitUntilMoveComplete(FilterState finalState, Duration estimatedDurationForFilterChange) throws ExecutionException {
        CompletableFuture<Void> waitForStatus = this.ccs.waitForStatus((Enum)finalState);
        try {
            waitForStatus.get(estimatedDurationForFilterChange.toMillis(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | TimeoutException ex) {
            throw new ExecutionException("Timeout waiting for filter change to complete", ex);
        }
    }

    @Override
    public void setFilter(String filter) throws ExecutionException {
        this.previousFilter = this.getCurrentFilter();
        if (this.previousFilter.equals(filter)) {
            return;
        }
        this.ccsSetFilterEvent = new CCSSetFilterEvent(filter, this.getFilterType(filter));
        this.ccs.fireEvent((CCSEvent)this.ccsSetFilterEvent);
        LOG.log(Level.INFO, "Sent: {0}", this.ccsSetFilterEvent);
        Duration timeout = this.getDurationForSlowFilterChange(filter);
        this.commandSender.sendCommand(Void.TYPE, timeout, "setFilterByName", filter);
        this.waitUntilMoveComplete(FilterState.LOADED, timeout);
    }

    @Override
    public List<String> getAvailableFilters() throws ExecutionException {
        return this.commandSender.sendCommand(List.class, "getAvailableFilters", new Object[0]);
    }

    @Override
    public List<String> getInstalledFilters() throws ExecutionException {
        return this.commandSender.sendCommand(List.class, "getInstalledFilters", new Object[0]);
    }

    @Override
    public String getCurrentFilter() throws ExecutionException {
        return this.commandSender.sendCommand(String.class, "getOnlineFilterName", new Object[0]);
    }

    @Override
    public double getMaxAngleForFilterChange() throws ExecutionException {
        return this.commandSender.sendCommand(Double.class, "getMaxAngleForFilterChange", new Object[0]);
    }

    @Override
    public double getMaxAngleForFastFilterChange() throws ExecutionException {
        return this.commandSender.sendCommand(Double.class, "getMaxAngleForFastFilterChange", new Object[0]);
    }

    @Override
    public Duration getDurationForSlowFilterChange(String filterName) throws ExecutionException {
        return this.commandSender.sendCommand(Duration.class, "getDurationForSlowFilterChange", filterName);
    }

    @Override
    public Duration getDurationForFastFilterChange(String filterName) throws ExecutionException {
        return this.commandSender.sendCommand(Duration.class, "getDurationForFastFilterChange", filterName);
    }

    @Override
    public void wakeFilterChanger(int mode) throws ExecutionException {
        this.commandSender.sendCommand(Void.TYPE, "wakeFilterChanger", mode);
    }

    @Override
    public Duration getDurationForWakeUp(int mode) throws ExecutionException {
        return this.commandSender.sendCommand(Duration.class, "getDurationForWakeUp", mode);
    }

    @Override
    protected void onConnect(AgentInfo agent, StateBundle initialState) {
        LOG.info("Filter changer connected");
        FcsState state = (FcsState)initialState.getState(FcsState.class);
        LOG.log(Level.INFO, "Got initial FCS FcsState {0}", state);
        ObservatoryFilterState filterState = (ObservatoryFilterState)initialState.getState(ObservatoryFilterState.class);
        LOG.log(Level.INFO, "Got initial FCS ObservatoryFilterState {0}", filterState);
        AutochangerInclinationState inclinationState = (AutochangerInclinationState)initialState.getState(AutochangerInclinationState.class);
        LOG.log(Level.INFO, "Got initial FCS AutochangerInclinationState {0}", inclinationState);
        this.translateFcsStateToFilterState(CCSTimeStamp.currentTime(), filterState, null);
        CarouselPowerState powerState = (CarouselPowerState)initialState.getState(CarouselPowerState.class);
        LOG.log(Level.INFO, "Got initial FCS CarouselPowerState {0}", powerState);
        this.translateCarouselPowerStateToFcsPowerState(CCSTimeStamp.currentTime(), powerState, null);
    }

    @Override
    protected void onDisconnect(AgentInfo agent) {
        LOG.info("Filter changer disconnected");
    }

    @Override
    protected void onStateChange(StatusStateChangeNotification statusChange) {
        StateBundle newStates = statusChange.getNewState();
        StateBundle oldStates = statusChange.getOldState();
        CCSTimeStamp when = statusChange.getStateTransitionTimestamp();
        StateBundle changedStates = newStates.diffState(oldStates);
        String cause = statusChange.getCause();
        changedStates.getDecodedStates().entrySet().stream().map(changedState -> (Enum)changedState.getValue()).forEachOrdered(value -> {
            if (value instanceof ObservatoryFilterState) {
                LOG.log(Level.INFO, "Got ObservatoryFilterState {0}", value);
                this.translateFcsStateToFilterState(when, (ObservatoryFilterState)value, cause);
            } else if (value instanceof AutochangerInclinationState) {
                LOG.log(Level.INFO, "Got AutochangerInclinationState {0}", value);
            } else if (value instanceof CarouselPowerState) {
                LOG.log(Level.INFO, "Got CarouselPowerState {0}", value);
                this.translateCarouselPowerStateToFcsPowerState(when, (CarouselPowerState)value, cause);
            }
        });
    }

    @Override
    protected void onEvent(StatusMessage msg) {
        Serializable data = msg.getObject();
        if (data instanceof KeyValueData) {
            KeyValueData sentData = (KeyValueData)data;
            String dataKey = sentData.getKey();
            LOG.log(Level.FINE, "Got kvd {0} {1}", new Object[]{dataKey, sentData.getValue()});
            switch (dataKey) {
                case "fcs/mcm": {
                    this.processFcsKvdl((KeyValueDataList)sentData.getValue());
                    break;
                }
                case "loader/mcm": {
                    this.processLoaderKvdl(msg.getCCSTimeStamp(), (KeyValueDataList)sentData.getValue());
                    break;
                }
                default: {
                    return;
                }
            }
        }
    }

    private void processFcsKvdl(KeyValueDataList kvdl) {
        String filterName = null;
        String filterType = null;
        int slot = 0;
        int position = 0;
        double proximity = 0.0;
        AutochangerTrucksState location = AutochangerTrucksState.ONLINE;
        for (KeyValueData kvd : kvdl) {
            Serializable value = kvd.getValue();
            switch (kvd.getKey()) {
                case "filter_on_autochanger": {
                    filterName = value.toString();
                    filterType = this.getFilterType(filterName);
                    break;
                }
                case "filter_previous_socketID": {
                    slot = ((Number)value).intValue();
                    break;
                }
                case "autochanger_trucks_position": {
                    position = ((Number)value).intValue();
                    break;
                }
                case "autochanger_trucks_state": {
                    location = AutochangerTrucksState.valueOf((String)value.toString());
                    break;
                }
                case "proximity": {
                    proximity = ((Number)value).doubleValue();
                }
            }
        }
        boolean endOfExchange = location == AutochangerTrucksState.ONLINE;
        boolean isSameFilter = this.previousFilter.equals(filterName);
        if (this.isFirstFcsPublication.getAndSet(false)) {
            this.ccsSetFilterEvent = new CCSSetFilterEvent(filterName, filterType, slot, proximity == 0.0 ? (double)position : proximity);
            this.ccs.fireEvent((CCSEvent)this.ccsSetFilterEvent);
            LOG.log(Level.INFO, "First publication from FCS: {0}", this.ccsSetFilterEvent);
        } else if (endOfExchange && !isSameFilter) {
            this.ccsSetFilterEvent = new CCSSetFilterEvent(filterName, filterType, slot, proximity == 0.0 ? (double)position : proximity);
            this.ccs.fireEvent((CCSEvent)this.ccsSetFilterEvent);
            LOG.log(Level.INFO, "Sent: {0}", this.ccsSetFilterEvent);
        } else {
            return;
        }
    }

    private void processLoaderKvdl(CCSTimeStamp when, KeyValueDataList kvdl) {
        String filterName = null;
        String filterType = null;
        String loaderId = null;
        String action = null;
        for (KeyValueData kvd : kvdl) {
            Serializable value = kvd.getValue();
            switch (kvd.getKey()) {
                case "filter_name": {
                    filterName = value.toString();
                    filterType = this.getFilterType(filterName);
                    break;
                }
                case "loader_id": {
                    loaderId = value.toString();
                    break;
                }
                case "action": {
                    action = value.toString();
                }
            }
        }
        this.ccsFilterSwapEvent = new CCSFilterSwapEvent(when.getTAIDouble(), loaderId, action, filterName, filterType);
        this.ccs.fireEvent((CCSEvent)this.ccsFilterSwapEvent);
        LOG.log(Level.INFO, "Sent: {0}", this.ccsFilterSwapEvent);
    }

    @Override
    protected void onRepublishServiceData() {
        if (this.ccsSetFilterEvent != null) {
            this.ccs.fireEvent((CCSEvent)this.ccsSetFilterEvent);
            LOG.log(Level.INFO, "Resent: {0}", this.ccsSetFilterEvent);
        }
    }

    static {
        FCS_TO_FILTER_STATE.put(ObservatoryFilterState.LOADING, FilterState.LOADING);
        FCS_TO_FILTER_STATE.put(ObservatoryFilterState.UNLOADING, FilterState.UNLOADING);
        FCS_TO_FILTER_STATE.put(ObservatoryFilterState.UNLOADED, FilterState.UNLOADED);
        FCS_TO_FILTER_STATE.put(ObservatoryFilterState.LOADED, FilterState.LOADED);
        FCS_TO_FILTER_STATE.put(ObservatoryFilterState.ROTATING, FilterState.ROTATING);
        FCS_TO_FILTER_STATE.put(ObservatoryFilterState.SWAPPING, FilterState.SWAPPING);
        FCS_TO_FILTER_STATE.put(ObservatoryFilterState.UNKNOWN, FilterState.UNKNOWN);
        CAROUSEL_TO_FCS_POWER_STATE.put(CarouselPowerState.LOW_POWER, FcsPowerState.LOW_POWER);
        CAROUSEL_TO_FCS_POWER_STATE.put(CarouselPowerState.REGULAR, FcsPowerState.REGULAR);
        converter = new FilterStateConverter();
        powerConverter = new PowerStateConverter();
    }

    private static class FilterStateConverter {
        private FilterStateConverter() {
        }

        private FilterState convertStateInstantaneous(ObservatoryFilterState state) {
            FilterState s = FCS_TO_FILTER_STATE.get(state);
            if (s == null) {
                s = FilterState.LOADED;
            }
            return s;
        }

        FilterState convertState(ObservatoryFilterState state) {
            FilterState s = this.convertStateInstantaneous(state);
            return s;
        }
    }

    private static class PowerStateConverter {
        private PowerStateConverter() {
        }

        private FcsPowerState convertStateInstantaneous(CarouselPowerState state) {
            FcsPowerState s = CAROUSEL_TO_FCS_POWER_STATE.get(state);
            if (s == null) {
                s = FcsPowerState.LOW_POWER;
            }
            return s;
        }

        FcsPowerState convertState(CarouselPowerState state) {
            FcsPowerState s = this.convertStateInstantaneous(state);
            return s;
        }
    }
}

