/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge;

import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.Assert;
import org.junit.Test;
import org.lsst.ccs.subsystem.ocsbridge.BridgeTest;
import org.lsst.ccs.subsystem.ocsbridge.FullStateHistory;
import org.lsst.ccs.subsystem.ocsbridge.TestStateChangeListener;
import org.lsst.ccs.subsystem.ocsbridge.states.RaftsState;
import org.lsst.ccs.subsystem.ocsbridge.states.ShutterReadinessState;
import org.lsst.ccs.subsystem.ocsbridge.states.ShutterState;
import org.lsst.ccs.subsystem.ocsbridge.states.TakeImageReadinessState;
import org.lsst.ccs.subsystem.ocsbridge.util.State;
import org.lsst.sal.camera.CameraCommand;
import org.lsst.sal.camera.command.InitImageCommand;
import org.lsst.sal.camera.event.AvailableFiltersEvent;
import org.lsst.sal.camera.event.ConfigurationAppliedEvent;
import org.lsst.sal.camera.event.ConfigurationsAvailableEvent;
import org.lsst.sal.camera.states.CCSCommandStateEvent;

public class InitImageTest
extends BridgeTest {
    @Test
    public void initImageFail() {
        try {
            this.ocsBridge.execute((CameraCommand)new InitImageCommand(2.0));
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void initImage() throws InterruptedException, ExecutionException, TimeoutException, Exception {
        this.enabler.goToEnable(this.ocsBridge);
        assert (this.executor.containsInOrder(ConfigurationsAvailableEvent.class, AvailableFiltersEvent.class, ConfigurationAppliedEvent.class));
        TestStateChangeListener tl = new TestStateChangeListener();
        this.ocsBridge.getCCS().addStateChangeListener((State.StateChangeListener)tl);
        this.ocsBridge.execute((CameraCommand)new InitImageCommand(2.0));
        this.ocsBridge.waitForState((Enum)TakeImageReadinessState.READY).get(5L, TimeUnit.SECONDS);
        this.ocsBridge.waitForState((Enum)ShutterReadinessState.NOT_READY).get(30L, TimeUnit.SECONDS);
        this.ocsBridge.waitForState((Enum)RaftsState.NEEDS_CLEAR).get(30L, TimeUnit.SECONDS);
        Thread.sleep(1000L);
        this.ocsBridge.getCCS().removeStateChangeListener((State.StateChangeListener)tl);
        tl.printFinalStates("InitImageTest:initImage()");
        FullStateHistory fsh = tl.getFullStateHistory();
        List<Enum> states = fsh.getStates();
        fsh.printStateHistory("InitImageTest:initImage()");
        Assert.assertEquals((long)11L, (long)tl.getCalls());
        assert (tl.getFinalStates().hasState(new Enum[]{CCSCommandStateEvent.CCSCommandState.IDLE}));
        assert (tl.getFinalStates().hasState(new Enum[]{TakeImageReadinessState.NOT_READY}));
        assert (tl.getFinalStates().hasState(new Enum[]{RaftsState.NEEDS_CLEAR}));
        assert (tl.getFinalStates().hasState(new Enum[]{ShutterReadinessState.NOT_READY}));
        Assert.assertEquals((Object)CCSCommandStateEvent.CCSCommandState.BUSY, (Object)states.get(0));
        Assert.assertTrue((boolean)this.ocsBridge.getCCS().getAggregateStatus().hasState(new Enum[]{ShutterState.CLOSED}));
        Assert.assertTrue((boolean)this.ocsBridge.getCCS().getAggregateStatus().hasState(new Enum[]{RaftsState.NEEDS_CLEAR}));
        Assert.assertTrue((boolean)fsh.containsInOrder(new Enum[]{ShutterReadinessState.GETTING_READY, ShutterReadinessState.READY, ShutterReadinessState.NOT_READY}));
        Assert.assertTrue((boolean)fsh.containsInOrder(new Enum[]{RaftsState.CLEARING, RaftsState.QUIESCENT, RaftsState.NEEDS_CLEAR}));
        Assert.assertTrue((boolean)fsh.containsInOrder(new Enum[]{TakeImageReadinessState.GETTING_READY, TakeImageReadinessState.READY, TakeImageReadinessState.NOT_READY}));
        this.executor.printEventList("InitImageTest:initImage()");
        assert (this.executor.containsInOrder(ConfigurationsAvailableEvent.class, AvailableFiltersEvent.class));
    }
}

