/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge;

import java.io.IOException;
import java.util.zip.CRC32;
import java.util.zip.Checksum;
import org.lsst.ccs.subsystem.imagehandling.data.AdditionalFile;
import org.lsst.sal.camera.event.LargeFileObjectAvailableEvent;

public class AdditionalFileToLFAEvent {
    private final LargeFileObjectAvailableEvent lfaEvent;
    private final long cksum;
    private final long byteSize;

    public AdditionalFileToLFAEvent(AdditionalFile addFile, String url) throws IOException {
        CRC32 cksum32 = new CRC32();
        this.byteSize = addFile.computeFileSizeAndChecksum((Checksum)cksum32);
        this.cksum = cksum32.getValue();
        this.lfaEvent = LargeFileObjectAvailableEvent.builder().byteSize((int)this.byteSize).checkSum(String.valueOf(this.cksum)).generator(AdditionalFile.class.getCanonicalName()).mimeType(addFile.getMimeType()).url(url).version(addFile.getVersion()).id(addFile.getFileName()).build();
    }

    LargeFileObjectAvailableEvent getlfaEvent() {
        return this.lfaEvent;
    }

    public long getByteSize() {
        return this.byteSize;
    }

    public long getChecksum() {
        return this.cksum;
    }
}

