/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.auxelex;

import org.lsst.ccs.drivers.auxelex.LambdaPS;
import org.lsst.ccs.drivers.auxelex.PduCommon;
import org.lsst.ccs.drivers.commons.DriverException;

public class PduHV
extends PduCommon {
    private static final double SHUNT_040 = 0.004;
    private static final int REG_LAMBDA_BASE = 78848;
    private static final int REG_TEMP_BASE = 79872;
    private static final int REG_BOARD_TEMP = 79872;
    private static final int REG_FPGA_TEMP = 79873;
    private final LambdaPS lambda;

    public PduHV(int numChans, int mainModel) {
        double[] currScales = new double[numChans];
        for (int j = 0; j < numChans; ++j) {
            currScales[j] = 250.0;
        }
        this.setCurrentScales(currScales);
        this.lambda = new LambdaPS(this, 78848, mainModel);
    }

    public double readBoardTemperature() throws DriverException {
        return this.readReg(79872);
    }

    public double readFpgaTemperature() throws DriverException {
        return this.readReg(79873);
    }

    public int getMainModel() throws DriverException {
        return this.lambda.getModel();
    }

    public String getMainSerialNo() throws DriverException {
        return this.lambda.getSerialNo();
    }

    public String getMainFwVersion() throws DriverException {
        return this.lambda.getFwVersion();
    }

    public String getMainPrVersion() throws DriverException {
        return this.lambda.getPrVersion();
    }

    public String getMainPartNo() throws DriverException {
        return this.lambda.getPartNo();
    }

    public String getMainManuDate() throws DriverException {
        return this.lambda.getManuDate();
    }

    public String getMainManuLocn() throws DriverException {
        return this.lambda.getManuLocn();
    }

    public int readMainStatus() throws DriverException {
        return this.lambda.readStatus();
    }

    public double readMainVoltage() throws DriverException {
        return this.lambda.readVoltage();
    }

    public double readMainCurrent() throws DriverException {
        return this.lambda.readCurrent();
    }

    public double readMainTemperature() throws DriverException {
        return this.lambda.readTemperature();
    }
}

