/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.config;

import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.lsst.ccs.bootstrap.SubstitutionTokenUtils;

public class SingleCategoryTag
implements Serializable {
    private static final long serialVersionUID = 8606602350889253605L;
    private final String category;
    private final String source;
    private final String tag;
    private final String version;
    private final String resolvedVersion;
    private String defaultSource;
    public static final String DEFAULT_VERSION = "d";
    public static final String UNSPECIFIED_VERSION = "";
    private static Map<String, String> defaultCategorySources = new ConcurrentHashMap<String, String>();
    private static String defaultForAllCategories = "<description>";

    public SingleCategoryTag(String source, String tag, String category) {
        this(source, tag, category, DEFAULT_VERSION, DEFAULT_VERSION);
    }

    public SingleCategoryTag(String source, String tag, String category, String requestedVersion) {
        this(source, tag, category, requestedVersion, requestedVersion);
    }

    public SingleCategoryTag(String source, String tag, String category, String requestedVersion, String resolvedVersion) {
        this.category = category;
        this.source = source;
        this.tag = tag;
        if (category == null) {
            throw new RuntimeException("Cannot build a SingleCategory object with a null category!!");
        }
        if (tag == null) {
            throw new RuntimeException("Cannot build a SingleCategory object with a null tag!!");
        }
        if (tag.isEmpty()) {
            throw new IllegalArgumentException("Category tag cannot be empty");
        }
        this.version = requestedVersion == null ? UNSPECIFIED_VERSION : requestedVersion;
        this.resolvedVersion = resolvedVersion == null || resolvedVersion.isEmpty() ? DEFAULT_VERSION : resolvedVersion;
    }

    public SingleCategoryTag(SingleCategoryTag t) {
        this(t, t.resolvedVersion);
        this.defaultSource = t.defaultSource;
    }

    public SingleCategoryTag(SingleCategoryTag t, String version) {
        this(t.source, t.tag, t.category, t.version, version);
        this.defaultSource = t.defaultSource;
    }

    void setDefaultSource(String defaultSource) {
        if (defaultSource == null || defaultSource.isEmpty()) {
            throw new IllegalArgumentException("Invalid default source: " + defaultSource);
        }
        this.defaultSource = defaultSource;
    }

    void setDefaultSourceIfAbsent(String defaultSource) {
        if (this.defaultSource == null) {
            this.setDefaultSource(defaultSource);
        }
    }

    public String getCategory() {
        return this.category;
    }

    public String getSource() {
        return this.source;
    }

    public String getTag() {
        return this.tag;
    }

    public String getInputVersion() {
        return this.version;
    }

    public String getRequestedVersion() {
        return this.version.equals(UNSPECIFIED_VERSION) ? DEFAULT_VERSION : this.version;
    }

    public String getResolvedVersion() {
        return this.resolvedVersion;
    }

    public String getVersion() {
        if (this.resolvedVersion != null && !this.resolvedVersion.equals(this.version)) {
            return this.resolvedVersion;
        }
        return this.version;
    }

    public boolean isRequestedVersionAnInteger() {
        try {
            Integer.parseInt(this.getRequestedVersion());
            return true;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }

    public String toString() {
        return this.convertToString(true, false);
    }

    public String convertToString(boolean showCategory, boolean showDefaultSource) {
        String defS;
        StringBuilder sb = new StringBuilder();
        if (showCategory) {
            sb.append(this.category).append(":");
        }
        String string = defS = this.defaultSource != null ? this.defaultSource : SingleCategoryTag.getDefaultSourceForCategory(this.category);
        if (showDefaultSource || !defS.equals(this.source)) {
            String sourceStr = this.source != null && !this.source.isEmpty() ? this.source + "/" : UNSPECIFIED_VERSION;
            sb.append(sourceStr);
        }
        sb.append(this.tag).append("(").append(this.getRequestedVersion());
        if (this.resolvedVersion != null && !this.resolvedVersion.equals(this.getRequestedVersion())) {
            sb.append("=").append(this.resolvedVersion);
        }
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof SingleCategoryTag) {
            SingleCategoryTag t = (SingleCategoryTag)obj;
            if (t.tag.equals(this.tag) && t.category.equals(this.category)) {
                if (this.source == null) {
                    return t.source == null;
                }
                return this.source.equals(t.source);
            }
        }
        return false;
    }

    public int hashCode() {
        return this.tag.hashCode() + (this.source != null ? 23 * this.source.hashCode() : 0) + 154 * this.category.hashCode();
    }

    @Deprecated
    public static void resetDefaultSources() {
    }

    public static void setDefaultForCategory(String category, String defaultForCat) {
        defaultCategorySources.put(category, defaultForCat);
    }

    public static String getDefaultSourceForCategory(String category) {
        String defCat = defaultForAllCategories;
        String catSpecificDef = defaultCategorySources.getOrDefault(category, SubstitutionTokenUtils.resolveSubstitutionTokens((String)defCat));
        return catSpecificDef;
    }
}

