/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge;

import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.lsst.ccs.subsystem.ocsbridge.BridgeTest;
import org.lsst.ccs.subsystem.ocsbridge.CCSCommand;
import org.lsst.ccs.subsystem.ocsbridge.FullStateHistory;
import org.lsst.ccs.subsystem.ocsbridge.TestStateChangeListener;
import org.lsst.ccs.subsystem.ocsbridge.util.State;
import org.lsst.sal.camera.command.EnterControlCommand;
import org.lsst.sal.camera.command.StandbyCommand;
import org.lsst.sal.camera.command.StartCommand;
import org.lsst.sal.camera.event.ConfigurationsAvailableEvent;
import org.lsst.sal.camera.states.CCSCommandStateEvent;
import org.lsst.sal.camera.states.SummaryStateEvent;

public class StandbyTest
extends BridgeTest {
    @Test
    public void stdbyTestFail() {
        try {
            this.ocsBridge.execute(new StandbyCommand());
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void stdbyFromDisabledState() throws Exception {
        this.ocsBridge.execute(new CCSCommand.CCSSetAvailableCommand());
        this.ocsBridge.execute(new EnterControlCommand());
        this.ocsBridge.execute(new StartCommand("Normal"));
        TestStateChangeListener tl = new TestStateChangeListener();
        this.executor.clearEvents();
        this.ocsBridge.getCCS().addStateChangeListener((State.StateChangeListener)tl);
        this.ocsBridge.execute(new StandbyCommand());
        tl.printFinalStates("StandbyTest:stdbyFromDisabledState()");
        this.executor.printEventList("StandbyTest:stdbyFromDisabledState()");
        Assert.assertEquals((long)4L, (long)tl.getCalls());
        Assert.assertEquals((long)1L, (long)this.executor.getEventCount());
        assert (tl.getFinalStates().hasState(new Enum[]{SummaryStateEvent.SummaryState.STANDBY}));
        assert (tl.getFinalStates().hasState(new Enum[]{CCSCommandStateEvent.CCSCommandState.IDLE}));
        this.ocsBridge.getCCS().removeStateChangeListener((State.StateChangeListener)tl);
        FullStateHistory fsh = tl.getFullStateHistory();
        List<Enum> states = fsh.getStates();
        fsh.printStateHistory("StandbyTest:stdbyFromDisabledState()");
        assert (fsh.containsInOrder(new Enum[]{CCSCommandStateEvent.CCSCommandState.BUSY, SummaryStateEvent.SummaryState.STANDBY, CCSCommandStateEvent.CCSCommandState.IDLE}));
        Assert.assertTrue((boolean)this.executor.containsInOrder(ConfigurationsAvailableEvent.class));
    }
}

