/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge;

import java.io.IOException;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.imagenaming.ImageName;
import org.lsst.ccs.subsystem.imagehandling.data.AdditionalFile;
import org.lsst.ccs.subsystem.imagehandling.data.JsonFile;
import org.lsst.ccs.subsystem.imagehandling.data.TextFile;
import org.lsst.ccs.subsystem.ocsbridge.AdditionalFileToLFAEvent;
import org.lsst.ccs.subsystem.ocsbridge.S3FileUploaderAndDeleter;
import org.lsst.ccs.subsystem.ocsbridge.sim.ShutterMotionProfileFitter;
import org.lsst.ccs.subsystem.ocsbridge.sim.ShutterMotionProfileSender;
import org.lsst.ccs.subsystem.ocsbridge.sim.ShutterSimulation;
import org.lsst.ccs.subsystem.shutter.status.MotionDone;

public class LFAAndJsonCheckAndS3WriteTest {
    @Test
    public void LFAObjectAndS3WriteTest() throws IOException, ClassNotFoundException, InterruptedException, ExecutionException {
        Assume.assumeTrue((boolean)LFAAndJsonCheckAndS3WriteTest.isS3Up());
        MotionDone md = ShutterSimulation.readMotionDone((String)"maincamera/shutter1-MotionDone-64.ser");
        ImageName obsId = new ImageName("MC_C_20230603_000001");
        ShutterMotionProfileFitter fitResult = (ShutterMotionProfileFitter)ShutterMotionProfileFitter.fit((Executor)ForkJoinPool.commonPool(), (MotionDone)md).get();
        ShutterMotionProfileSender sender = new ShutterMotionProfileSender(obsId, md, true, fitResult);
        JsonFile adFile = sender.getJsonFile();
        Properties lfaProperties = BootstrapResourceUtils.getBootstrapProperties((String)"lfa-test.properties");
        S3FileUploaderAndDeleter s3Uploader = new S3FileUploaderAndDeleter(lfaProperties, "MTCamera");
        s3Uploader.deleteFromS3((AdditionalFile)adFile);
        String writtenURL = s3Uploader.writeToS3((AdditionalFile)adFile);
        Assert.assertEquals((Object)"https://play.min.io/jsonwritetest/MTCamera/shutterMotionProfile/20230603/MC_C_20230603_000001_shutterMotionProfileOpen.json", (Object)writtenURL);
        AdditionalFileToLFAEvent lfa = new AdditionalFileToLFAEvent((AdditionalFile)adFile, writtenURL);
        System.out.println(lfa.getlfaEvent().toString());
        Assert.assertEquals((Object)"187892392", (Object)lfa.getlfaEvent().getCheckSum());
        s3Uploader.enforceNoOverwrite(true);
        try {
            s3Uploader.writeToS3((AdditionalFile)adFile);
            Assert.fail();
        }
        catch (IOException x) {
            Assert.assertTrue((boolean)x.getMessage().contains("S3 file already exists"));
        }
    }

    public static boolean isS3Up() {
        try {
            Properties lfaProperties = BootstrapResourceUtils.getBootstrapProperties((String)"lfa-test.properties");
            S3FileUploaderAndDeleter s3Uploader = new S3FileUploaderAndDeleter(lfaProperties, "MTCamera");
            TextFile file = new TextFile("test", "test" + UUID.randomUUID(), "test", new ImageName("MC_C_20230603_000001"));
            s3Uploader.writeToS3((AdditionalFile)file);
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }
}

