/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.command;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.lsst.ccs.command.DictionaryArgument;
import org.lsst.ccs.command.DictionaryCommand;
import org.lsst.ccs.command.MethodBasedDictionaryArgument;
import org.lsst.ccs.command.Options;
import org.lsst.ccs.command.SupportedOption;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.command.annotations.Option;

class MethodBasedDictionaryCommand
implements DictionaryCommand {
    private final String description;
    private final String[] aliases;
    private final DictionaryArgument[] params;
    private final Command.CommandType type;
    private transient Command.CommandCategory category;
    private final String name;
    private final boolean hasVarArgs;
    private final int level;
    private final boolean autoAck;
    private final Duration timeout;
    private static final long serialVersionUID = -2134147357955297580L;
    private List<SupportedOption> supportedOptions = new ArrayList<SupportedOption>();

    MethodBasedDictionaryCommand(Method annotatedMethod, Command annotation) {
        this.description = annotation.description();
        this.aliases = this.splitAliases(annotation.alias());
        this.type = annotation.type();
        this.category = annotation.category();
        this.name = annotation.name().isEmpty() ? annotatedMethod.getName() : annotation.name();
        this.hasVarArgs = annotatedMethod.isVarArgs();
        this.level = annotation.level();
        this.autoAck = annotation.autoAck();
        this.timeout = annotation.timeout() > 0 ? Duration.ofSeconds(annotation.timeout()) : null;
        Option[] options = (Option[])annotatedMethod.getAnnotationsByType(Option.class);
        HashMap<String, SupportedOption> shortNamesForMethod = new HashMap<String, SupportedOption>();
        for (Option o : options) {
            SupportedOption so = new SupportedOption(o.name(), o.description(), o.singleLetterName());
            this.supportedOptions.add(so);
            String singleLetter = so.getSingleLetterName();
            SupportedOption otherSo = (SupportedOption)shortNamesForMethod.get(singleLetter);
            if (otherSo != null) {
                throw new IllegalArgumentException("Method " + annotatedMethod.getName() + " contains at least two options with single letter name = " + singleLetter + " : " + so.getName() + " " + otherSo.getName());
            }
            shortNamesForMethod.put(singleLetter, so);
        }
        boolean hasOptions = !this.supportedOptions.isEmpty();
        Class<?>[] types = annotatedMethod.getParameterTypes();
        Annotation[][] parAnnotations = annotatedMethod.getParameterAnnotations();
        this.params = new MethodBasedDictionaryArgument[hasOptions ? types.length - 1 : types.length];
        Parameter[] methodParameters = annotatedMethod.getParameters();
        boolean foundOptionsArgument = false;
        int argCount = 0;
        for (int i = 0; i < types.length; ++i) {
            Class<?> parameterType;
            String parName = methodParameters[i].getName();
            String parDescription = "";
            String defaultValue = "***NOT_SET_INITIAL_VALUE***";
            Method allowedValueMethod = null;
            for (Annotation a : parAnnotations[i]) {
                if (!(a instanceof Argument)) continue;
                Argument paramAnnotation = (Argument)a;
                parName = paramAnnotation.name().isEmpty() ? parName : paramAnnotation.name();
                parDescription = paramAnnotation.description();
                if (!paramAnnotation.defaultValue().equals("***NOT_SET_INITIAL_VALUE***")) {
                    defaultValue = paramAnnotation.defaultValue();
                }
                if (paramAnnotation.allowedValueProvider().isEmpty()) break;
                try {
                    allowedValueMethod = annotatedMethod.getDeclaringClass().getMethod(paramAnnotation.allowedValueProvider(), new Class[0]);
                }
                catch (Exception exception) {}
                break;
            }
            Class<?> clazz = parameterType = this.hasVarArgs && i == types.length - 1 ? types[i].getComponentType() : types[i];
            if (Options.class.isAssignableFrom(parameterType)) {
                if (!hasOptions) {
                    throw new RuntimeException("Method " + annotatedMethod.getDeclaringClass().getSimpleName() + "::" + this.name + " has an Options argument but no @Option annotations. Please annotate the method accordingly or remove the Options argument.");
                }
                if (foundOptionsArgument) {
                    throw new RuntimeException("Method " + annotatedMethod.getDeclaringClass().getSimpleName() + "::" + this.name + " has one or more @Option annotations and more than one Options argument. There can be only one.");
                }
                foundOptionsArgument = true;
                if (!foundOptionsArgument || i == 0) continue;
                throw new RuntimeException("Method " + annotatedMethod.getDeclaringClass().getSimpleName() + "::" + this.name + " supports Options but the Options argument is not the first one in the calling sequence.");
            }
            this.params[argCount++] = new MethodBasedDictionaryArgument(parName, parameterType, parDescription, defaultValue, allowedValueMethod);
        }
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String[] getAliases() {
        return this.aliases;
    }

    @Override
    public DictionaryArgument[] getArguments() {
        return this.params;
    }

    @Override
    public Command.CommandType getType() {
        return this.type;
    }

    @Override
    public Command.CommandCategory getCategory() {
        return this.category;
    }

    @Override
    public String getCommandName() {
        return this.name;
    }

    @Override
    public boolean isVarArgs() {
        return this.hasVarArgs;
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    @Override
    public boolean isAutoAck() {
        return this.autoAck;
    }

    @Override
    public Duration getTimeout() {
        return this.timeout;
    }

    private String[] splitAliases(String alias) {
        return alias.length() > 0 ? alias.split("\\s?,\\s?") : NO_ALIASES;
    }

    @Override
    public List<SupportedOption> getSupportedOptions() {
        if (this.supportedOptions == null) {
            return new ArrayList<SupportedOption>();
        }
        return this.supportedOptions;
    }

    public String toString() {
        return "MethodBasedDictionaryCommand{description='" + this.description + "', aliases=" + Arrays.toString(this.aliases) + ", params=" + Arrays.toString(this.params) + ", type=" + this.type + ", name='" + this.name + "', hasVarArgs=" + this.hasVarArgs + "}";
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        stream.writeObject(this.category.name());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        try {
            Command.CommandCategory tmpCategory;
            String categoryName = (String)stream.readObject();
            this.category = tmpCategory = Command.CommandCategory.valueOf(categoryName);
        }
        catch (Exception exception) {
        }
        finally {
            if (this.category == null) {
                this.category = Command.CommandCategory.USER;
            }
        }
    }
}

