/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.zip.CRC32;
import org.lsst.ccs.bus.data.DataProviderDictionary;
import org.lsst.ccs.bus.data.DataProviderInfo;
import org.lsst.ccs.command.Dictionary;
import org.lsst.ccs.command.DictionaryArgument;
import org.lsst.ccs.command.DictionaryCommand;

public class ChecksumUtils {
    public static long evaluateChecksum(Object obj) {
        CRC32 checksum = new CRC32();
        if (obj instanceof Map) {
            ChecksumUtils.updateCommandDictionariesChecksum((Map)obj, checksum);
            return checksum.getValue();
        }
        if (obj instanceof DataProviderDictionary) {
            ChecksumUtils.updateDataDictionaryChecksum((DataProviderDictionary)obj, checksum);
            return checksum.getValue();
        }
        if (obj instanceof Dictionary) {
            ChecksumUtils.updateCommandDictionaryChecksum((Dictionary)obj, checksum);
            return checksum.getValue();
        }
        if (obj instanceof DataProviderInfo) {
            ChecksumUtils.updateDataProviderInfoChecksum((DataProviderInfo)obj, checksum);
            return checksum.getValue();
        }
        if (obj instanceof List) {
            long res = 0L;
            List l = (List)obj;
            for (Object o : l) {
                res += ChecksumUtils.evaluateChecksum(o);
            }
            return res;
        }
        throw new RuntimeException("Cannot evaluate checksum for object type: " + obj.getClass());
    }

    private static void updateDataDictionaryChecksum(DataProviderDictionary dictionary, CRC32 checksum) {
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();
             DataOutputStream dos = new DataOutputStream(bos);){
            dos.writeInt(dictionary.size());
            for (DataProviderInfo dpi : dictionary.getDataProviderInfos()) {
                ChecksumUtils.updateDataProviderInfoChecksum(dpi, dos);
            }
            bos.flush();
            checksum.update(bos.toByteArray(), 0, bos.size());
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    private static void updateDataProviderInfoChecksum(DataProviderInfo dpi, CRC32 checksum) {
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();
             DataOutputStream dos = new DataOutputStream(bos);){
            ChecksumUtils.updateDataProviderInfoChecksum(dpi, dos);
            bos.flush();
            checksum.update(bos.toByteArray(), 0, bos.size());
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    private static void updateDataProviderInfoChecksum(DataProviderInfo dpi, DataOutputStream dos) throws IOException {
        dos.writeUTF(dpi.getFullPath());
        DataProviderInfo.Attribute[] attributes = dpi.getAttributes();
        dos.writeInt(attributes.length);
        for (DataProviderInfo.Attribute attr : attributes) {
            dos.writeUTF(attr.getName());
            dos.writeBoolean(attr.isMetadata());
            dos.writeUTF(dpi.getAttributeValue(attr));
        }
    }

    private static void updateCommandDictionariesChecksum(Map<String, Dictionary> dictionaries, CRC32 checksum) {
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            try (DataOutputStream dos = new DataOutputStream(bos);){
                dos.writeInt(dictionaries.size());
                for (Map.Entry<String, Dictionary> e : dictionaries.entrySet()) {
                    dos.writeUTF(e.getKey());
                    ChecksumUtils.updateCommandDictionaryChecksum(e.getValue(), dos);
                }
                bos.flush();
            }
            checksum.update(bos.toByteArray(), 0, bos.size());
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    private static void updateCommandDictionaryChecksum(Dictionary dictionary, CRC32 checksum) {
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();
             DataOutputStream dos = new DataOutputStream(bos);){
            ChecksumUtils.updateCommandDictionaryChecksum(dictionary, dos);
            bos.flush();
            checksum.update(bos.toByteArray(), 0, bos.size());
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    private static void updateCommandDictionaryChecksum(Dictionary dictionary, DataOutputStream dos) throws IOException {
        Dictionary dict = dictionary;
        dos.writeInt(dict.size());
        for (DictionaryCommand cmd : dict) {
            String[] aliases;
            DictionaryArgument[] args;
            dos.writeUTF(cmd.getCommandName());
            if (cmd.getDescription() != null) {
                dos.writeUTF(cmd.getDescription());
            }
            dos.writeUTF(cmd.getCategory().name());
            dos.writeInt(cmd.getLevel());
            dos.writeUTF(cmd.getType().name());
            if (cmd.getTimeout() != null) {
                dos.writeLong(cmd.getTimeout().toMillis());
            }
            dos.writeBoolean(cmd.isAutoAck());
            dos.writeBoolean(cmd.isVarArgs());
            boolean hasOptions = cmd.hasOptions();
            dos.writeBoolean(hasOptions);
            if (hasOptions) {
                for (DictionaryArgument[] o : cmd.getSupportedOptions()) {
                    if (o.getDescription() != null) {
                        dos.writeUTF(o.getDescription());
                    }
                    dos.writeUTF(o.getName());
                    dos.writeUTF(o.getSingleLetterName());
                }
            }
            if ((args = cmd.getArguments()) != null) {
                dos.writeInt(args.length);
                for (DictionaryArgument arg : args) {
                    dos.writeUTF(arg.getName());
                    dos.writeUTF(arg.getSimpleType());
                    dos.writeUTF(arg.getType());
                    if (arg.getDescription() != null) {
                        dos.writeUTF(arg.getDescription());
                    }
                    dos.writeInt(arg.getAllowedValues().size());
                    for (String v : arg.getAllowedValues()) {
                        dos.writeUTF(v);
                    }
                    boolean hasDefaultValue = arg.hasDefaultValue();
                    dos.writeBoolean(hasDefaultValue);
                    if (!hasDefaultValue || arg.getDefaultValue() == null) continue;
                    dos.writeUTF(arg.getDefaultValue());
                }
            }
            if ((aliases = cmd.getAliases()) == null) continue;
            dos.writeInt(aliases.length);
            for (String alias : aliases) {
                dos.writeUTF(alias);
            }
        }
    }
}

