/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.sal.kafka;

import java.lang.ref.WeakReference;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.lsst.sal.SALCommandResponse;
import org.lsst.sal.SALException;
import org.lsst.sal.kafka.SALKafkaAck;
import org.lsst.sal.kafka.SALKafkaUtils;

class SALKafkaCommandResponse
extends SALCommandResponse {
    private static final Map<Integer, WeakReference<SALKafkaCommandResponse>> outstandingCommandResponses = new ConcurrentHashMap<Integer, WeakReference<SALKafkaCommandResponse>>();
    private final CompletableFuture<Duration> ackFuture = new CompletableFuture();
    private final CompletableFuture<Integer> completeFuture = new CompletableFuture();
    private final int seqNum;

    SALKafkaCommandResponse(int seqNum) {
        outstandingCommandResponses.put(seqNum, new WeakReference<SALKafkaCommandResponse>(this));
        this.seqNum = seqNum;
    }

    static SALKafkaCommandResponse getResponseFor(int seqNum) {
        WeakReference<SALKafkaCommandResponse> weakReference = outstandingCommandResponses.get(seqNum);
        if (weakReference == null) {
            return null;
        }
        SALKafkaCommandResponse response = (SALKafkaCommandResponse)weakReference.get();
        if (response == null) {
            outstandingCommandResponses.remove(seqNum);
        }
        return response;
    }

    @Override
    public Duration waitForAck(Duration timeout) throws SALCommandResponse.CommandFailedException, SALException, TimeoutException {
        try {
            return this.ackFuture.get(timeout.toMillis(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException ex) {
            throw new SALException("Interrupt while waiting for command ack ", ex);
        }
        catch (ExecutionException ex) {
            throw new SALException("Command Failed", ex.getCause());
        }
    }

    @Override
    public int waitForCompletion(Duration timeout) throws SALCommandResponse.CommandFailedException, SALException, TimeoutException {
        try {
            return this.completeFuture.get(timeout.toMillis(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException ex) {
            throw new SALException("Interrupt while waiting for command completion ", ex);
        }
        catch (ExecutionException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof SALException) {
                throw (SALException)cause;
            }
            throw new SALException("Command Failed: " + (cause == null ? ex.getMessage() : cause.getMessage()));
        }
    }

    void handleAck(SALKafkaAck ack) {
        switch (ack.getAck()) {
            case 301: {
                this.ackFuture.complete(SALKafkaUtils.durationFromSeconds(ack.getTimeout()));
                break;
            }
            case 303: {
                this.ackFuture.complete(Duration.ZERO);
                this.completeFuture.complete(ack.getAck());
                outstandingCommandResponses.remove(this.seqNum);
                break;
            }
            default: {
                this.ackFuture.complete(Duration.ZERO);
                this.completeFuture.completeExceptionally(new SALCommandResponse.CommandFailedException(ack.getMessage(), ack.getAck(), ack.getError()));
                outstandingCommandResponses.remove(this.seqNum);
            }
        }
    }
}

