/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge.events;

import java.util.List;
import org.lsst.ccs.bus.annotations.SkipEncoding;
import org.lsst.ccs.subsystem.ocsbridge.events.CCSEvent;

@SkipEncoding
public class CCSAvailableFiltersEvent
extends CCSEvent {
    private final List<String> filterNames;
    private final List<String> filterTypes;
    private final double maxChangeAngle;
    private final double maxFastChangeAngle;
    private final double[] maxSlowChangeTime;
    private final double[] maxFastChangeTime;

    public CCSAvailableFiltersEvent(List<String> filterNames, List<String> filterTypes, double maxChangeAngle, double maxFastChangeAngle, double[] maxSlowChangeTime, double[] maxFastChangeTime) {
        this.filterNames = filterNames;
        this.filterTypes = filterTypes;
        this.maxChangeAngle = maxChangeAngle;
        this.maxFastChangeAngle = maxFastChangeAngle;
        this.maxSlowChangeTime = maxSlowChangeTime;
        this.maxFastChangeTime = maxFastChangeTime;
    }

    public CCSAvailableFiltersEvent(List<String> filterNames, List<String> filterTypes, double maxChangeAngle, double maxFastChangeAngle, double maxSlowChangeTime, double maxFastChangeTime) {
        this.filterNames = filterNames;
        this.filterTypes = filterTypes;
        this.maxChangeAngle = maxChangeAngle;
        this.maxFastChangeAngle = maxFastChangeAngle;
        int n = filterNames.size();
        double[] slowChangeTime = new double[n];
        double[] fastChangeTime = new double[n];
        for (int i = 0; i < n; ++i) {
            slowChangeTime[i] = maxSlowChangeTime;
            fastChangeTime[i] = maxFastChangeTime;
        }
        this.maxSlowChangeTime = slowChangeTime;
        this.maxFastChangeTime = fastChangeTime;
    }

    public CCSAvailableFiltersEvent(List<String> filterNames, List<String> filterTypes) {
        this(filterNames, filterTypes, 0.0, 0.0, 240.0, 240.0);
    }

    public List<String> getAvailableFilters() {
        return this.filterNames;
    }

    public List<String> getAvailableFilterTypes() {
        return this.filterTypes;
    }

    public double getMaxChangeAngle() {
        return this.maxChangeAngle;
    }

    public double getMaxFastChangeAngle() {
        return this.maxFastChangeAngle;
    }

    public double[] getMaxSlowChangeTime() {
        return this.maxSlowChangeTime;
    }

    public double[] getMaxFastChangeTime() {
        return this.maxFastChangeTime;
    }

    public String toString() {
        return "CCSAvailableFiltersEvent{filterNames=" + this.filterNames + ", filterTypes=" + this.filterTypes + ", maxChangeAngle=" + this.maxChangeAngle + ", maxFastChangeAngle=" + this.maxFastChangeAngle + ", maxSlowChangeTime=" + this.maxSlowChangeTime + ", maxFastChangeTime=" + this.maxFastChangeTime + "}";
    }
}

