/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.util.commanddispatcher;

import java.io.PrintStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Observer;
import java.util.Set;
import org.freehep.util.commanddispatcher.CommandGroup;
import org.freehep.util.commanddispatcher.CommandSource;
import org.freehep.util.commanddispatcher.CommandTarget;
import org.freehep.util.commanddispatcher.Dumper;
import org.freehep.util.commanddispatcher.MultiTarget;

public class CommandTargetManager {
    private Set groups = new HashSet();
    private Set sources = new HashSet();
    private boolean started = false;

    public synchronized void add(CommandGroup group) {
        if (this.groups.add(group) && this.started) {
            for (CommandSource s : this.sources) {
                String command = s.getCommand();
                CommandTarget target = group.acceptCommand(command);
                if (target == null) continue;
                CommandTarget existingTarget = s.getTarget();
                if (existingTarget == null) {
                    if (!s.setTarget(target) || !(s instanceof Observer)) continue;
                    group.addObserver((Observer)((Object)s));
                    continue;
                }
                if (existingTarget instanceof MultiTarget) {
                    ((MultiTarget)existingTarget).add(target);
                    continue;
                }
                if (s instanceof Observer) {
                    existingTarget.getGroup().deleteObserver((Observer)((Object)s));
                }
                MultiTarget multi = new MultiTarget(command);
                multi.add(existingTarget);
                multi.add(target);
                if (!s.setTarget(multi) || !(s instanceof Observer)) continue;
                multi.getGroup().addObserver((Observer)((Object)s));
            }
        }
        group.setManager(this);
    }

    public synchronized void add(CommandSource source) {
        if (this.sources.add(source) && this.started) {
            this.linkCommandSource(source);
        }
    }

    public void handleCommandError(Throwable x) {
        System.err.println("Error during command invocation");
        x.printStackTrace();
    }

    public synchronized void remove(CommandGroup group) {
        if (this.groups.remove(group) && this.started) {
            for (CommandSource s : this.sources) {
                CommandTarget target = s.getTarget();
                if (target == null) continue;
                if (target.getGroup() == group) {
                    s.clearTarget();
                    if (!(s instanceof Observer)) continue;
                    group.deleteObserver((Observer)((Object)s));
                    continue;
                }
                if (!(target instanceof MultiTarget)) continue;
                ((MultiTarget)target).removeGroup(group);
            }
        }
        group.setManager(null);
    }

    public synchronized void remove(CommandSource source) {
        CommandTarget t;
        if (this.sources.remove(source) && this.started && (t = source.getTarget()) != null) {
            source.clearTarget();
            if (source instanceof Observer) {
                t.getGroup().deleteObserver((Observer)((Object)source));
            }
        }
    }

    public synchronized void start() {
        this.started = true;
        Iterator i = this.sources.iterator();
        while (i.hasNext()) {
            this.linkCommandSource((CommandSource)i.next());
        }
    }

    public void dump(PrintStream out) {
        Dumper dumper = new Dumper(this.started, this.sources, this.groups);
        dumper.dump(out);
    }

    private void linkCommandSource(CommandSource s) {
        String command = s.getCommand();
        CommandTarget theTarget = null;
        for (CommandGroup g : this.groups) {
            CommandTarget t = g.acceptCommand(command);
            if (t == null) continue;
            if (theTarget == null) {
                theTarget = t;
                continue;
            }
            if (theTarget instanceof MultiTarget) {
                ((MultiTarget)theTarget).add(t);
                continue;
            }
            MultiTarget multi = new MultiTarget(command);
            multi.add(theTarget);
            multi.add(t);
            theTarget = multi;
        }
        if (theTarget != null && s.setTarget(theTarget) && s instanceof Observer) {
            theTarget.getGroup().addObserver((Observer)((Object)s));
        }
    }
}

