/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.agent.command;

import java.time.Duration;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.lsst.ccs.Agent;
import org.lsst.ccs.gconsole.agent.command.CommandHandle;
import org.lsst.ccs.gconsole.agent.command.CommandTask;
import org.lsst.ccs.messaging.AgentMessagingLayer;
import org.lsst.ccs.utilities.scheduler.Scheduler;

public class CommandSender {
    final AgentMessagingLayer messenger;
    final Executor callbackExecutor;
    final Executor workerExecutor;
    final Scheduler timer;
    private volatile Duration defaultTimeout = Duration.ofSeconds(10L);
    private volatile CommandHandle defaultCommandHandle;

    public CommandSender(AgentMessagingLayer messenger, Executor callbackExecutor, Executor workerExecutor, Scheduler timer) {
        if (messenger == null) {
            messenger = Agent.getEnvironmentMessagingAccess();
        }
        this.messenger = messenger;
        if (callbackExecutor == null || workerExecutor == null) {
            ThreadFactory threadFactory = new ThreadFactory(){
                private final ThreadFactory delegate = Executors.defaultThreadFactory();

                @Override
                public Thread newThread(Runnable r) {
                    Thread thread = this.delegate.newThread(r);
                    thread.setDaemon(true);
                    return thread;
                }
            };
            if (callbackExecutor == null) {
                callbackExecutor = Executors.newSingleThreadExecutor(threadFactory);
            }
            if (workerExecutor == null) {
                workerExecutor = new ThreadPoolExecutor(0, 2, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), threadFactory);
            }
        }
        this.callbackExecutor = callbackExecutor;
        this.workerExecutor = workerExecutor;
        this.timer = timer;
    }

    public void setTimeout(Duration defaultTimeout) {
        if (defaultTimeout == null) {
            throw new IllegalArgumentException("Illegal default timeout value: " + defaultTimeout);
        }
        this.defaultTimeout = defaultTimeout;
    }

    public void setCommandHandle(CommandHandle defaultCommandHandle) {
        this.defaultCommandHandle = defaultCommandHandle;
    }

    public CommandTask execute(CommandHandle handle, Duration timeout, String command, Object ... args) {
        if (handle == null) {
            handle = this.defaultCommandHandle;
        }
        int i = command.lastIndexOf("/");
        String destination = command.substring(0, i);
        command = command.substring(i + 1);
        CommandTask task = new CommandTask(this, handle, timeout, destination, command, args);
        task.send();
        return task;
    }

    public CommandTask execute(Duration timeout, String command, Object ... args) {
        return this.execute(this.defaultCommandHandle, timeout, command, args);
    }

    public CommandTask execute(CommandHandle handle, String command, Object ... args) {
        return this.execute(handle, this.defaultTimeout, command, args);
    }

    public CommandTask execute(String command, Object ... args) {
        return this.execute(this.defaultCommandHandle, this.defaultTimeout, command, args);
    }

    public CommandTask sendRaw(CommandHandle handle, Duration timeout, String destination, String command, Object ... args) {
        if (handle == null) {
            handle = this.defaultCommandHandle;
        }
        if (timeout == null) {
            throw new IllegalArgumentException();
        }
        CommandTask task = new CommandTask(this, handle, timeout, destination, command, args);
        task.send();
        return task;
    }

    public CommandTask sendRaw(Duration timeout, String destination, String command, Object ... args) {
        return this.sendRaw(this.defaultCommandHandle, timeout, destination, command, args);
    }

    public CommandTask sendRaw(CommandHandle handle, String destination, String command, Object ... args) {
        return this.sendRaw(handle, this.defaultTimeout, destination, command, args);
    }

    public CommandTask sendRaw(String destination, String command, Object ... args) {
        return this.sendRaw(this.defaultCommandHandle, this.defaultTimeout, destination, command, args);
    }

    public CommandTask sendEncoded(CommandHandle handle, Duration timeout, String destination, String command, String ... args) {
        if (handle == null) {
            handle = this.defaultCommandHandle;
        }
        if (args == null) {
            throw new IllegalArgumentException();
        }
        StringBuilder sb = new StringBuilder(command);
        for (String arg : args) {
            if (arg.isEmpty() || arg.contains(" ") && !arg.startsWith(" \"") && !arg.startsWith(" \"")) {
                sb.append(" ").append(" \"").append(arg).append("\"");
                continue;
            }
            sb.append(" ").append(arg);
        }
        CommandTask task = new CommandTask(destination, sb.toString(), this, handle, timeout);
        task.send();
        return task;
    }

    public CommandTask sendEncoded(Duration timeout, String destination, String command, String ... args) {
        return this.sendEncoded(this.defaultCommandHandle, timeout, destination, command, args);
    }

    public CommandTask sendEncoded(CommandHandle handle, String destination, String command, String ... args) {
        return this.sendEncoded(handle, this.defaultTimeout, destination, command, args);
    }

    public CommandTask sendEncoded(String destination, String command, String ... args) {
        return this.sendEncoded(this.defaultCommandHandle, this.defaultTimeout, destination, command, args);
    }

    public CommandTask send(CommandHandle handle, Duration timeout, String destination, String commandName, String arguments) {
        if (handle == null) {
            handle = this.defaultCommandHandle;
        }
        String command = arguments == null || arguments.isEmpty() ? commandName : commandName + " " + arguments;
        CommandTask task = new CommandTask(destination, command, this, handle, timeout);
        task.send();
        return task;
    }

    public CommandTask send(Duration timeout, String destination, String commandName, String arguments) {
        return this.send(this.defaultCommandHandle, timeout, destination, commandName, arguments);
    }

    public CommandTask send(CommandHandle handle, String destination, String commandName, String arguments) {
        return this.send(handle, this.defaultTimeout, destination, commandName, arguments);
    }

    public CommandTask send(String destination, String commandName, String arguments) {
        return this.send(this.defaultCommandHandle, this.defaultTimeout, destination, commandName, arguments);
    }

    public CommandTask send(CommandHandle handle, Duration timeout, String destination, String command) {
        if (handle == null) {
            handle = this.defaultCommandHandle;
        }
        CommandTask task = new CommandTask(destination, command, this, handle, timeout);
        task.send();
        return task;
    }

    public CommandTask send(Duration timeout, String destination, String command) {
        return this.send(this.defaultCommandHandle, timeout, destination, command);
    }

    public CommandTask send(CommandHandle handle, String destination, String command) {
        return this.send(handle, this.defaultTimeout, destination, command);
    }

    public CommandTask send(String destination, String command) {
        return this.send(this.defaultCommandHandle, this.defaultTimeout, destination, command);
    }

    public CommandTask send(CommandHandle handle, Duration timeout, String command) {
        if (handle == null) {
            handle = this.defaultCommandHandle;
        }
        String[] ss = command.split("\\s", 2);
        CommandTask task = new CommandTask(ss[0], ss[1], this, handle, timeout);
        task.send();
        return task;
    }

    public CommandTask send(Duration timeout, String command) {
        return this.send(this.defaultCommandHandle, timeout, command);
    }

    public CommandTask send(CommandHandle handle, String command) {
        return this.send(handle, this.defaultTimeout, command);
    }

    public CommandTask send(String command) {
        return this.send(this.defaultCommandHandle, this.defaultTimeout, command);
    }
}

