/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.monitor;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorField;
import org.lsst.ccs.gconsole.plugins.monitor.Updatable;
import org.lsst.ccs.gconsole.services.aggregator.AgentChannel;

public interface DisplayChannel {
    public String getPath();

    public Updatable getTarget();

    public void setTarget(Updatable var1);

    default public AgentChannel getChannel() {
        List<AgentChannel> out = this.getChannels();
        switch (out.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return out.get(0);
            }
        }
        return null;
    }

    default public List<AgentChannel> getChannels() {
        AgentChannel ch = this.getChannel();
        return ch == null ? Collections.emptyList() : Collections.singletonList(ch);
    }

    public void setChannel(AgentChannel var1);

    default public void setChannels(Collection<AgentChannel> channels) {
        switch (channels.size()) {
            case 0: {
                this.setChannel(null);
                break;
            }
            case 1: {
                this.setChannel(channels.iterator().next());
                break;
            }
            default: {
                throw new UnsupportedOperationException("This display channel cannot be associated with multiple original channels.");
            }
        }
    }

    default public void addChannel(AgentChannel channel) {
        throw new UnsupportedOperationException("This display channel cannot be associated with multiple original channels.");
    }

    default public void appendChannel(AgentChannel channel) {
        this.addChannel(channel);
    }

    default public boolean removeChannel(String path) {
        throw new UnsupportedOperationException("This display channel cannot be associated with multiple original channels.");
    }

    default public boolean purgeOfflineChannels(List<String> agentNames) {
        return false;
    }

    default public void update(List<String> attributes) {
        Updatable target = this.getTarget();
        if (target != null) {
            if (attributes == null) {
                target.update(this);
            } else {
                List<MonitorField> fields = target.getAffectedFields(attributes);
                if (fields == null) {
                    target.update(this);
                } else if (!fields.isEmpty()) {
                    target.update(this, fields);
                }
            }
        }
    }
}

