/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.jas;

import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.Authenticator;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.util.Enumeration;
import java.util.Properties;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import org.freehep.application.Application;
import org.freehep.application.PropertyUtilities;
import org.freehep.application.studio.PluginDir;
import org.freehep.application.studio.Studio;
import org.freehep.graphicsbase.util.export.ExportFileType;
import org.freehep.jas.GeneralPreferences;
import org.freehep.jas.plugin.xmlio.XMLIOPlugin;
import org.freehep.jas.services.PreferencesTopic;
import org.freehep.jas.services.WebBrowser;
import org.freehep.jas.util.waitcursor.WaitCursorEventQueue;
import org.freehep.util.commanddispatcher.CommandState;
import org.freehep.util.commandline.CommandLine;
import org.freehep.xml.menus.XMLMenuBuilder;
import org.openide.util.Lookup;

public class JAS3
extends Studio {
    private XMLIOPlugin xmlioPlugin;
    public static final File BUILTIN = new File("");

    public JAS3() {
        this("JAS3");
    }

    public JAS3(String applicationName) {
        super(applicationName);
        this.setPluginManagerName("Plugin Manager");
        Policy.setPolicy(new Policy(){

            @Override
            public PermissionCollection getPermissions(CodeSource codesource) {
                Permissions perms = new Permissions();
                perms.add(new AllPermission());
                return perms;
            }

            @Override
            public void refresh() {
            }
        });
    }

    @Override
    protected CommandLine createCommandLine() {
        CommandLine cl = super.createCommandLine();
        cl.addOption("startPage", "s", "url", "URL for the welcome page");
        cl.addOption("title", "t", "window title", "Title for the window");
        cl.addOption("open", null, "file", "File to open");
        cl.addParameter("file...", "Files to be read in");
        return cl;
    }

    @Override
    protected void init() {
        Properties prop = this.getAppProperties();
        String version = prop.getProperty("version");
        if (version != null && version.endsWith("-SNAPSHOT")) {
            prop.setProperty("version", version.substring(0, version.length() - 9));
        }
        this.setURLStreamHandlerFactory(new JAS3StreamHandlerFactory());
        Authenticator.setDefault(new JAS3Authenticator());
        URLConnection.setDefaultAllowUserInteraction(true);
        this.getLookup().add((Object)new Preferences());
        this.blacklistPlugin("LCIO", null, "1.4.0");
        this.blacklistPlugin("HepRep Plugin", null, "1.4.3");
        super.init();
        int cursorDelay = PropertyUtilities.getInteger(this.getUserProperties(), "waitCursorDelay", 250);
        if (cursorDelay > 0) {
            WaitCursorEventQueue waitQueue = new WaitCursorEventQueue(cursorDelay);
            Toolkit.getDefaultToolkit().getSystemEventQueue().push(waitQueue);
        }
        ExportFileType.setClassLoader((ClassLoader)this.getExtensionLoader());
        XMLMenuBuilder.setClassLoader((ClassLoader)this.getExtensionLoader());
        String title = this.getCommandLine().getOption("title");
        if (title != null) {
            this.getAppProperties().setProperty("title", title);
        }
        this.xmlioPlugin = (XMLIOPlugin)this.getLookup().lookup(XMLIOPlugin.class);
        if (this.xmlioPlugin != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JAS3.this.xmlioPlugin.restoreAtStart();
                }
            });
        }
    }

    protected void setURLStreamHandlerFactory(URLStreamHandlerFactory factory) {
        URL.setURLStreamHandlerFactory(factory);
    }

    @Override
    public String getExtensionsDir(PluginDir dir) {
        String out = null;
        switch (dir) {
            case BUILTIN: {
                String path = System.getProperty("application.home");
                if (path != null) {
                    try {
                        return new File(path, "lib").getCanonicalPath();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                return null;
            }
            case SYSTEM: {
                return System.getProperty("application.home") == null ? null : super.getExtensionsDir(dir);
            }
        }
        if (out == null) {
            return super.getExtensionsDir(dir);
        }
        try {
            out = new File(out).getCanonicalPath();
        }
        catch (IOException x) {
            out = null;
        }
        return out;
    }

    @Override
    protected Properties createAppProperties() throws Application.InitializationException {
        Properties p = new Properties(super.createAppProperties());
        Enumeration<?> en = p.propertyNames();
        while (en.hasMoreElements()) {
            String name = en.nextElement().toString();
            if (!name.startsWith("jnlp.")) continue;
            p.setProperty(name.substring(5), p.getProperty(name));
        }
        return p;
    }

    @Override
    protected void saveUserProperties() {
        super.saveUserProperties();
        if (this.xmlioPlugin != null) {
            boolean bl = this.xmlioPlugin.saveAtExit();
        }
    }

    public void onViewDocumentation() throws MalformedURLException {
        this.showWebPage("Documentation.URL");
    }

    public void enableViewDocumentation(CommandState state) {
        this.hasWebBrowser(state);
    }

    public void onViewForum() throws MalformedURLException {
        this.showWebPage("Forum.URL");
    }

    public void enableViewForum(CommandState state) {
        this.hasWebBrowser(state);
    }

    public void onReportBug() throws MalformedURLException {
        this.showWebPage("BugReport.URL");
    }

    public void enableReportBug(CommandState state) {
        this.hasWebBrowser(state);
    }

    public void onExamples() throws MalformedURLException {
        WebBrowser webBrowser = (WebBrowser)this.getLookup().lookup(WebBrowser.class);
        webBrowser.showURL(new URL("classpath:/org/freehep/jas/web/examples.html"));
    }

    public void enableExamples(CommandState state) {
        this.hasWebBrowser(state);
    }

    private void hasWebBrowser(CommandState state) {
        state.setEnabled(this.getLookup().lookup(WebBrowser.class) != null);
    }

    private void showWebPage(String property) throws MalformedURLException {
        WebBrowser webBrowser = (WebBrowser)this.getLookup().lookup(WebBrowser.class);
        webBrowser.showURL(new URL(this.getUserProperties().getProperty(property)), true);
    }

    public static void main(String[] args) {
        String title = "JAS3";
        for (String s : args) {
            String[] tokens = s.split("=");
            if (tokens.length != 2 || !"-Dtitle".equals(tokens[0].trim())) continue;
            title = tokens[1].trim();
        }
        try {
            new JAS3(title).createFrame(args).setVisible(true);
        }
        catch (HeadlessException x) {
            System.out.println("Fatal Error: " + x.getMessage());
        }
        catch (Throwable t) {
            System.out.println("Fatal Error: " + t.getMessage());
            JAS3.error(null, "Fatal Error", t);
            System.exit(1);
        }
    }

    @Override
    public void addToolBar(JToolBar toolBar, String name, int mode) {
        toolBar.setRollover(true);
        super.addToolBar(toolBar, name, mode);
    }

    private class JAS3Authenticator
    extends Authenticator {
        private String[] fields = new String[]{"requestingHost", "requestingSite", "requestingPort", "requestingProtocol", "requestingPrompt", "requestingScheme"};

        private JAS3Authenticator() {
        }

        @Override
        protected PasswordAuthentication getPasswordAuthentication() {
            try {
                String protocol = this.getRequestingProtocol();
                Lookup.Template template = new Lookup.Template(Authenticator.class, protocol, null);
                Lookup.Item item = JAS3.this.getLookup().lookupItem(template);
                if (item == null) {
                    return null;
                }
                Authenticator auth = (Authenticator)item.getInstance();
                for (int i = 0; i < this.fields.length; ++i) {
                    Field f = Authenticator.class.getDeclaredField(this.fields[i]);
                    f.setAccessible(true);
                    f.set(auth, f.get(this));
                }
                Method method = auth.getClass().getDeclaredMethod("getPasswordAuthentication", null);
                method.setAccessible(true);
                return (PasswordAuthentication)method.invoke((Object)auth, (Object[])null);
            }
            catch (Throwable t) {
                t.printStackTrace();
                return null;
            }
        }
    }

    private class JAS3StreamHandlerFactory
    implements URLStreamHandlerFactory {
        private JAS3StreamHandlerFactory() {
        }

        @Override
        public URLStreamHandler createURLStreamHandler(String protocol) {
            if ("http".equals(protocol)) {
                return null;
            }
            if ("jar".equals(protocol)) {
                return null;
            }
            if ("file".equals(protocol)) {
                return null;
            }
            if ("ftp".equals(protocol)) {
                return null;
            }
            Lookup.Template template = new Lookup.Template(URLStreamHandler.class, protocol, null);
            Lookup.Item item = JAS3.this.getLookup().lookupItem(template);
            return item == null ? null : (URLStreamHandler)item.getInstance();
        }
    }

    private class Preferences
    implements PreferencesTopic {
        private Preferences() {
        }

        @Override
        public boolean apply(JComponent panel) {
            return ((GeneralPreferences)panel).apply();
        }

        @Override
        public JComponent component() {
            return new GeneralPreferences(JAS3.this);
        }

        @Override
        public String[] path() {
            return new String[]{"General"};
        }
    }
}

