/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.services;

import java.io.Serializable;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.lsst.ccs.ConfigurationService;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.AgentLock;
import org.lsst.ccs.bus.data.AgentLockInfo;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.bus.data.ConfigurationParameterInfo;
import org.lsst.ccs.bus.messages.CommandRequest;
import org.lsst.ccs.bus.messages.StatusConfigurationData;
import org.lsst.ccs.bus.messages.StatusConfigurationInfo;
import org.lsst.ccs.bus.messages.StatusLock;
import org.lsst.ccs.bus.messages.StatusLockAggregate;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusStateChangeNotification;
import org.lsst.ccs.bus.states.CommandState;
import org.lsst.ccs.bus.states.OperationalState;
import org.lsst.ccs.messaging.AgentMessagingLayer;
import org.lsst.ccs.messaging.BusMessageFilterFactory;
import org.lsst.ccs.messaging.CommandRejectedException;
import org.lsst.ccs.messaging.ConcurrentMessagingUtils;
import org.lsst.ccs.messaging.StatusMessageListener;
import org.lsst.ccs.services.AbstractAgentLockServiceDelegate;
import org.lsst.ccs.services.AgentLockService;
import org.lsst.ccs.services.UnauthorizedLevelException;
import org.lsst.ccs.services.UnauthorizedLockException;

public class RemoteAgentLockService
extends AbstractAgentLockServiceDelegate {
    private AgentMessagingLayer aml;
    private ConcurrentMessagingUtils cmu;
    private final Map<String, Integer> maxLevelsAgent = Collections.synchronizedMap(new HashMap());
    private Map<String, Integer> maxLevelsUser;
    StatusMessageListener sml = msg -> {
        block18: {
            log.fine((Object)("message " + msg + " object " + msg.getObject()));
            if ("lockmanager".equals(msg.getOriginAgentInfo().getName()) && (msg instanceof StatusConfigurationInfo || msg instanceof StatusConfigurationData)) {
                try {
                    ConfigurationInfo cf = ((StatusConfigurationInfo)msg).getConfigurationInfo();
                    ConfigurationParameterInfo cpi = cf.getCurrentParameterInfo("/maxLevelMap");
                    if (cpi == null) break block18;
                    Map config = (Map)cpi.getCurrentValueObject();
                    AgentInfo thisAgent = this.svc.getAgent().getAgentInfo();
                    Map<String, Integer> levelsAgent = AgentLockService.getMaxLevelsSubsystem(thisAgent.getName(), config);
                    Map<String, Integer> levelsUser = thisAgent.getType() == AgentInfo.AgentType.CONSOLE ? AgentLockService.getMaxLevelsUser(this.svc.getUserId(), config) : null;
                    Map<String, Integer> map = this.maxLevelsAgent;
                    synchronized (map) {
                        this.maxLevelsAgent.clear();
                        this.maxLevelsAgent.putAll(levelsAgent);
                        if (levelsUser != null) {
                            this.maxLevelsUser = levelsUser;
                        } else if (this.maxLevelsUser != null) {
                            this.maxLevelsUser = AgentLockService.getMaxLevelsUser(this.svc.getUserId(), config);
                        }
                        log.fine((Object)"Processing StatusConfigurationInfo:");
                        log.fine((Object)("maxLevelsAgent: " + this.maxLevelsAgent));
                        log.fine((Object)("maxLevelsUser: " + this.maxLevelsUser));
                    }
                }
                catch (RuntimeException x) {
                    log.warn((Object)"Unable to process lockmanager configuration", (Throwable)x);
                }
            }
        }
        if (!(msg instanceof StatusLock || msg instanceof StatusLockAggregate || msg instanceof StatusStateChangeNotification)) {
            return;
        }
        if (msg instanceof StatusStateChangeNotification) {
            String agentName;
            StatusStateChangeNotification ssnc = (StatusStateChangeNotification)msg;
            if (ssnc.getState().isInState((Enum)OperationalState.NORMAL) && ssnc.getState().isInState((Enum)CommandState.READY) && this.heldLocks.get(agentName = ssnc.getOriginAgentInfo().getName()) != null && this.getLevelForAgent(agentName) > 0) {
                try {
                    System.out.println("level set to 0");
                    log.info((Object)(agentName + " went to NORMAL mode, lock level set to 0"));
                    this.setLevelInternal(agentName, 0);
                }
                catch (UnauthorizedLevelException config) {
                    // empty catch block
                }
            }
            return;
        }
        Serializable obj = msg.getObject();
        String source = msg.getOriginAgentInfo().getName();
        if (obj instanceof AgentLockInfo) {
            this.handleLockInfo(source, (AgentLockInfo)obj);
        } else if (obj instanceof AgentLockInfo[]) {
            AgentLockInfo[] ll;
            for (AgentLockInfo l : ll = (AgentLockInfo[])obj) {
                this.handleLockInfo(source, l);
            }
        }
    };

    public RemoteAgentLockService(AgentLockService svc) {
        super(svc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleLockInfo(String source, AgentLockInfo lock) {
        log.debug((Object)("got lock message from " + source + " : " + lock));
        boolean fromLM = "lockmanager".equals(source);
        boolean lockingMe = lock.getAgentName().equals(this.getAgent().getName());
        if (lock.getStatus() == AgentLockInfo.Status.ACKNOWLEDGED || lock.getStatus() == AgentLockInfo.Status.REMINDER || lock.getStatus() == AgentLockInfo.Status.INFO || lock.getStatus() == AgentLockInfo.Status.ACK_LEGACY) {
            this.allLocks.put(lock.getAgentName(), lock);
            this.notifyGlobalLockListeners(lock.getAgentName(), (AgentLock)lock);
        } else if (lock.getStatus() == AgentLockInfo.Status.ATTACH || lock.getStatus() == AgentLockInfo.Status.DETACH) {
            this.notifyGlobalLockListeners(lock.getAgentName(), (AgentLock)lock);
        } else if (lock.getStatus() == AgentLockInfo.Status.RELEASED) {
            this.allLocks.remove(lock.getAgentName());
            if (this.heldLocks.get(lock.getAgentName()) != null) {
                log.info((Object)("Release lock on " + lock.getAgentName()));
            }
            try {
                this.removeHeldLock(lock.getAgentName(), (AgentLock)lock);
            }
            catch (UnauthorizedLockException unauthorizedLockException) {
                // empty catch block
            }
            this.notifyGlobalLockListeners(lock.getAgentName(), (AgentLock)lock);
        }
        if (lock.getStatus() == AgentLockInfo.Status.RELEASED && lockingMe && fromLM) {
            log.debug((Object)"releasing current lock");
            this.removeCurrentLock();
        } else if (lock.getStatus() == AgentLockInfo.Status.REQUESTED && fromLM && lockingMe) {
            log.debug((Object)("got request " + lock));
            AgentLockInfo reply = null;
            Object object = this.listenerUpdatesLock;
            synchronized (object) {
                AgentLock oldLock = this.getLockForAgent(this.getAgent().getName());
                if (oldLock != null && !oldLock.getOwner().equals(lock.getOwner())) {
                    reply = AgentLockInfo.createReject((AgentLockInfo)lock);
                    log.warn((Object)("Rejecting invalid lock request " + reply));
                } else {
                    reply = AgentLockInfo.createAcknowledge((AgentLockInfo)lock);
                    log.debug((Object)("ack " + reply));
                    this.setCurrentLock((AgentLock)reply);
                }
            }
            StatusLock replyMsg = new StatusLock(reply);
            this.aml.sendStatusMessage((StatusMessage)replyMsg);
        } else if (lock.getStatus() == AgentLockInfo.Status.REMINDER && fromLM && lockingMe) {
            if (lock.getAgentName().equals(this.getAgent().getName())) {
                log.info((Object)("got reminder " + lock));
                if (this.getCurrentLock() != null && !this.getCurrentLock().getToken().equals(lock.getToken())) {
                    log.warn((Object)("lock reminder but we are locked: " + this.getCurrentLock()));
                } else if (this.getCurrentLock() == null) {
                    this.setCurrentLock((AgentLock)lock);
                }
            }
        } else if ((lock.getStatus() == AgentLockInfo.Status.ATTACH || lock.getStatus() == AgentLockInfo.Status.DETACH) && fromLM && lockingMe) {
            this.notifyLockListeners(lock.getAgentName(), lock.getOwner(), (AgentLock)lock);
        }
    }

    @Override
    public void preInit() {
        super.preInit();
        this.aml = this.getAgent().getMessagingAccess();
        this.cmu = new ConcurrentMessagingUtils(this.aml);
        this.getAgent().getAgentInfo().getAgentProperties().setProperty("lockable", "true");
    }

    @Override
    public void preStart() {
        log.finest((Object)"adding lock message listener");
        this.aml.addStatusMessageListener(this.sml, BusMessageFilterFactory.embeddedObjectClass(AgentLockInfo.class).or(BusMessageFilterFactory.embeddedObjectClass(AgentLockInfo[].class)).or(BusMessageFilterFactory.messageClass(StatusStateChangeNotification.class)).or(BusMessageFilterFactory.messageClass(StatusConfigurationInfo.class)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onAgentLoginUpdate(String oldUserId, String newUserId) {
        super.onAgentLoginUpdate(oldUserId, newUserId);
        Map<String, Integer> map = this.maxLevelsAgent;
        synchronized (map) {
            this.maxLevelsUser = null;
        }
    }

    @Override
    public void setLevelForAgent(String agentName, int level) throws UnauthorizedLevelException, UnauthorizedLockException {
        if ("lockmanager".equals(agentName)) {
            throw new UnauthorizedLockException("The lock manager subsystem cannot be locked");
        }
        AgentLockInfo lock = null;
        lock = (AgentLockInfo)this.heldLocks.get(agentName);
        if (lock == null) {
            try {
                AgentLockInfo request = AgentLockInfo.createLockRequest((String)agentName, (String)this.svc.getUserId(), (AgentInfo)this.getAgent().getAgentInfo());
                lock = (AgentLockInfo)this.cmu.sendSynchronousCommand(new CommandRequest("lockmanager", "lockOrAttach", new Object[]{request}));
                if (lock != null) {
                    this.addHeldLock((AgentLock)lock);
                }
            }
            catch (RuntimeException | UnauthorizedLevelException | UnauthorizedLockException e) {
                throw e;
            }
            catch (CommandRejectedException e) {
                throw new UnauthorizedLockException(e.getMessage());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (lock == null || !this.svc.getUserId().equals(lock.getOwner())) {
            throw new UnauthorizedLockException("Unable to lock " + agentName + ", cannot set level");
        }
        int maxLevel = lock.getMaxLevel();
        if (level > maxLevel) {
            this.setLevelInternal(agentName, maxLevel);
            throw new UnauthorizedLevelException("User '" + lock.getOwner() + "' is not allowed to set level above '" + lock.getMaxLevel() + "' for subsystem '" + agentName + "'");
        }
        this.setLevelInternal(agentName, level);
    }

    @Override
    public void attachLock(String agentName) throws UnauthorizedLockException {
        try {
            AgentLockInfo request = AgentLockInfo.createAttachRequest((String)agentName, (String)this.svc.getUserId(), (AgentInfo)this.getAgent().getAgentInfo());
            AgentLockInfo lock = (AgentLockInfo)this.cmu.sendSynchronousCommand(new CommandRequest("lockmanager", "attachLock", new Object[]{request}));
            log.info((Object)("received lock for attach " + lock));
            this.addHeldLock((AgentLock)lock);
        }
        catch (RuntimeException | UnauthorizedLockException e) {
            throw e;
        }
        catch (CommandRejectedException e) {
            throw new UnauthorizedLockException(e.getMessage());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void detachLock(String agentName) throws UnauthorizedLockException {
        try {
            AgentLock oldLock = this.getHeldLocks().get(agentName);
            if (oldLock == null || !oldLock.getOwner().equals(this.svc.getUserId())) {
                throw new UnauthorizedLockException("no lock is held to detach");
            }
            AgentLockInfo request = AgentLockInfo.createDetach((String)agentName, (String)this.svc.getUserId(), (AgentInfo)this.getAgent().getAgentInfo());
            this.cmu.sendAsynchronousCommand(new CommandRequest("lockmanager", "detachLock", new Object[]{request}));
            this.removeHeldLock(agentName, (AgentLock)request);
        }
        catch (RuntimeException | UnauthorizedLockException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void lockAgent(String agentName) throws UnauthorizedLockException {
        if ("lockmanager".equals(agentName)) {
            throw new UnauthorizedLockException("The lock manager subsystem cannot be locked");
        }
        try {
            AgentLockInfo request = AgentLockInfo.createLockRequest((String)agentName, (String)this.svc.getUserId(), (AgentInfo)this.getAgent().getAgentInfo());
            AgentLockInfo lock = (AgentLockInfo)this.cmu.sendSynchronousCommand(new CommandRequest("lockmanager", "lockAgent", new Object[]{request}));
            log.info((Object)("received lock " + lock));
            if (lock == null) {
                throw new UnauthorizedLockException("Unable to lock " + agentName);
            }
            this.addHeldLock((AgentLock)lock);
            this.allLocks.put(agentName, lock);
        }
        catch (RuntimeException | UnauthorizedLockException e) {
            throw e;
        }
        catch (CommandRejectedException e) {
            throw new UnauthorizedLockException(e.getMessage());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void unlockAgent(String agentName) throws UnauthorizedLockException {
        AgentLock oldLock = this.getExistingLockForAgent(agentName);
        if (oldLock == null) {
            return;
        }
        if (!oldLock.getOwner().equals(this.svc.getUserId())) {
            throw new UnauthorizedLockException("Subsystem " + agentName + " is locked by " + oldLock.getOwner() + ", you are logged in as " + this.svc.getUserId() + ". Cannot unlock.");
        }
        AgentLockInfo request = AgentLockInfo.createRelease((String)agentName, (String)this.svc.getUserId());
        this.cmu.sendAsynchronousCommand(new CommandRequest("lockmanager", "unlockAgent", new Object[]{request}));
        this.removeHeldLock(agentName, (AgentLock)request);
    }

    @Override
    public void destroyLock(String agentName, String userId) {
        try {
            this.cmu.sendSynchronousCommand(new CommandRequest("lockmanager", "destroyLock", new Object[]{agentName, userId}));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMaxLevel(String user, String agentName) {
        if (this.enforceLevel == 0) {
            return "ccs".equals(user) ? 0 : 99;
        }
        String myName = this.getAgent().getName();
        Integer out = null;
        if (myName.equals("lockmanager")) {
            try {
                Map config = (Map)this.getAgent().getAgentService(ConfigurationService.class).getConfigurationInfo().getCurrentParameterInfo("/maxLevelMap").getCurrentValueObject();
                Map<String, Integer> userLevels = AgentLockService.getMaxLevelsUser(user, config);
                out = AgentLockService.getMaxLevel(agentName, userLevels);
            }
            catch (RuntimeException x) {
                log.warning((Object)("Unable to compute maximum level: user = " + user + ", subsystem = " + agentName), (Throwable)x);
            }
        } else if (myName.equals(agentName)) {
            out = this.maxLevelsAgent.get(user);
            if (out == null) {
                CommandRequest command = new CommandRequest("lockmanager", "getMaxLevelSubsystem", new Object[]{myName});
                try {
                    Map result = (Map)this.cmu.sendSynchronousCommand(command, Duration.ofSeconds(10L));
                    log.fine((Object)("Sent getMaxLevelSubsystem, got: " + result));
                    Map<String, Integer> map = this.maxLevelsAgent;
                    synchronized (map) {
                        this.maxLevelsAgent.clear();
                        this.maxLevelsAgent.putAll(result);
                        out = (Integer)result.get(user);
                    }
                }
                catch (Exception x) {
                    log.log(Level.FINE, "Failed to fetch max level for subsystem " + agentName, (Throwable)x);
                }
            }
        } else {
            if (user.equals(this.svc.getUserId())) {
                block28: {
                    boolean needRefresh;
                    Map<String, Integer> x = this.maxLevelsAgent;
                    synchronized (x) {
                        needRefresh = this.maxLevelsUser == null;
                    }
                    if (needRefresh) {
                        CommandRequest command = new CommandRequest("lockmanager", "getMaxLevelUser", new Object[]{user});
                        try {
                            Map result = (Map)this.cmu.sendSynchronousCommand(command, Duration.ofSeconds(10L));
                            log.fine((Object)("Sent getMaxLevelUser, got: " + result));
                            if (result == null) break block28;
                            Map<String, Integer> map = this.maxLevelsAgent;
                            synchronized (map) {
                                this.maxLevelsUser = new HashMap<String, Integer>(result);
                            }
                        }
                        catch (Exception x2) {
                            log.log(Level.FINE, "Failed to fetch max level for user " + user, (Throwable)x2);
                            return 0;
                        }
                    }
                }
                Map<String, Integer> map = this.maxLevelsAgent;
                synchronized (map) {
                    if (this.maxLevelsUser != null) {
                        out = AgentLockService.getMaxLevel(agentName, this.maxLevelsUser);
                    }
                }
            }
            log.warn((Object)("Unsupported getMaxLevel(user = " + user + ", agent = " + agentName + ". Current user: " + this.svc.getUserId()));
        }
        return out == null ? 0 : out;
    }
}

