/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.monitor;

import java.awt.Point;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.JTable;
import org.lsst.ccs.gconsole.plugins.monitor.DefaultMonitorCell;
import org.lsst.ccs.gconsole.plugins.monitor.DisplayChannel;
import org.lsst.ccs.gconsole.plugins.monitor.FormattedValue;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorCell;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorField;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorTable;
import org.lsst.ccs.gconsole.plugins.monitor.Updatable;

public class SectionedTable
extends MonitorTable {
    private List<MonitorField> columns;
    private LinkedHashMap<String, List<Map.Entry<String, DisplayChannel>>> sections;
    private Set<String> expandedSections;

    public static SectionedTable getInstance(Collection<Map.Entry<String, DisplayChannel>> channels, List<MonitorField> fields, Descriptor descriptor) {
        SectionedTable instance = new SectionedTable();
        instance.init(channels, fields, descriptor);
        return instance;
    }

    private SectionedTable() {
    }

    public void init(Collection<Map.Entry<String, DisplayChannel>> channels, List<MonitorField> fields, Descriptor descriptor) {
        if (descriptor != null) {
            this.setLimitMaxWidth(descriptor.isLimitMaxWidth());
        }
        List<DisplayChannel> handles = channels.stream().map(e -> (DisplayChannel)e.getValue()).collect(Collectors.toList());
        this.columns = SectionedTable.trimAbsentFields(fields, handles, null);
        this.nColumns = this.columns.size() + 1;
        this.sections = new LinkedHashMap();
        ArrayList<Map.Entry<String, DisplayChannel>> defSection = new ArrayList<Map.Entry<String, DisplayChannel>>();
        this.sections.put("", defSection);
        for (Map.Entry<String, DisplayChannel> e2 : channels) {
            String dpath = e2.getKey();
            int i = dpath.indexOf("//");
            if (i == -1) {
                defSection.add(e2);
                continue;
            }
            String section = dpath.substring(0, i);
            String name = dpath.substring(i + 2);
            List<Map.Entry<String, DisplayChannel>> cc = this.sections.get(section);
            if (cc == null) {
                cc = new ArrayList<Map.Entry<String, DisplayChannel>>();
                this.sections.put(section, cc);
            }
            cc.add(new AbstractMap.SimpleImmutableEntry<String, DisplayChannel>(name, e2.getValue()));
        }
        this.expandedSections = descriptor == null || descriptor.getExpandedSections() == null ? new HashSet<String>(this.sections.keySet()) : new HashSet<String>(Arrays.asList(descriptor.getExpandedSections()));
        int rowOffset = 0;
        this.cells = new ArrayList();
        for (String section : this.sections.keySet()) {
            List<ArrayList<MonitorCell>> rows = this.makeSection(section, rowOffset);
            rowOffset += rows.size();
            this.cells.addAll(rows);
        }
        this.cells.trimToSize();
        this.nRows = this.cells.size();
    }

    @Override
    public void destroy() {
        this.sections.values().forEach(items -> items.forEach(e -> ((DisplayChannel)e.getValue()).setTarget(null)));
    }

    @Override
    public String getColumnName(int column) {
        return column == 0 ? "Channel" : this.columns.get(column - 1).getTitle();
    }

    @Override
    protected void tableMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 1) {
            MonitorCell cell;
            JTable table = (JTable)evt.getSource();
            Point point = evt.getPoint();
            int row = table.rowAtPoint(point);
            int column = table.columnAtPoint(point);
            if (column == 0 && (cell = (MonitorCell)((ArrayList)this.cells.get(row)).get(0)) instanceof SectionTitleCell) {
                SectionTitleCell c = (SectionTitleCell)cell;
                String section = c.getTitle();
                if (c.isCollapsed()) {
                    this.expandSection(row, section);
                } else {
                    this.collapseSection(row, section);
                }
            }
        }
        super.tableMouseClicked(evt);
    }

    private List<ArrayList<MonitorCell>> makeSection(String section, int rowOffset) {
        boolean collapsed;
        List<Map.Entry<String, DisplayChannel>> channels = this.sections.get(section);
        if (channels == null || channels.isEmpty()) {
            return Collections.emptyList();
        }
        boolean bl = collapsed = !section.isEmpty() && !this.expandedSections.contains(section);
        if (collapsed) {
            ArrayList<DefaultMonitorCell> row = new ArrayList<DefaultMonitorCell>(this.nColumns);
            row.add(new SectionTitleCell(section, true));
            RowUpdater updater = new RowUpdater(rowOffset);
            ArrayList<DisplayChannel> handles = new ArrayList<DisplayChannel>(channels.size());
            for (Map.Entry<String, DisplayChannel> e : channels) {
                DisplayChannel ch = e.getValue();
                handles.add(ch);
                ch.setTarget(updater);
            }
            for (MonitorField field : this.columns) {
                DefaultMonitorCell cell = new DefaultMonitorCell(handles, field);
                this.format.format(cell);
                row.add(cell);
            }
            return Collections.singletonList(row);
        }
        ArrayList<ArrayList<MonitorCell>> rows = new ArrayList<ArrayList<MonitorCell>>(channels.size() + 1);
        if (!section.isEmpty()) {
            ArrayList<MonitorCell> row = new ArrayList<MonitorCell>(this.nColumns);
            row.add(new SectionTitleCell(section, false));
            for (MonitorField field : this.columns) {
                row.add(MonitorCell.EMPTY);
            }
            rows.add(row);
            ++rowOffset;
        }
        for (Map.Entry<String, DisplayChannel> channel : channels) {
            ArrayList<DefaultMonitorCell> row = new ArrayList<DefaultMonitorCell>(this.nColumns);
            row.add(new DefaultMonitorCell(null, null, new FormattedValue(" " + channel.getKey() + " ", 2)));
            List<DisplayChannel> handles = Collections.singletonList(channel.getValue());
            for (MonitorField field : this.columns) {
                DefaultMonitorCell cell = new DefaultMonitorCell(handles, field);
                this.format.format(cell);
                row.add(cell);
            }
            rows.add(row);
            RowUpdater updater = new RowUpdater(rowOffset++);
            channel.getValue().setTarget(updater);
        }
        return rows;
    }

    private void expandSection(int row, String section) {
        this.expandedSections.add(section);
        List<ArrayList<MonitorCell>> sectionRows = this.makeSection(section, row);
        this.cells.remove(row);
        this.cells.addAll(row, sectionRows);
        this.nRows = this.cells.size();
        this.updateUpdaters(row + sectionRows.size() - 1);
        this.fireTableRowsUpdated(row, row);
        this.fireTableRowsInserted(row + 1, row + sectionRows.size() - 1);
        this.fireChangeEvent(this.TABLE_EVENT);
    }

    private void collapseSection(int row, String section) {
        this.expandedSections.remove(section);
        List<ArrayList<MonitorCell>> sectionRows = this.makeSection(section, row);
        this.cells.set(row, sectionRows.get(0));
        int sectionSize = this.sections.get(section).size();
        for (int i = 0; i < sectionSize; ++i) {
            this.cells.remove(row + 1);
        }
        this.nRows = this.cells.size();
        this.updateUpdaters(row);
        this.fireTableRowsUpdated(row, row);
        this.fireTableRowsDeleted(row + 1, row + sectionSize);
        this.fireChangeEvent(this.TABLE_EVENT);
    }

    private void updateUpdaters(int row) {
        while (++row < this.nRows) {
            MonitorCell cell = (MonitorCell)((ArrayList)this.cells.get(row)).get(1);
            List<DisplayChannel> handles = cell.getChannels();
            for (DisplayChannel h : handles) {
                RowUpdater updater = (RowUpdater)h.getTarget();
                updater.setRow(row);
            }
        }
    }

    @Override
    public Descriptor save() {
        Descriptor desc = null;
        if (this.expandedSections != null && !this.expandedSections.isEmpty()) {
            desc = new Descriptor();
            desc.setExpandedSections(this.expandedSections.toArray(new String[this.expandedSections.size()]));
            return desc;
        }
        if (this.limitMaxWidth) {
            if (desc == null) {
                desc = new Descriptor();
            }
            desc.setLimitMaxWidth(true);
        }
        return desc;
    }

    public void restore(Descriptor desc) {
    }

    public static class Descriptor
    implements Serializable,
    Cloneable {
        private String[] expandedSections;
        private boolean limitMaxWidth = false;

        public boolean isLimitMaxWidth() {
            return this.limitMaxWidth;
        }

        public void setLimitMaxWidth(boolean limitMaxWidth) {
            this.limitMaxWidth = limitMaxWidth;
        }

        public String[] getExpandedSections() {
            return this.expandedSections;
        }

        public void setExpandedSections(String[] expandedSections) {
            this.expandedSections = expandedSections;
        }

        protected Descriptor clone() {
            try {
                return (Descriptor)super.clone();
            }
            catch (CloneNotSupportedException x) {
                return null;
            }
        }
    }

    private class SectionTitleCell
    extends DefaultMonitorCell {
        final String title;
        final boolean collapsed;

        SectionTitleCell(String title, boolean collapsed) {
            super(null, null, new FormattedValue("<html> " + (collapsed ? "&#8853;" : "&#8854;") + "<b> " + title, null, null, 2, collapsed ? "Click to expand section" : "Click to collaps section", false));
            this.title = title;
            this.collapsed = collapsed;
        }

        public boolean isCollapsed() {
            return this.collapsed;
        }

        String getTitle() {
            return this.title;
        }
    }

    private class RowUpdater
    implements Updatable {
        int row;

        RowUpdater(int row) {
            this.row = row;
        }

        public void setRow(int row) {
            this.row = row;
        }

        @Override
        public List<MonitorField> getAffectedFields(List<String> attributes) {
            return MonitorField.getAffectedFields(attributes, SectionedTable.this.columns);
        }

        @Override
        public void update(DisplayChannel channelHandle, List<MonitorField> fields) {
            for (MonitorField f : fields) {
                int column = SectionedTable.this.columns.indexOf(f);
                if (column == -1) continue;
                SectionedTable.this.format.format((MonitorCell)((ArrayList)SectionedTable.this.cells.get(this.row)).get(column + 1), channelHandle);
            }
            SectionedTable.this.fireTableRowsUpdated(this.row, this.row);
            SectionedTable.this.fireChangeEvent(SectionedTable.this.CELLS_EVENT);
        }

        @Override
        public void update(DisplayChannel channelHandle) {
            for (int column = 0; column < SectionedTable.this.columns.size(); ++column) {
                MonitorField f = SectionedTable.this.columns.get(column);
                if (!f.isUpdatable()) continue;
                SectionedTable.this.format.format((MonitorCell)((ArrayList)SectionedTable.this.cells.get(this.row)).get(column + 1), channelHandle);
            }
            SectionedTable.this.fireTableRowsUpdated(this.row, this.row);
            SectionedTable.this.fireChangeEvent(SectionedTable.this.CELLS_EVENT);
        }
    }
}

