/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.camera.sal.classes;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.zip.CRC32;
import java.util.zip.Checksum;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.data.KeyValueDataList;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import org.lsst.ccs.camera.sal.xml.Mapping;

public class SALClassDescription {
    private final Class simpleSalClass;
    private final String topicName;
    private final Map<String, SALVariable> variables = new TreeMap<String, SALVariable>(new VariableComparator());
    private final int level;
    private final String category;
    private final Set<LocationVariable> availableLocations = new HashSet<LocationVariable>();
    private final Set<String> allLocations = new TreeSet<String>();
    private static final Mapping mapping = Mapping.defaultMapping();

    SALClassDescription(String topicName, Class simpleSalClass, int level, String category) {
        this.topicName = topicName;
        this.simpleSalClass = simpleSalClass;
        this.level = level;
        this.category = category;
    }

    SALVariable getVariable(String variableName) {
        return this.variables.get(variableName);
    }

    void add(SALVariable var) {
        if (var instanceof LocationVariable) {
            LocationVariable locationVar = (LocationVariable)var;
            this.availableLocations.add(locationVar);
            this.allLocations.add(locationVar.getVariableName());
        }
        this.variables.put(var.getVariableName(), var);
    }

    public LocationVariable getLocationVariable(String location) {
        for (LocationVariable locationVar : this.availableLocations) {
            if (!locationVar.getVariableName().equals(location)) continue;
            return locationVar;
        }
        return null;
    }

    public Set<String> getAvailableLocations() {
        return new TreeSet<String>(this.allLocations);
    }

    public Class getSimpleSalClass() {
        return this.simpleSalClass;
    }

    public String getTopicName() {
        return this.topicName;
    }

    public List<SALVariable> getVariables() {
        return new ArrayList<SALVariable>(this.variables.values());
    }

    public String getCategory() {
        return this.category;
    }

    public long computeChecksum() {
        CRC32 sum = new CRC32();
        this.updateChecksum(sum);
        return sum.getValue();
    }

    public void updateChecksum(Checksum sum) {
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            try (DataOutputStream dos = new DataOutputStream(bos);){
                dos.writeUTF(this.topicName);
                dos.writeInt(this.level);
                if (this.category != null) {
                    dos.writeUTF(this.category);
                }
            }
            bos.flush();
            sum.update(bos.toByteArray(), 0, bos.size());
        }
        catch (IOException x) {
            throw new RuntimeException("Unpexected error computing checksum", x);
        }
        for (SALVariable variable : this.variables.values()) {
            variable.updateCheckSum(sum);
        }
    }

    public String toString() {
        return "SALClassDescription{topicName=" + this.topicName + " className=" + this.simpleSalClass + ", level=" + this.level + ", category=" + this.category + this.getVariables().stream().map(v -> v.toString()).collect(Collectors.joining("\n\t", "\n\t", "\n")) + '}';
    }

    void renameVariable(SALVariable variable, String newName) {
        String oldName = variable.getVariableName();
        this.variables.remove(oldName);
        variable.setName(newName);
        this.variables.put(newName, variable);
    }

    public int getSharedLocationCount(SALVariable sv) {
        if (sv instanceof PatternMatchedSALVariable) {
            PatternMatchedSALVariable pmv = (PatternMatchedSALVariable)sv;
            return pmv.getLocationVariable().getAvailableLocationValues().size();
        }
        return sv.getCount();
    }

    public boolean isCompatibleWithData(Object data) {
        if (data instanceof StatusSubsystemData) {
            KeyValueDataList kvdl = ((StatusSubsystemData)data).getEncodedData();
            for (KeyValueData kvd : kvdl) {
                if (!this.supportsPath(kvd.getKey())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean supportsPath(String path) {
        for (SALVariable sv : this.variables.values()) {
            SimpleSALVariable ssv;
            if (sv instanceof PatternMatchedSALVariable) {
                PatternMatchedSALVariable pmsv = (PatternMatchedSALVariable)sv;
                for (BusVariable bv : pmsv.getBusVariables()) {
                    if (!bv.getPathAndNameOnBuses().equals(path)) continue;
                    return true;
                }
                continue;
            }
            if (!(sv instanceof SimpleSALVariable) || !(ssv = (SimpleSALVariable)sv).getBusVariable().getPathAndNameOnBuses().equals(path)) continue;
            return true;
        }
        return false;
    }

    private static class VariableComparator
    implements Comparator<String> {
        private VariableComparator() {
        }

        @Override
        public int compare(String o1, String o2) {
            o1 = o1.replace("warnHi", "dbandHi");
            o1 = o1.replace("warnLo", "dbandLo");
            o2 = o2.replace("warnHi", "dbandHi");
            o2 = o2.replace("warnLo", "dbandLo");
            return o1.compareTo(o2);
        }
    }

    public static abstract class SALVariable {
        private String variableName;
        private final String type;
        private final String units;
        private final String description;
        protected int count = 1;

        public SALVariable(String variableName, String type, String units, String description) {
            if (type == null || type.isEmpty()) {
                type = "String";
            }
            this.variableName = variableName;
            this.type = type;
            this.units = units;
            this.description = description;
        }

        public String getVariableName() {
            return this.variableName;
        }

        public String getType() {
            return this.type;
        }

        public String getUnits() {
            return this.units;
        }

        public String getDescription() {
            return this.description;
        }

        public int getCount() {
            return this.count;
        }

        public String toString() {
            return "variableName=" + this.variableName + ", type=" + this.type + ", units=" + this.units + ", description=\"" + this.description + "\"";
        }

        private void setName(String newName) {
            this.variableName = newName;
        }

        private void updateCheckSum(Checksum sum) {
            try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
                try (DataOutputStream dos = new DataOutputStream(bos);){
                    dos.writeUTF(this.variableName);
                    dos.writeUTF(this.type);
                }
                bos.flush();
                sum.update(bos.toByteArray(), 0, bos.size());
            }
            catch (IOException x) {
                throw new RuntimeException("Unexpected error computing checksum", x);
            }
        }
    }

    public static class LocationVariable
    extends SALVariable {
        private final Set<String> availableValues = new TreeSet<String>();
        private final List<BusVariable> busVariables = new ArrayList<BusVariable>();

        public LocationVariable(String variableName, String description) {
            super(variableName, "String", "unitless", description);
        }

        void addBusVariable(BusVariable bv) {
            this.availableValues.add(bv.getLocationValue());
            if (!this.busVariables.contains(bv)) {
                this.busVariables.add(bv);
            }
        }

        public List<String> getAvailableLocationValues() {
            return new ArrayList<String>(this.availableValues);
        }

        public List<BusVariable> getBusVariables() {
            return new ArrayList<BusVariable>(this.busVariables);
        }

        @Override
        public String toString() {
            return "LocationVariable{" + super.toString() + '}';
        }
    }

    public static class PatternMatchedSALVariable
    extends SALVariable {
        private final String patternName;
        private final String pattern;
        private final List<BusVariable> busVariables = new ArrayList<BusVariable>();
        private final LocationVariable locationVariable;

        PatternMatchedSALVariable(String patternName, String pattern, LocationVariable location, String variableName, String type, String units, String description) {
            super(variableName, type, units, description);
            this.patternName = patternName;
            this.pattern = pattern;
            this.locationVariable = location;
        }

        void addBusVariable(BusVariable var) {
            this.locationVariable.addBusVariable(var);
            this.busVariables.add(var);
        }

        public String getPatternName() {
            return this.patternName;
        }

        public String getPattern() {
            return this.pattern;
        }

        public List<BusVariable> getBusVariables() {
            return this.busVariables;
        }

        public LocationVariable getLocationVariable() {
            return this.locationVariable;
        }

        @Override
        public int getCount() {
            return this.busVariables.size();
        }

        @Override
        public String toString() {
            return "PatternMatchedSALVariable{" + super.toString() + " patternName=" + this.patternName + ", pattern=" + this.pattern + ", locationVariable=" + this.locationVariable + this.busVariables.stream().map(v -> v.toString()).collect(Collectors.joining("\n\t\t", "\n\t\t", "\n\t")) + '}';
        }
    }

    public static class BusVariable {
        private final String pathAndNameOnBuses;
        private final String locationValue;

        public BusVariable(String pathAndNameOnBuses) {
            this.pathAndNameOnBuses = pathAndNameOnBuses.startsWith("/") ? pathAndNameOnBuses.substring(1) : pathAndNameOnBuses;
            Mapping.Match match = mapping.match(pathAndNameOnBuses);
            this.locationValue = match != null ? match.getLocation().replace("/", "") : "NOTFOUND";
        }

        public String getPathAndNameOnBuses() {
            return this.pathAndNameOnBuses;
        }

        public String getLocationValue() {
            return this.locationValue;
        }

        public String toString() {
            return "BusVariable{pathAndNameOnBuses=" + this.pathAndNameOnBuses + '}';
        }
    }

    public static class SimpleSALVariable
    extends SALVariable {
        private final BusVariable busVariable;

        public SimpleSALVariable(String variableName, String type, String units, String description, BusVariable busVariable, int count) {
            super(variableName, type, units, description);
            this.busVariable = busVariable;
            this.count = count;
        }

        public BusVariable getBusVariable() {
            return this.busVariable;
        }

        @Override
        public String toString() {
            return "SimpleSALVariable{" + super.toString() + " busVariable=" + this.busVariable + '}';
        }
    }
}

