/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.services;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import org.lsst.ccs.Agent;
import org.lsst.ccs.ServiceLifecycle;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.services.AgentMonitor;
import org.lsst.ccs.services.AgentService;
import org.lsst.ccs.utilities.logging.Logger;

public class AgentExecutionService
extends AbstractExecutorService
implements ServiceLifecycle,
HasLifecycle,
AgentMonitor,
AgentService {
    private static final Logger LOG = Logger.getLogger((String)"org.lsst.ccs.services.executionservice");
    private static final ExceptionHandler DEFAULT_EXCEPTION_HANDLER = (task, exception, willRestart) -> {
        String message = "Exception from AgentExecutionService task ";
        if (task.getName() != null) {
            message = message + task.getName();
        }
        if (willRestart) {
            message = message + ". The task will be restarted.";
        }
        Level level = task.getLogLevel();
        task.getLogger().log(level, message, exception);
        return true;
    };
    @LookupField(strategy=LookupField.Strategy.TOP)
    private Agent agent;
    private final Exec exec = new Exec();

    @Override
    public String getAgentServiceName() {
        return "agentExecutionService";
    }

    @Override
    public void preBuild() {
        ServiceLifecycle.super.preBuild();
    }

    @Override
    public void postShutdown() {
        this.exec.shutdownNow();
    }

    @Override
    public void execute(Runnable command) {
        this.exec.execute(command);
    }

    @Override
    public boolean isShutdown() {
        return this.exec.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.exec.isTerminated();
    }

    @Override
    public void shutdown() {
    }

    @Override
    public List<Runnable> shutdownNow() {
        return Collections.emptyList();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.exec.awaitTermination(timeout, unit);
    }

    public Task task(Runnable runnable) {
        return new Task(Executors.callable(runnable));
    }

    public <T> Task<T> task(Runnable runnable, T result) {
        return new Task(Executors.callable(runnable, result));
    }

    public <T> Task task(Callable<T> callable) {
        return new Task(callable);
    }

    @Override
    public String getAgentMonitorStatus(boolean useCcsBuses) {
        return "OK";
    }

    @Override
    public String getAgentMonitorDescription() {
        return this.getClass().getSimpleName();
    }

    static /* synthetic */ ExceptionHandler access$400() {
        return DEFAULT_EXCEPTION_HANDLER;
    }

    static /* synthetic */ Logger access$500() {
        return LOG;
    }

    private final class Exec
    extends ThreadPoolExecutor {
        private final AtomicInteger threadNumber;
        private final ThreadLocal<String> name;

        private Exec() {
            super(0, Integer.MAX_VALUE, 70L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
            this.threadNumber = new AtomicInteger(0);
            this.name = new ThreadLocal();
            this.setThreadFactory(new ThreadFactory(){

                @Override
                public Thread newThread(Runnable r) {
                    Exec.this.name.set("AgentExecutionService-" + Exec.this.threadNumber.getAndIncrement());
                    Thread thread = new Thread(null, r, (String)Exec.this.name.get(), 0L);
                    thread.setDaemon(true);
                    thread.setPriority(5);
                    return thread;
                }
            });
        }

        @Override
        protected void beforeExecute(Thread t, Runnable r) {
            if (this.name.get() == null) {
                this.name.set(Thread.currentThread().getName());
            }
        }

        @Override
        protected void afterExecute(Runnable r, Throwable t) {
            Thread.currentThread().setName(this.name.get());
        }
    }

    public static interface ExceptionHandler {
        public boolean process(Task var1, Throwable var2, boolean var3);
    }

    public class Task<T>
    implements Future<T> {
        private String name;
        private ExceptionHandler exceptionHandler = AgentExecutionService.access$400();
        private Logger logger = AgentExecutionService.access$500();
        private Level logLevel = Level.INFO;
        private int restartN;
        private long restartTime;
        private final FutureTask<T> delegate;
        private boolean started;
        private Queue<Long> restarts;

        private Task(final Callable<T> callable) {
            this.delegate = new FutureTask(new Callable<T>(){

                @Override
                public T call() throws Exception {
                    Throwable lastException = null;
                    if (Task.this.name != null) {
                        try {
                            Thread.currentThread().setName(Task.this.name);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    boolean willRestart = true;
                    while (willRestart) {
                        try {
                            return callable.call();
                        }
                        catch (Throwable t) {
                            lastException = t;
                            willRestart = this.restart();
                            try {
                                Task.this.exceptionHandler.process(Task.this, t, willRestart);
                            }
                            catch (Throwable throwable) {}
                        }
                    }
                    throw new RuntimeException(lastException);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private boolean restart() {
                    Task task = Task.this;
                    synchronized (task) {
                        if (Task.this.isCancelled() || Task.this.restartN < 1) {
                            return false;
                        }
                        if (Task.this.restartTime == 0L) {
                            Task.this.restartN--;
                            return true;
                        }
                        if (Task.this.restarts == null) {
                            Task.this.restarts = new LinkedList();
                            Task.this.restarts.add(System.currentTimeMillis());
                            return true;
                        }
                        long current = System.currentTimeMillis();
                        Task.this.restarts.add(current);
                        long cutoff = current - Task.this.restartTime;
                        while ((Long)Task.this.restarts.peek() < cutoff) {
                            Task.this.restarts.poll();
                        }
                        return Task.this.restarts.size() <= Task.this.restartN;
                    }
                }
            });
        }

        public synchronized String getName() {
            return this.name;
        }

        public synchronized Logger getLogger() {
            return this.logger;
        }

        public synchronized Level getLogLevel() {
            return this.logLevel;
        }

        public synchronized Task<T> setName(String name) {
            if (this.started) {
                throw new IllegalStateException("Task cannot be modified once started");
            }
            this.name = name;
            return this;
        }

        public synchronized Task<T> setExceptionHandler(ExceptionHandler exceptionHandler) {
            if (this.started) {
                throw new IllegalStateException("Task cannot be modified once started");
            }
            if (exceptionHandler == null) {
                throw new NullPointerException();
            }
            this.exceptionHandler = exceptionHandler;
            return this;
        }

        public synchronized Task<T> setLogger(Logger logger) {
            if (this.started) {
                throw new IllegalStateException("Task cannot be modified once started");
            }
            if (logger == null) {
                throw new NullPointerException();
            }
            this.logger = logger;
            return this;
        }

        public synchronized Task<T> setLogLevel(Level level) {
            if (this.started) {
                throw new IllegalStateException("Task cannot be modified once started");
            }
            if (level == null) {
                throw new NullPointerException();
            }
            this.logLevel = level;
            return this;
        }

        public synchronized Task<T> setRestart(int maxAttempts, long time, TimeUnit unit) {
            if (this.started) {
                throw new IllegalStateException("Task cannot be modified once started");
            }
            if (maxAttempts < 0) {
                maxAttempts = Integer.MAX_VALUE;
                time = 0L;
            } else if (maxAttempts > 100) {
                throw new IllegalArgumentException("maxAttampts parameter value cannot exceed 100");
            }
            if (time < 0L) {
                throw new IllegalArgumentException("time parameter value cannot be negative");
            }
            if (time > 0L && unit == null) {
                throw new NullPointerException();
            }
            this.restartN = maxAttempts;
            this.restartTime = time == 0L ? 0L : unit.toMillis(time);
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Task<T> start() {
            Task task = this;
            synchronized (task) {
                this.started = true;
            }
            AgentExecutionService.this.exec.execute(this.delegate);
            return this;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return this.delegate.cancel(mayInterruptIfRunning);
        }

        @Override
        public boolean isCancelled() {
            return this.delegate.isCancelled();
        }

        @Override
        public boolean isDone() {
            return this.delegate.isDone();
        }

        @Override
        public T get() throws InterruptedException, ExecutionException {
            return this.delegate.get();
        }

        @Override
        public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.delegate.get(timeout, unit);
        }
    }
}

