/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.services.lock;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.AgentLock;
import org.lsst.ccs.bus.data.AgentLockInfo;
import org.lsst.ccs.gconsole.annotations.Plugin;
import org.lsst.ccs.gconsole.base.Console;
import org.lsst.ccs.gconsole.base.ConsolePlugin;
import org.lsst.ccs.gconsole.base.ConsoleService;
import org.lsst.ccs.gconsole.services.lock.Locker;
import org.lsst.ccs.gconsole.util.ThreadUtil;
import org.lsst.ccs.services.AgentCommandDictionaryService;
import org.lsst.ccs.services.AgentLockService;
import org.lsst.ccs.services.AgentLoginService;
import org.lsst.ccs.services.UnauthorizedLockException;

@Plugin(name="Lock Service Plugin", id="lock-service", description="Graphical console service that provides interface between GUI components and Agent services dealing with locks, levels, logins, etc.")
public class LockService
extends ConsolePlugin
implements ConsoleService {
    private final TreeMap<String, Locker> agents = new TreeMap();
    private final CopyOnWriteArrayList<Listener> listeners = new CopyOnWriteArrayList();
    private final Console console = Console.getConsole();
    private final AgentLockService lockService = (AgentLockService)this.console.getAgentService(AgentLockService.class);
    private final AgentLoginService loginService = (AgentLoginService)this.console.getAgentService(AgentLoginService.class);
    private final AgentLockService.AgentLockUpdateListener lockListener;
    private final AgentLoginService.AgentLoginUpdateListener loginListener;
    private final AgentCommandDictionaryService.AgentCommandDictionaryListener dictionaryListener;
    private final LinkedList<String> users = new LinkedList();

    public LockService() {
        this.lockListener = new AgentLockService.AgentLockUpdateListener(){

            public void onAgentHeldLockUpdate(String agentName, AgentLock lock) {
                this.lockUpdate(agentName, lock);
            }

            public void onGlobalLockUpdate(String agentName, String owner, AgentLock lock) {
                this.lockUpdate(agentName, lock);
            }

            private void lockUpdate(String agentName, AgentLock aLock) {
                if (aLock instanceof AgentLockInfo && ((AgentLockInfo)aLock).getStatus() == AgentLockInfo.Status.REQUESTED) {
                    return;
                }
                ThreadUtil.invokeLater(() -> {
                    AgentLockInfo.Status lockStatus;
                    Locker agent = (Locker)LockService.this.agents.get(agentName);
                    AgentLock lock = aLock;
                    if (lock instanceof AgentLockInfo && (AgentLockInfo.Status.RELEASED == (lockStatus = ((AgentLockInfo)lock).getStatus()) || AgentLockInfo.Status.REJECTED == lockStatus)) {
                        lock = null;
                    }
                    if (agent == null) {
                        if (lock != null) {
                            agent = new Locker(agentName, LockService.this.lockService);
                            agent.onLock(lock);
                            LockService.this.agents.put(agentName, agent);
                            LockService.this.notifyListenersAdd(new Locker[]{agent});
                        }
                    } else {
                        agent.onLock(lock);
                        if (lock == null && !agent.isOnline()) {
                            LockService.this.agents.remove(agentName);
                            agent.removeAllListeners();
                            LockService.this.notifyListenersRemove(new Locker[]{agent});
                        } else {
                            LockService.this.notifyListenersUpdate(new Locker[]{agent});
                        }
                    }
                });
            }

            public void onAgentLevelChange(String agentName, int level) {
                ThreadUtil.invokeLater(() -> {
                    Locker agent = (Locker)LockService.this.agents.get(agentName);
                    if (agent != null) {
                        agent.onLevel(level);
                        LockService.this.notifyListenersUpdate(new Locker[]{agent});
                    }
                });
            }
        };
        this.dictionaryListener = e -> ThreadUtil.invokeLater(() -> {
            AgentInfo agentInfo = e.getAgentInfo();
            String name = agentInfo.getName();
            Locker agent = this.agents.get(name);
            switch (e.getEventType()) {
                case ADDED: {
                    boolean newAgent;
                    boolean bl = newAgent = agent == null;
                    if (newAgent) {
                        agent = new Locker(name, this.lockService);
                        this.agents.put(name, agent);
                    }
                    agent.onOnline(agentInfo, e.getDictionary());
                    if (!newAgent) break;
                    this.notifyListenersAdd(agent);
                    break;
                }
                case REMOVED: {
                    if (agent == null) break;
                    agent.onOnline(null, null);
                    if (agent.getLock() == null) {
                        this.agents.remove(name);
                        agent.removeAllListeners();
                        this.notifyListenersRemove(agent);
                        break;
                    }
                    this.notifyListenersUpdate(agent);
                }
            }
        });
        this.loginListener = new AgentLoginService.AgentLoginUpdateListener(){

            public void onAgentLoginUpdate(String oldUserId, String newUserId) {
                ThreadUtil.invokeLater(() -> {
                    try {
                        JFrame top = (JFrame)LockService.this.console.getWindow();
                        top.setTitle("CCS Console : " + newUserId);
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                    LockService.this.agents.values().forEach(agent -> agent.onLogin(oldUserId, newUserId));
                    LockService.this.listeners.forEach(listener -> {
                        try {
                            listener.userChanged(oldUserId, newUserId);
                        }
                        catch (RuntimeException x) {
                            Console.getConsole().getLogger().error((Object)"Error notifying LockService listeners of user name change", (Throwable)x);
                        }
                    });
                });
            }
        };
    }

    public static LockService getService() {
        return Console.getConsole().getSingleton(LockService.class);
    }

    @Override
    public void startService() {
        this.lockService.addAgentLockUpdateListener(this.lockListener);
        this.loginService.addAgentLoginUpdateListener(this.loginListener);
        ((AgentCommandDictionaryService)this.console.getAgentService(AgentCommandDictionaryService.class)).addAgentCommandDictionaryListener(this.dictionaryListener);
        AbstractAction act = new AbstractAction("Login ..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                JComboBox<String> box = new JComboBox<String>(LockService.this.users.toArray(new String[0]));
                box.setEditable(true);
                int out = JOptionPane.showConfirmDialog(LockService.this.getConsole().getWindow(), box, "Login as", 2, 3);
                if (out == 0) {
                    String osUser = System.getProperty("user.name", "unknown");
                    String currentUser = LockService.this.lockService.getUserId();
                    String newUser = box.getSelectedItem().toString().trim();
                    if (newUser.isEmpty()) {
                        newUser = osUser;
                    }
                    if (!currentUser.equals(newUser)) {
                        LockService.this.users.remove(newUser);
                        if (!LockService.this.users.isEmpty() && ((String)LockService.this.users.getFirst()).equals(osUser)) {
                            LockService.this.users.add(1, currentUser);
                        } else {
                            LockService.this.users.addFirst(currentUser);
                        }
                        if (LockService.this.users.size() > 10) {
                            LockService.this.users.removeLast();
                        }
                        LockService.this.login(newUser, "");
                    }
                }
            }
        };
        this.getServices().addMenu(act, "File:-2:1");
    }

    @Override
    public void stopService() {
        ((AgentCommandDictionaryService)this.console.getAgentService(AgentCommandDictionaryService.class)).removeAgentCommandDictionaryListener(this.dictionaryListener);
        this.lockService.removeAgentLockUpdateListener(this.lockListener);
    }

    public Locker getAgent(String agentName) {
        return this.agents.get(agentName);
    }

    public List<Locker> getAgents(State ... states) {
        switch (states.length) {
            case 0: {
                return new ArrayList<Locker>(this.agents.values());
            }
            case 1: {
                State state = states[0];
                return this.agents.values().stream().filter(locker -> locker.getState() == state).collect(Collectors.toList());
            }
        }
        EnumSet<State> ss = EnumSet.copyOf(Arrays.asList(states));
        return this.agents.values().stream().filter(locker -> ss.contains((Object)locker.getState())).collect(Collectors.toList());
    }

    public String getUserId() {
        return this.lockService.getUserId();
    }

    public List<String> getAgentNames(State ... states) {
        switch (states.length) {
            case 0: {
                return this.agents.values().stream().map(locker -> locker.getName()).collect(Collectors.toList());
            }
            case 1: {
                State state = states[0];
                return this.agents.values().stream().filter(locker -> locker.getState() == state).map(locker -> locker.getName()).collect(Collectors.toList());
            }
        }
        EnumSet<State> ss = EnumSet.copyOf(Arrays.asList(states));
        return this.agents.values().stream().filter(locker -> ss.contains((Object)locker.getState())).map(locker -> locker.getName()).collect(Collectors.toList());
    }

    public void executeBulkOperation(final Operation op, final List<String> agentNames) {
        ThreadUtil.invokeLater(() -> {
            agentNames.forEach(agentName -> {
                Locker agent = this.agents.get(agentName);
                if (agent != null) {
                    agent.adjusting = true;
                    agent.notifyListeners();
                }
            });
            new SwingWorker<Map<String, Exception>, Object>(){

                @Override
                protected Map<String, Exception> doInBackground() throws Exception {
                    LinkedHashMap<String, Exception> failures = new LinkedHashMap<String, Exception>();
                    agentNames.forEach(agentName -> {
                        try {
                            switch (op) {
                                case LOCK: {
                                    LockService.this.lockService.lockAgent(agentName);
                                    break;
                                }
                                case UNLOCK: {
                                    LockService.this.lockService.unlockAgent(agentName);
                                    break;
                                }
                                case ATTACH: {
                                    LockService.this.lockService.attachLock(agentName);
                                    break;
                                }
                                case DETACH: {
                                    LockService.this.lockService.detachLock(agentName);
                                    break;
                                }
                                default: {
                                    throw new UnsupportedOperationException((Object)((Object)op) + " cannot be performed on multiple subsystems");
                                }
                            }
                        }
                        catch (RuntimeException | UnauthorizedLockException x) {
                            failures.put((String)agentName, (Exception)x);
                        }
                    });
                    return failures;
                }

                @Override
                protected void done() {
                    try {
                        Map failures = (Map)this.get();
                        if (!failures.isEmpty()) {
                            StringBuilder sb = new StringBuilder("Failed to execute ").append((Object)op).append(" for these subsystems:").append(System.lineSeparator());
                            failures.forEach((agent, exception) -> sb.append((String)agent).append(" -> ").append(exception).append(System.lineSeparator()));
                            Console.getConsole().error(sb.toString());
                        }
                    }
                    catch (InterruptedException x) {
                        Console.getConsole().getLogger().warn((Object)"ConsoleLockService: AWT interrupted");
                        Thread.currentThread().interrupt();
                    }
                    catch (ExecutionException x) {
                        try {
                            Console.getConsole().error("Unable to " + (Object)((Object)op) + " on " + agentNames, (Exception)x.getCause());
                        }
                        catch (ClassCastException xx) {
                            Console.getConsole().error("Unable to " + (Object)((Object)op) + " on " + agentNames, x);
                        }
                    }
                    agentNames.forEach(agentName -> {
                        Locker agent = (Locker)LockService.this.agents.get(agentName);
                        if (agent != null) {
                            agent.adjusting = false;
                            agent.notifyListeners();
                        }
                    });
                }
            }.execute();
        });
    }

    public void executeOperation(final Operation op, final String agentName, int level) {
        ThreadUtil.invokeLater(() -> {
            int finalLevel;
            Locker agent = this.agents.get(agentName);
            switch (op) {
                case ATTACH: {
                    int out = JOptionPane.showConfirmDialog(Console.getConsole().getWindow(), "<html>You are about to attach an existing lock owned by user \"" + this.lockService.getUserId() + ".\" This lock may<br> already be in use by another console or a script running under the same user name.<p> <p>Would you like to proceed?", "Attaching existing lock", 2);
                    if (out != 0) {
                        return;
                    }
                    finalLevel = level;
                    break;
                }
                case DESTROY: {
                    int out = JOptionPane.showConfirmDialog(Console.getConsole().getWindow(), "<html>Are you sure you want to destroy <b>" + agentName + "</b> subsystem lock owned by user <b>" + agent.getLock().getOwner() + "</b>?<br> If practical, please contact the lock owner instead.<p> <p>Would you like to proceed?", "Destroying lock", 2);
                    if (out != 0) {
                        return;
                    }
                    finalLevel = level;
                    break;
                }
                case LEVEL: {
                    if (level < 0) {
                        String s = (String)JOptionPane.showInputDialog(Console.getConsole().getWindow(), "Desired level for " + agentName, "Select level", 3, null, null, 0);
                        try {
                            finalLevel = Integer.parseInt(s);
                            if (finalLevel < 0 || finalLevel > 99) {
                                throw new NumberFormatException();
                            }
                            break;
                        }
                        catch (NumberFormatException x) {
                            Console.getConsole().error("Illegal lock level. Must be integer between 0 and 99.");
                            return;
                        }
                    }
                    finalLevel = level;
                    break;
                }
                default: {
                    finalLevel = level;
                }
            }
            if (agent != null) {
                agent.adjusting = true;
                agent.notifyListeners();
            }
            final AgentLock lock = agent == null ? null : agent.getLock();
            final State state = agent == null ? State.UNLOCKED : agent.getState();
            new SwingWorker<Object, Object>(){

                @Override
                protected Object doInBackground() throws Exception {
                    switch (op) {
                        case LOCK: {
                            LockService.this.lockService.lockAgent(agentName);
                            break;
                        }
                        case UNLOCK: {
                            LockService.this.lockService.unlockAgent(agentName);
                            break;
                        }
                        case ATTACH: {
                            LockService.this.lockService.attachLock(agentName);
                            break;
                        }
                        case DETACH: {
                            LockService.this.lockService.detachLock(agentName);
                            break;
                        }
                        case DESTROY: {
                            if (lock == null) break;
                            LockService.this.lockService.destroyLock(agentName, LockService.this.lockService.getUserId());
                            break;
                        }
                        case LEVEL: {
                            switch (state) {
                                case UNLOCKED: {
                                    LockService.this.lockService.lockAgent(agentName);
                                    break;
                                }
                                case DETACHED: {
                                    LockService.this.lockService.attachLock(agentName);
                                }
                            }
                            LockService.this.lockService.setLevelForAgent(agentName, finalLevel);
                        }
                    }
                    return null;
                }

                @Override
                protected void done() {
                    try {
                        this.get();
                    }
                    catch (InterruptedException x) {
                        LockService.this.console.getLogger().warn((Object)"ConsoleLockService: AWT interrupted");
                        Thread.currentThread().interrupt();
                    }
                    catch (ExecutionException x) {
                        try {
                            Exception cause = (Exception)x.getCause();
                            LockService.this.console.error("Unable to " + (Object)((Object)op) + " " + agentName, cause);
                            AgentLock realLock = LockService.this.lockService.getExistingLockForAgent(agentName);
                            LockService.this.lockListener.onGlobalLockUpdate(agentName, null, realLock);
                        }
                        catch (ClassCastException xx) {
                            LockService.this.console.error("Unable to " + (Object)((Object)op) + " " + agentName, x);
                        }
                    }
                    Locker agent = (Locker)LockService.this.agents.get(agentName);
                    if (agent != null) {
                        agent.adjusting = false;
                        agent.notifyListeners();
                    }
                }
            }.execute();
        });
    }

    public void login(String userID, String credentials) {
        ThreadUtil.invokeLater(() -> {
            boolean change;
            String oldID = this.loginService.getUserId();
            boolean bl = change = !Objects.equals(oldID, userID);
            if (change) {
                try {
                    this.loginService.disconnect();
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
                if (userID != null) {
                    try {
                        this.loginService.login(userID, credentials);
                    }
                    catch (RuntimeException x) {
                        this.console.error("Failed to login as " + userID, x);
                    }
                }
            }
        });
    }

    public void addListener(Listener listener) {
        SwingUtilities.invokeLater(() -> {
            this.listeners.addIfAbsent(listener);
            Locker[] existingAgents = this.agents.values().toArray(new Locker[this.agents.size()]);
            listener.agentsAdded(existingAgents);
        });
    }

    public void removeListener(Listener listener) {
        ThreadUtil.invokeLater(() -> this.listeners.remove(listener));
    }

    private void notifyListenersAdd(Locker ... agentHandles) {
        this.listeners.forEach(listener -> {
            try {
                listener.agentsAdded(agentHandles);
            }
            catch (RuntimeException x) {
                Console.getConsole().getLogger().error((Object)("Error notifying LockService listeners of " + String.join((CharSequence)",", Arrays.stream(agentHandles).map(a -> a.getName()).collect(Collectors.toList())) + " addition"), (Throwable)x);
            }
        });
    }

    private void notifyListenersRemove(Locker ... agentHandles) {
        this.listeners.forEach(listener -> {
            try {
                listener.agentsRemoved(agentHandles);
            }
            catch (RuntimeException x) {
                Console.getConsole().getLogger().error((Object)("Error notifying LockService listeners of " + String.join((CharSequence)",", Arrays.stream(agentHandles).map(a -> a.getName()).collect(Collectors.toList())) + " removal"), (Throwable)x);
            }
        });
    }

    private void notifyListenersUpdate(Locker ... agentHandles) {
        this.listeners.forEach(listener -> {
            try {
                listener.agentsUpdated(agentHandles);
            }
            catch (RuntimeException x) {
                Console.getConsole().getLogger().error((Object)("Error notifying LockService listeners of " + String.join((CharSequence)",", Arrays.stream(agentHandles).map(a -> a.getName()).collect(Collectors.toList())) + " update"), (Throwable)x);
            }
        });
    }

    public static interface Listener {
        default public void agentsAdded(Locker ... agents) {
        }

        default public void agentsRemoved(Locker ... agents) {
        }

        default public void agentsUpdated(Locker ... agents) {
        }

        default public void userChanged(String oldUserID, String newUserID) {
        }
    }

    public static enum State {
        UNLOCKED,
        LOCKED,
        DETACHED,
        ATTACHED;

    }

    public static enum Operation {
        LOCK("Lock"),
        UNLOCK("Unlock"),
        ATTACH("Attach"),
        DETACH("Detach"),
        DESTROY("Destroy"),
        LEVEL("Set level");

        private final String humanReadable;

        private Operation(String humanReadable) {
            this.humanReadable = humanReadable;
        }

        public Action getAction(final String agentName) {
            AbstractAction act = new AbstractAction(this.humanReadable){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LockService.getService().executeOperation(this, agentName, -1);
                }
            };
            act.putValue("ShortDescription", this.humanReadable + " " + agentName);
            return act;
        }

        public String toString() {
            return this.humanReadable;
        }
    }
}

