/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.bytecode.enhance.internal.bytebuddy;

import net.bytebuddy.description.field.FieldDescription;
import net.bytebuddy.description.type.TypeDescription;
import org.hibernate.bytecode.enhance.internal.bytebuddy.UnloadedFieldDescription;
import org.hibernate.bytecode.enhance.internal.bytebuddy.UnloadedTypeDescription;
import org.hibernate.bytecode.enhance.spi.EnhancementContext;
import org.hibernate.bytecode.enhance.spi.UnloadedField;

class ByteBuddyEnhancementContext {
    private final EnhancementContext enhancementContext;

    ByteBuddyEnhancementContext(EnhancementContext enhancementContext) {
        this.enhancementContext = enhancementContext;
    }

    public ClassLoader getLoadingClassLoader() {
        return this.enhancementContext.getLoadingClassLoader();
    }

    public boolean isEntityClass(TypeDescription classDescriptor) {
        return this.enhancementContext.isEntityClass(new UnloadedTypeDescription(classDescriptor));
    }

    public boolean isCompositeClass(TypeDescription classDescriptor) {
        return this.enhancementContext.isCompositeClass(new UnloadedTypeDescription(classDescriptor));
    }

    public boolean isMappedSuperclassClass(TypeDescription classDescriptor) {
        return this.enhancementContext.isMappedSuperclassClass(new UnloadedTypeDescription(classDescriptor));
    }

    public boolean doBiDirectionalAssociationManagement(FieldDescription field) {
        return this.enhancementContext.doBiDirectionalAssociationManagement(new UnloadedFieldDescription(field));
    }

    public boolean doDirtyCheckingInline(TypeDescription classDescriptor) {
        return this.enhancementContext.doDirtyCheckingInline(new UnloadedTypeDescription(classDescriptor));
    }

    public boolean doExtendedEnhancement(TypeDescription classDescriptor) {
        return this.enhancementContext.doExtendedEnhancement(new UnloadedTypeDescription(classDescriptor));
    }

    public boolean hasLazyLoadableAttributes(TypeDescription classDescriptor) {
        return this.enhancementContext.hasLazyLoadableAttributes(new UnloadedTypeDescription(classDescriptor));
    }

    public boolean isPersistentField(FieldDescription ctField) {
        return this.enhancementContext.isPersistentField(new UnloadedFieldDescription(ctField));
    }

    public FieldDescription[] order(FieldDescription[] persistentFields) {
        UnloadedField[] unloadedFields = new UnloadedField[persistentFields.length];
        for (int i = 0; i < unloadedFields.length; ++i) {
            unloadedFields[i] = new UnloadedFieldDescription(persistentFields[i]);
        }
        UnloadedField[] ordered = this.enhancementContext.order(unloadedFields);
        FieldDescription[] orderedFields = new FieldDescription[persistentFields.length];
        for (int i = 0; i < orderedFields.length; ++i) {
            orderedFields[i] = ((UnloadedFieldDescription)ordered[i]).fieldDescription;
        }
        return orderedFields;
    }

    public boolean isLazyLoadable(FieldDescription field) {
        return this.enhancementContext.isLazyLoadable(new UnloadedFieldDescription(field));
    }

    public boolean isMappedCollection(FieldDescription field) {
        return this.enhancementContext.isMappedCollection(new UnloadedFieldDescription(field));
    }
}

