/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.imagenaming;

public enum Source {
    MainCamera("MC", false),
    ComCam("CC", false),
    AuxTel("AT", false),
    TestStand("TS", false),
    GenericCamera("GC", true),
    FiberSpectrograph("FS", true),
    Electrometer("EM", true),
    Block("BL", true);

    private final String code;
    private final boolean isIndexed;

    private Source(String code, boolean isIndexed) {
        this.code = code;
        this.isIndexed = isIndexed;
    }

    public String getCode() {
        return this.code;
    }

    public boolean isIndexed() {
        return this.isIndexed;
    }

    static Source fromCode(String code) {
        for (Source s : Source.values()) {
            if (!s.getCode().equals(code)) continue;
            return s;
        }
        throw new IllegalArgumentException("Invalid source code: " + code);
    }
}

