/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.auxiliary.disk.jdbc;

import java.util.Iterator;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.commons.jcs3.auxiliary.disk.jdbc.JDBCDiskCache;
import org.apache.commons.jcs3.log.Log;
import org.apache.commons.jcs3.log.LogManager;
import org.apache.commons.jcs3.utils.timing.ElapsedTimer;

public class ShrinkerThread
implements Runnable {
    private static final Log log = LogManager.getLog(ShrinkerThread.class);
    private final CopyOnWriteArraySet<JDBCDiskCache<?, ?>> shrinkSet = new CopyOnWriteArraySet();
    private static final long DEFAULT_PAUSE_BETWEEN_REGION_CALLS_MILLIS = 5000L;
    private long pauseBetweenRegionCallsMillis = 5000L;

    protected ShrinkerThread() {
    }

    public void addDiskCacheToShrinkList(JDBCDiskCache<?, ?> diskCache) {
        this.shrinkSet.add(diskCache);
    }

    @Override
    public void run() {
        try {
            this.deleteExpiredFromAllRegisteredRegions();
        }
        catch (Throwable e) {
            log.error("Caught an exception while trying to delete expired items.", e);
        }
    }

    private void deleteExpiredFromAllRegisteredRegions() {
        log.info("Running JDBC disk cache shrinker. Number of regions [{0}]", () -> this.shrinkSet.size());
        Iterator<JDBCDiskCache<?, ?>> i = this.shrinkSet.iterator();
        while (i.hasNext()) {
            JDBCDiskCache<?, ?> cache = i.next();
            ElapsedTimer timer = new ElapsedTimer();
            int deleted = cache.deleteExpired();
            log.info("Deleted [{0}] expired for region [{1}] for table [{2}] in {3} ms.", deleted, cache.getCacheName(), cache.getTableName(), timer.getElapsedTime());
            if (!i.hasNext()) continue;
            log.info("Pausing for [{0}] ms before shrinking the next region.", this.getPauseBetweenRegionCallsMillis());
            try {
                Thread.sleep(this.getPauseBetweenRegionCallsMillis());
            }
            catch (InterruptedException e) {
                log.warn("Interrupted while waiting to delete expired for the next region.");
            }
        }
    }

    public void setPauseBetweenRegionCallsMillis(long pauseBetweenRegionCallsMillis) {
        this.pauseBetweenRegionCallsMillis = pauseBetweenRegionCallsMillis;
    }

    public long getPauseBetweenRegionCallsMillis() {
        return this.pauseBetweenRegionCallsMillis;
    }
}

