package org.lsst.ccs.subsystem.ocsbridge.events;

import java.util.List;

import org.lsst.ccs.bus.annotations.SkipEncoding;

@SkipEncoding
public class CCSAvailableFiltersEvent extends CCSEvent {

    private final List<String> filterNames;
    private final List<String> filterTypes;
    private final double maxChangeAngle;
    private final double maxFastChangeAngle;
    private final double[] maxSlowChangeTime;
    private final double[] maxFastChangeTime;

    public CCSAvailableFiltersEvent(List<String> filterNames, List<String> filterTypes, double maxChangeAngle,
            double maxFastChangeAngle, double[] maxSlowChangeTime, double[] maxFastChangeTime) {
        this.filterNames = filterNames;
        this.filterTypes = filterTypes;
        this.maxChangeAngle = maxChangeAngle;
        this.maxFastChangeAngle = maxFastChangeAngle;
        this.maxSlowChangeTime = maxSlowChangeTime;
        this.maxFastChangeTime = maxFastChangeTime;
    }
    
    public CCSAvailableFiltersEvent(List<String> filterNames, List<String> filterTypes, double maxChangeAngle,
            double maxFastChangeAngle, double maxSlowChangeTime, double maxFastChangeTime) {
        this.filterNames = filterNames;
        this.filterTypes = filterTypes;
        this.maxChangeAngle = maxChangeAngle;
        this.maxFastChangeAngle = maxFastChangeAngle;
        int n = filterNames.size();
        double[] slowChangeTime = new double[n], fastChangeTime = new double[n];
        for (int i=0; i<n; i++) {
            slowChangeTime[i] = maxSlowChangeTime; 
            fastChangeTime[i] = maxFastChangeTime;
        }
        this.maxSlowChangeTime = slowChangeTime;
        this.maxFastChangeTime = fastChangeTime;
    }

    // This part should ensure backward compatibility
    public CCSAvailableFiltersEvent(List<String> filterNames, List<String> filterTypes) {
        this(filterNames, filterTypes, 0, 0, 240, 240);
    }

    public List<String> getAvailableFilters() {
        return filterNames;
    }

    public List<String> getAvailableFilterTypes() {
        return filterTypes;
    }
    
    public double getMaxChangeAngle() {
        return this.maxChangeAngle;
     }
  
     public double getMaxFastChangeAngle() {
        return this.maxFastChangeAngle;
     }
  
     public double[] getMaxSlowChangeTime() {
        return this.maxSlowChangeTime;
     }
  
     public double[] getMaxFastChangeTime() {
        return this.maxFastChangeTime;
     } 

    @Override
    public String toString() {
        return "CCSAvailableFiltersEvent{" + "filterNames=" + filterNames + ", filterTypes=" + filterTypes
                + ", maxChangeAngle=" + maxChangeAngle + ", maxFastChangeAngle=" + maxFastChangeAngle
                + ", maxSlowChangeTime=" + maxSlowChangeTime + ", maxFastChangeTime=" + maxFastChangeTime + "}";
    }

}
