package org.lsst.ccs.subsystem.ocsbridge.events;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import org.lsst.ccs.bus.annotations.DataAttributes;

/**
 * An event designed to ensure fit results are stored in the trending database.
 * @author tonyj
 */
public class ShutterMotionProfileFitResult implements Serializable {
    @DataAttributes(description = "Shutter Motion Profile Fit Parameter: model start time", units="second")
    private final double modelStartTime;
    @DataAttributes(description = "Shutter Motion Profile Fit Parameter: pivot point 1", units="second")
    private final double pivotPoint1;
    @DataAttributes(description = "Shutter Motion Profile Fit Parameter: pivot point 2", units="second")
    private final double pivotPoint2;
    @DataAttributes(description = "Shutter Motion Profile Fit Parameter: jerk 0", units="m/s^3")
    private final double jerk0;
    @DataAttributes(description = "Shutter Motion Profile Fit Parameter: jerk 1", units="m/s^3")
    private final double jerk1;
    @DataAttributes(description = "Shutter Motion Profile Fit Parameter: jerk 2", units="m/s^3")
    private final double jerk2;

    public ShutterMotionProfileFitResult(double[] result) {
        this.modelStartTime = result[0];
        this.pivotPoint1 = result[1];
        this.pivotPoint2 = result[2];
        this.jerk0 = result[3];
        this.jerk1 = result[4];
        this.jerk2 = result[5];
    }

    public double getModelStartTime() {
        return modelStartTime;
    }

    public double getPivotPoint1() {
        return pivotPoint1;
    }

    public double getPivotPoint2() {
        return pivotPoint2;
    }

    public double getJerk0() {
        return jerk0;
    }

    public double getJerk1() {
        return jerk1;
    }

    public double getJerk2() {
        return jerk2;
    }
    
    public Map<String, Object> getNamedFitParameters() {
        Map<String, Object> result = new LinkedHashMap<>();
        result.put("ModelStartTime", modelStartTime);
        result.put("PivotPoint1", pivotPoint1);
        result.put("PivotPoint2", pivotPoint2);
        result.put("Jerk0", jerk0);
        result.put("Jerk1", jerk1);
        result.put("Jerk2", jerk2);
        return result;
    }

    @Override
    public String toString() {
        return "ShutterMotionProfileFitResult{" + "modelStartTime=" + modelStartTime + ", pivotPoint1=" + pivotPoint1 + ", pivotPoint2=" + pivotPoint2 + ", jerk0=" + jerk0 + ", jerk1=" + jerk1 + ", jerk2=" + jerk2 + '}';
    }
}
