package org.lsst.ccs.subsystem.ocsbridge.events;

import java.util.Map;
import org.lsst.ccs.bus.annotations.SkipEncoding;
import org.lsst.ccs.imagenaming.ImageName;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;

/**
 * An event generated by the MCM at the beginning of an exposure and primarily
 * used to convey information to the ocs-bridge for publication as SAL events
 *
 * @author tonyj
 */
@SkipEncoding
public class CCSImageNameEvent extends CCSEvent {

    private final ImageName imageName;
    private final int sequenceNumber;
    private final int imagesInSequence;
    private final CCSTimeStamp integrationStartTime;
    private final double exposureTime;
    private final double requestedShutterOpenTime;
    private final boolean shutterOpen;
    private final Map<String, String> keyValueData;
    private final String mode;
    private final double timeout;

    /**
     * Constructor
     *
     * @param keyValueData Map of key-value data
     * @param imagesInSequence How many images in the visit
     * @param imageName The image name of the current image
     * @param sequenceNumber The sequence number of the current image in the
     * visit (1 based?)
     * @param integrationStartTime The time integration started
     * @param exposureTime The requested exposure time
     * @param requestedShutterOpenTime requested time for shutter to be open -
     * this may not be the time it is actually open-
     * @param shutterOpen is the shutter open during the taking of this image
     * @param mode The mode ("calibration" or "normal")
     * @param timeout The timeout (only used for calibration images)
     */
    public CCSImageNameEvent(Map<String, String> keyValueData, int imagesInSequence, ImageName imageName, int sequenceNumber, CCSTimeStamp integrationStartTime, double exposureTime, double requestedShutterOpenTime, boolean shutterOpen, String mode, double timeout) {
        this.keyValueData = keyValueData;
        this.imagesInSequence = imagesInSequence;
        this.imageName = imageName;
        this.sequenceNumber = sequenceNumber;
        this.integrationStartTime = integrationStartTime;
        this.exposureTime = exposureTime;
        this.mode = mode;
        this.timeout = timeout;
        this.requestedShutterOpenTime = requestedShutterOpenTime;
        this.shutterOpen = shutterOpen;
    }

    public double getRequestedShutterOpenTime() {

        return requestedShutterOpenTime;
    }

    public boolean isShutterOpen() {
        return shutterOpen;
    }

    public String getImageType() {
        return keyValueData.get("imageType");
    }

    public String getGroupId() {
        return keyValueData.get("groupId");
    }

    public int getImagesInSequence() {
        return imagesInSequence;
    }

    public ImageName getImageName() {
        return imageName;
    }

    public int getSequenceNumber() {
        return sequenceNumber;
    }

    public CCSTimeStamp getIntegrationStartTime() {
        return integrationStartTime;
    }

    public double getExposureTime() {
        return exposureTime;
    }

    public Map<String, String> getKeyValueData() {
        return keyValueData;
    }

    public String getMode() {
        return mode;
    }

    public double getTimeout() {
        return timeout;
    }

    @Override
    public String toString() {
        return "CCSImageNameEvent{" + "imagesInSequence=" + imagesInSequence + ", imageName=" + imageName + ", sequenceNumber=" + sequenceNumber + ", integrationStartTime=" + integrationStartTime + ", exposureTime=" + exposureTime + ", keyValueData=" + keyValueData + ", mode=" + mode + ", timeout=" + timeout + ", shutterOpenTime=" + requestedShutterOpenTime + ", shutterOpen=" + shutterOpen + +'}';
    }

}
