package org.lsst.ccs.subsystem.ocsbridge.events;

import org.lsst.ccs.bus.annotations.SkipEncoding;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;

@SkipEncoding
public class CCSEndOfImageTelemetryEvent extends CCSEvent {

    private final double darkTime;
    private final double exposureTime;
    private final long imageTag;
    private final CCSTimeStamp dateObs;
    private final CCSTimeStamp dateEnd;

    public CCSEndOfImageTelemetryEvent(double darkTime, double exposureTime, long imageTag, CCSTimeStamp dateObs, CCSTimeStamp dateEnd) {
        this.darkTime = darkTime;
        this.exposureTime = exposureTime;
        this.imageTag = imageTag;
        this.dateObs = dateObs;
        this.dateEnd = dateEnd;
    }

    public double getDarkTime() {
        return darkTime;
    }

    public double getExposureTime() {
        return exposureTime;
    }

    public long getImageTag() {
        return imageTag;
    }

    public CCSTimeStamp getDateObs() {
        return dateObs;
    }

    public CCSTimeStamp getDateEnd() {
        return dateEnd;
    }

}
