/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.image.viewer;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.util.Map;
import org.lsst.ccs.utilities.ccd.CCD;
import org.lsst.ccs.utilities.ccd.Geometry;
import org.lsst.ccs.utilities.ccd.Raft;
import org.lsst.ccs.utilities.ccd.Reb;
import org.lsst.ccs.utilities.ccd.Segment;

class GeometryRenderer {
    GeometryRenderer() {
    }

    static void renderGeometry(Geometry<?> geometry, Graphics g, Point p, double scaleFactor) {
        GeometryRenderer.renderGeometrySpecificDetails(geometry, g, p, scaleFactor);
        if (geometry.hasChildren()) {
            Map<Geometry, Point> children = geometry.getChildrenWithAbsoluteCoordinates();
            for (Geometry child : children.keySet()) {
                GeometryRenderer.renderGeometry(child, g, children.get(child), scaleFactor);
            }
        }
    }

    private static void renderGeometrySpecificDetails(Geometry<?> geom, Graphics g, Point p, double scaleFactor) {
        if (geom instanceof CCD) {
            GeometryRenderer.renderCCDGeometry((CCD)geom, g, p, scaleFactor);
        } else if (geom instanceof Raft) {
            GeometryRenderer.renderRaftGeometry((Raft)geom, g, p, scaleFactor);
        } else if (geom instanceof Reb) {
            GeometryRenderer.renderRebGeometry((Reb)geom, g, p, scaleFactor);
        } else if (geom instanceof Segment) {
            GeometryRenderer.renderSegmentGeometry((Segment)geom, g, p, scaleFactor);
        }
    }

    private static void renderCCDGeometry(CCD geom, Graphics g, Point p, double scaleFactor) {
        g.drawRect(p.x, p.y, geom.getWidth(), geom.getHeight());
        Graphics2D g2d = (Graphics2D)g;
        Color orig = g.getColor();
        Color blue = Color.BLUE;
        g.setColor(blue);
        if (!geom.getName().isEmpty()) {
            int textHeight = g.getFontMetrics().getHeight();
            int textWidth = g.getFontMetrics().stringWidth(geom.getName());
            int xLabel = p.x + (geom.getWidth() - textWidth) / 2 + 40;
            int yLabel = p.y + geom.getHeight() / 2 + textHeight - 40;
            g2d.scale(1.0 / scaleFactor, 1.0 / scaleFactor);
            g.drawString(geom.getName(), (int)((double)xLabel * scaleFactor), (int)((double)yLabel * scaleFactor));
            g2d.scale(scaleFactor, scaleFactor);
        }
        g.setColor(orig);
    }

    private static void renderRaftGeometry(Raft geom, Graphics g, Point p, double scaleFactor) {
        Graphics2D g2d = (Graphics2D)g;
        Color orig = g.getColor();
        Color green = Color.ORANGE;
        g.setColor(green);
        g.drawRect(p.x, p.y, geom.getWidth(), geom.getHeight());
        if (!geom.getName().isEmpty()) {
            int xLabel = p.x + (int)((double)geom.getWidth() * 0.05);
            int yLabel = p.y + (int)((double)geom.getHeight() * 0.05);
            g2d.scale(1.0 / scaleFactor, 1.0 / scaleFactor);
            g.drawString(geom.getName(), (int)((double)xLabel * scaleFactor), (int)((double)yLabel * scaleFactor));
            g2d.scale(scaleFactor, scaleFactor);
        }
        g.setColor(orig);
    }

    private static void renderRebGeometry(Reb geom, Graphics g, Point p, double scaleFactor) {
        int rebLineY = p.y + (int)((double)geom.getHeight() * 0.2);
        int lineLength = (int)((double)geom.getHeight() * 0.6);
        int rebLineX = p.x + geom.getWidth() / 2;
        Graphics2D g2d = (Graphics2D)g;
        Color orig = g.getColor();
        Color green = Color.GREEN;
        g.setColor(green);
        g2d.scale(1.0 / scaleFactor, 1.0 / scaleFactor);
        g.fillRect((int)((double)rebLineX * scaleFactor), (int)((double)rebLineY * scaleFactor), 4, (int)((double)lineLength * scaleFactor));
        if (!geom.getName().isEmpty()) {
            int textHeight = g.getFontMetrics().getHeight();
            int xLabel = rebLineX + 40;
            int yLabel = rebLineY - 20 + textHeight;
            g.drawString(geom.getName(), (int)((double)xLabel * scaleFactor), (int)((double)yLabel * scaleFactor));
        }
        g2d.scale(scaleFactor, scaleFactor);
        g.setColor(orig);
    }

    private static void renderSegmentGeometry(Segment geom, Graphics g, Point p, double scaleFactor) {
        int width = geom.getWidth();
        int height = geom.getHeight();
        int xLabel = (int)((double)width * 0.5);
        int textHeight = g.getFontMetrics().getHeight();
        int textWidth = g.getFontMetrics().stringWidth(geom.getName());
        int yLabel = p.y + height / 2 + textHeight / 2;
        Graphics2D g2d = (Graphics2D)g;
        g.drawRect(p.x, p.y, geom.getWidth(), geom.getHeight());
        Color old = g.getColor();
        Color red = Color.RED;
        g.setColor(red);
        int squareSize = (int)(4.0 / scaleFactor);
        if (geom.isReadoutDown()) {
            if (!geom.isReadoutLeft()) {
                g.fillRect(p.x + geom.getWidth() - squareSize, p.y + height - squareSize, squareSize, squareSize);
            } else {
                g.fillRect(p.x - squareSize, p.y + height - squareSize, squareSize, squareSize);
            }
        } else if (!geom.isReadoutLeft()) {
            g.fillRect(p.x + geom.getWidth() - squareSize, p.y, squareSize, squareSize);
        } else {
            g.fillRect(p.x, p.y, squareSize, squareSize);
        }
        g.setColor(old);
        xLabel = p.x + xLabel - textWidth / 2 + 40;
        g2d.scale(1.0 / scaleFactor, 1.0 / scaleFactor);
        g.drawString(geom.getName(), (int)((double)xLabel * scaleFactor), (int)((double)yLabel * scaleFactor));
        g2d.scale(scaleFactor, scaleFactor);
    }
}

