/*
 * Decompiled with CFR 0.152.
 */
package com.ifountain.opsgenie.client.model.beans;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.ifountain.opsgenie.client.model.ObjectWithTimeZone;
import com.ifountain.opsgenie.client.model.beans.BeanWithId;
import com.ifountain.opsgenie.client.model.beans.Restriction;
import com.ifountain.opsgenie.client.model.beans.ScheduleParticipant;
import com.ifountain.opsgenie.client.model.beans.ScheduleRotationRestriction;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;

public class ScheduleRotation
extends BeanWithId
implements ObjectWithTimeZone {
    private Date startDate;
    private Date endDate;
    private RotationType rotationType;
    private Integer rotationLength;
    private List<ScheduleParticipant> participants;
    @JsonProperty(value="restrictions")
    private List<Restriction> scheduleRotationRestrictions;
    private TimeZone scheduleTimeZone;
    private String name;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public RotationType getRotationType() {
        return this.rotationType;
    }

    public void setRotationType(RotationType rotationType) {
        this.rotationType = rotationType;
    }

    public Integer getRotationLength() {
        return this.rotationLength;
    }

    public void setRotationLength(Integer rotationLength) {
        this.rotationLength = rotationLength;
    }

    @JsonProperty(value="participants")
    public List<String> getParticipantsNames() {
        if (this.participants == null) {
            return null;
        }
        ArrayList<String> participantList = new ArrayList<String>();
        for (ScheduleParticipant participant : this.participants) {
            participantList.add(participant.getParticipant());
        }
        return participantList;
    }

    public List<ScheduleParticipant> getParticipants() {
        return this.participants;
    }

    public void setParticipants(List<ScheduleParticipant> participants) {
        this.participants = participants;
    }

    @Deprecated
    @JsonIgnore
    public List<ScheduleRotationRestriction> getRestrictions() {
        if (this.scheduleRotationRestrictions == null) {
            return null;
        }
        ArrayList<ScheduleRotationRestriction> deprecatedList = new ArrayList<ScheduleRotationRestriction>();
        for (Restriction restriction : this.scheduleRotationRestrictions) {
            ScheduleRotationRestriction newRestriction = new ScheduleRotationRestriction();
            newRestriction.setEndDay(restriction.getEndDay());
            newRestriction.setStartDay(restriction.getStartDay());
            newRestriction.setStartHour(restriction.getStartHour());
            newRestriction.setStartMin(restriction.getStartMinute());
            newRestriction.setEndHour(restriction.getEndHour());
            newRestriction.setEndMin(restriction.getEndMinute());
            deprecatedList.add(newRestriction);
        }
        return deprecatedList;
    }

    @Deprecated
    @JsonIgnore
    public void setRestrictions(List<ScheduleRotationRestriction> restrictions) {
        if (restrictions == null) {
            this.scheduleRotationRestrictions = null;
        }
        this.scheduleRotationRestrictions = new ArrayList<Restriction>();
        for (ScheduleRotationRestriction deprecatedRestriction : restrictions) {
            Restriction newRestriction = new Restriction();
            newRestriction.withEndDay(deprecatedRestriction.getEndDay()).withStartDay(deprecatedRestriction.getStartDay()).withEndHour(deprecatedRestriction.getEndHour()).withEndMinute(deprecatedRestriction.getEndMin()).withStartHour(deprecatedRestriction.getStartHour()).withStartMinute(deprecatedRestriction.getStartMin());
            this.scheduleRotationRestrictions.add(newRestriction);
        }
    }

    public TimeZone getScheduleTimeZone() {
        return this.scheduleTimeZone;
    }

    public void setScheduleTimeZone(TimeZone scheduleTimeZone) {
        this.scheduleTimeZone = scheduleTimeZone;
    }

    @Override
    public TimeZone getObjectTimeZone() {
        return this.scheduleTimeZone;
    }

    public ScheduleRotation withStartDate(Date startDate) {
        this.startDate = startDate;
        return this;
    }

    public ScheduleRotation withEndDate(Date endDate) {
        this.endDate = endDate;
        return this;
    }

    public ScheduleRotation withRotationType(RotationType rotationType) {
        this.rotationType = rotationType;
        return this;
    }

    public ScheduleRotation withRotationLength(Integer rotationLength) {
        this.rotationLength = rotationLength;
        return this;
    }

    public ScheduleRotation withParticipants(List<ScheduleParticipant> participants) {
        this.participants = participants;
        return this;
    }

    @Deprecated
    public ScheduleRotation withRestrictions(List<ScheduleRotationRestriction> restrictions) {
        this.setRestrictions(restrictions);
        return this;
    }

    public ScheduleRotation withScheduleTimeZone(TimeZone scheduleTimeZone) {
        this.scheduleTimeZone = scheduleTimeZone;
        return this;
    }

    public ScheduleRotation withName(String name) {
        this.name = name;
        return this;
    }

    public List<Restriction> getScheduleRotationRestrictions() {
        return this.scheduleRotationRestrictions;
    }

    public void setScheduleRotationRestrictions(List<Restriction> scheduleRotationRestrictions) {
        this.scheduleRotationRestrictions = scheduleRotationRestrictions;
    }

    public ScheduleRotation withScheduleRotationRestrictions(List<Restriction> restrictions) {
        this.scheduleRotationRestrictions = restrictions;
        return this;
    }

    public static enum RotationType {
        weekly,
        daily,
        hourly;

    }
}

