/*
 * Decompiled with CFR 0.152.
 */
package com.ifountain.opsgenie.client;

import com.ifountain.opsgenie.client.AbstractOpsGenieHttpClient;
import com.ifountain.opsgenie.client.http.OpsGenieHttpClient;
import com.ifountain.opsgenie.client.http.OpsGenieHttpResponse;
import com.ifountain.opsgenie.client.model.BaseRequest;
import com.ifountain.opsgenie.client.model.BaseResponse;
import com.ifountain.opsgenie.client.util.JsonUtils;
import java.io.IOException;
import java.text.ParseException;
import java.util.Map;
import org.apache.commons.logging.LogFactory;

class JsonOpsgenieHttpClient
extends AbstractOpsGenieHttpClient {
    public JsonOpsgenieHttpClient(OpsGenieHttpClient httpClient) {
        super(httpClient);
        this.log = LogFactory.getLog(JsonOpsgenieHttpClient.class);
    }

    @Override
    protected BaseResponse populateResponse(BaseRequest request, OpsGenieHttpResponse httpResponse) throws ParseException, IOException {
        BaseResponse response = super.populateResponse(request, httpResponse);
        OpsGenieJsonResponse jsonResponse = new OpsGenieJsonResponse(httpResponse.getContent());
        response.fromJson(new String(jsonResponse.getContent()));
        return response;
    }

    protected static class OpsGenieJsonResponse {
        byte[] content;
        Map json;

        public OpsGenieJsonResponse(byte[] content) throws IOException {
            this.content = content;
            this.json = JsonUtils.parse(content);
        }

        public byte[] getContent() {
            return this.content;
        }

        public void setContent(byte[] content) {
            this.content = content;
        }

        public Map getJson() {
            return this.json;
        }

        public void setJson(Map json) {
            this.json = json;
        }

        public Map json() {
            return this.json;
        }
    }
}

