/*
 * Decompiled with CFR 0.152.
 */
package com.ifountain.opsgenie.client;

import com.ifountain.opsgenie.client.IAlertOpsGenieClient;
import com.ifountain.opsgenie.client.JsonOpsgenieHttpClient;
import com.ifountain.opsgenie.client.OpsGenieClientException;
import com.ifountain.opsgenie.client.model.InputStreamAttachRequest;
import com.ifountain.opsgenie.client.model.alert.AcknowledgeRequest;
import com.ifountain.opsgenie.client.model.alert.AcknowledgeResponse;
import com.ifountain.opsgenie.client.model.alert.AddAlertTeamRequest;
import com.ifountain.opsgenie.client.model.alert.AddAlertTeamResponse;
import com.ifountain.opsgenie.client.model.alert.AddDetailsRequest;
import com.ifountain.opsgenie.client.model.alert.AddDetailsResponse;
import com.ifountain.opsgenie.client.model.alert.AddNoteRequest;
import com.ifountain.opsgenie.client.model.alert.AddNoteResponse;
import com.ifountain.opsgenie.client.model.alert.AddRecipientRequest;
import com.ifountain.opsgenie.client.model.alert.AddRecipientResponse;
import com.ifountain.opsgenie.client.model.alert.AddTagsRequest;
import com.ifountain.opsgenie.client.model.alert.AddTagsResponse;
import com.ifountain.opsgenie.client.model.alert.AssignRequest;
import com.ifountain.opsgenie.client.model.alert.AssignResponse;
import com.ifountain.opsgenie.client.model.alert.AttachRequest;
import com.ifountain.opsgenie.client.model.alert.AttachResponse;
import com.ifountain.opsgenie.client.model.alert.CloseAlertRequest;
import com.ifountain.opsgenie.client.model.alert.CloseAlertResponse;
import com.ifountain.opsgenie.client.model.alert.CountAlertsRequest;
import com.ifountain.opsgenie.client.model.alert.CountAlertsResponse;
import com.ifountain.opsgenie.client.model.alert.CreateAlertRequest;
import com.ifountain.opsgenie.client.model.alert.CreateAlertResponse;
import com.ifountain.opsgenie.client.model.alert.DeleteAlertRequest;
import com.ifountain.opsgenie.client.model.alert.DeleteAlertResponse;
import com.ifountain.opsgenie.client.model.alert.EscalateToNextRequest;
import com.ifountain.opsgenie.client.model.alert.EscalateToNextResponse;
import com.ifountain.opsgenie.client.model.alert.ExecuteAlertActionRequest;
import com.ifountain.opsgenie.client.model.alert.ExecuteAlertActionResponse;
import com.ifountain.opsgenie.client.model.alert.FileAttachRequest;
import com.ifountain.opsgenie.client.model.alert.GetAlertRequest;
import com.ifountain.opsgenie.client.model.alert.GetAlertResponse;
import com.ifountain.opsgenie.client.model.alert.ListAlertLogsRequest;
import com.ifountain.opsgenie.client.model.alert.ListAlertLogsResponse;
import com.ifountain.opsgenie.client.model.alert.ListAlertNotesRequest;
import com.ifountain.opsgenie.client.model.alert.ListAlertNotesResponse;
import com.ifountain.opsgenie.client.model.alert.ListAlertRecipientsRequest;
import com.ifountain.opsgenie.client.model.alert.ListAlertRecipientsResponse;
import com.ifountain.opsgenie.client.model.alert.ListAlertsRequest;
import com.ifountain.opsgenie.client.model.alert.ListAlertsResponse;
import com.ifountain.opsgenie.client.model.alert.RemoveDetailsRequest;
import com.ifountain.opsgenie.client.model.alert.RemoveDetailsResponse;
import com.ifountain.opsgenie.client.model.alert.RemoveTagsRequest;
import com.ifountain.opsgenie.client.model.alert.RemoveTagsResponse;
import com.ifountain.opsgenie.client.model.alert.RenotifyRequest;
import com.ifountain.opsgenie.client.model.alert.RenotifyResponse;
import com.ifountain.opsgenie.client.model.alert.SnoozeRequest;
import com.ifountain.opsgenie.client.model.alert.SnoozeResponse;
import com.ifountain.opsgenie.client.model.alert.TakeOwnershipRequest;
import com.ifountain.opsgenie.client.model.alert.TakeOwnershipResponse;
import com.ifountain.opsgenie.client.model.alert.UnAcknowledgeRequest;
import com.ifountain.opsgenie.client.model.alert.UnAcknowledgeResponse;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.text.ParseException;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ByteArrayBody;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.StringBody;

public class InnerAlertOpsGenieClient
implements IAlertOpsGenieClient {
    private JsonOpsgenieHttpClient httpClient;

    public InnerAlertOpsGenieClient(JsonOpsgenieHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    @Override
    public CreateAlertResponse createAlert(CreateAlertRequest createAlertRequest) throws IOException, OpsGenieClientException, ParseException {
        return (CreateAlertResponse)this.httpClient.doPostRequest(createAlertRequest);
    }

    @Override
    public CloseAlertResponse closeAlert(CloseAlertRequest closeAlertRequest) throws OpsGenieClientException, IOException, ParseException {
        return (CloseAlertResponse)this.httpClient.doPostRequest(closeAlertRequest);
    }

    @Override
    public DeleteAlertResponse deleteAlert(DeleteAlertRequest deleteAlertRequest) throws OpsGenieClientException, IOException, ParseException {
        return (DeleteAlertResponse)this.httpClient.doDeleteRequest(deleteAlertRequest);
    }

    @Override
    public GetAlertResponse getAlert(GetAlertRequest getAlertRequest) throws OpsGenieClientException, IOException, ParseException {
        return (GetAlertResponse)this.httpClient.doGetRequest(getAlertRequest);
    }

    @Override
    public ListAlertsResponse listAlerts(ListAlertsRequest listAlertsRequest) throws OpsGenieClientException, IOException, ParseException {
        return (ListAlertsResponse)this.httpClient.doGetRequest(listAlertsRequest);
    }

    @Override
    public CountAlertsResponse countAlerts(CountAlertsRequest countAlertsRequest) throws OpsGenieClientException, IOException, ParseException {
        return (CountAlertsResponse)this.httpClient.doGetRequest(countAlertsRequest);
    }

    @Override
    public AddNoteResponse addNote(AddNoteRequest addNoteRequest) throws OpsGenieClientException, IOException, ParseException {
        return (AddNoteResponse)this.httpClient.doPostRequest(addNoteRequest);
    }

    @Override
    public AcknowledgeResponse acknowledge(AcknowledgeRequest acknowledgeRequest) throws OpsGenieClientException, IOException, ParseException {
        return (AcknowledgeResponse)this.httpClient.doPostRequest(acknowledgeRequest);
    }

    @Override
    public UnAcknowledgeResponse unAcknowledge(UnAcknowledgeRequest unAcknowledgeRequest) throws OpsGenieClientException, IOException, ParseException {
        return (UnAcknowledgeResponse)this.httpClient.doPostRequest(unAcknowledgeRequest);
    }

    @Override
    public RenotifyResponse renotify(RenotifyRequest renotifyRequest) throws OpsGenieClientException, IOException, ParseException {
        return (RenotifyResponse)this.httpClient.doPostRequest(renotifyRequest);
    }

    @Override
    public TakeOwnershipResponse takeOwnership(TakeOwnershipRequest takeOwnershipRequest) throws OpsGenieClientException, IOException, ParseException {
        return (TakeOwnershipResponse)this.httpClient.doPostRequest(takeOwnershipRequest);
    }

    @Override
    public AssignResponse assign(AssignRequest assignRequest) throws OpsGenieClientException, IOException, ParseException {
        return (AssignResponse)this.httpClient.doPostRequest(assignRequest);
    }

    @Override
    public AddAlertTeamResponse addTeam(AddAlertTeamRequest addAlertTeamRequest) throws OpsGenieClientException, IOException, ParseException {
        return (AddAlertTeamResponse)this.httpClient.doPostRequest(addAlertTeamRequest);
    }

    @Override
    public AddRecipientResponse addRecipient(AddRecipientRequest addRecipientRequest) throws OpsGenieClientException, IOException, ParseException {
        return (AddRecipientResponse)this.httpClient.doPostRequest(addRecipientRequest);
    }

    @Override
    public AddTagsResponse addTags(AddTagsRequest addTagsRequest) throws OpsGenieClientException, IOException, ParseException {
        return (AddTagsResponse)this.httpClient.doPostRequest(addTagsRequest);
    }

    @Override
    public RemoveTagsResponse removeTags(RemoveTagsRequest removeTagsRequest) throws OpsGenieClientException, IOException, ParseException {
        return (RemoveTagsResponse)this.httpClient.doDeleteRequest(removeTagsRequest);
    }

    @Override
    public AttachResponse attach(FileAttachRequest attachRequest) throws OpsGenieClientException, IOException, ParseException {
        FileInputStream in = attachRequest.getFile() != null ? new FileInputStream(attachRequest.getFile()) : null;
        String fileName = attachRequest.getFile() != null ? attachRequest.getFile().getName() : null;
        return this._attach(attachRequest, in, fileName);
    }

    @Override
    public AttachResponse attach(InputStreamAttachRequest attachRequest) throws OpsGenieClientException, IOException, ParseException {
        return this._attach(attachRequest, attachRequest.getInputStream(), attachRequest.getFileName());
    }

    @Override
    public ListAlertLogsResponse listAlertLogs(ListAlertLogsRequest listAlertLogsRequest) throws ParseException, OpsGenieClientException, IOException {
        return (ListAlertLogsResponse)this.httpClient.doGetRequest(listAlertLogsRequest);
    }

    @Override
    public ListAlertRecipientsResponse listAlertRecipients(ListAlertRecipientsRequest listAlertRecipientsRequest) throws ParseException, OpsGenieClientException, IOException {
        return (ListAlertRecipientsResponse)this.httpClient.doGetRequest(listAlertRecipientsRequest);
    }

    @Override
    public ExecuteAlertActionResponse executeAlertAction(ExecuteAlertActionRequest executeAlertActionRequest) throws OpsGenieClientException, IOException, ParseException {
        return (ExecuteAlertActionResponse)this.httpClient.doPostRequest(executeAlertActionRequest);
    }

    @Override
    public ListAlertNotesResponse listAlertNotes(ListAlertNotesRequest listAlertNotesRequest) throws ParseException, OpsGenieClientException, IOException {
        return (ListAlertNotesResponse)this.httpClient.doGetRequest(listAlertNotesRequest);
    }

    @Override
    public AddDetailsResponse addDetails(AddDetailsRequest addDetailsRequest) throws OpsGenieClientException, IOException, ParseException {
        return (AddDetailsResponse)this.httpClient.doPostRequest(addDetailsRequest);
    }

    @Override
    public RemoveDetailsResponse removeDetails(RemoveDetailsRequest removeDetailsRequest) throws OpsGenieClientException, IOException, ParseException {
        return (RemoveDetailsResponse)this.httpClient.doDeleteRequest(removeDetailsRequest);
    }

    @Override
    public SnoozeResponse snooze(SnoozeRequest snoozeRequest) throws OpsGenieClientException, IOException, ParseException {
        return (SnoozeResponse)this.httpClient.doPostRequest(snoozeRequest);
    }

    @Override
    public EscalateToNextResponse escalateToNext(EscalateToNextRequest escalateToNextRequest) throws OpsGenieClientException, IOException, ParseException {
        return (EscalateToNextResponse)this.httpClient.doPostRequest(escalateToNextRequest);
    }

    private AttachResponse _attach(AttachRequest attachRequest, InputStream inputStream, String fileName) throws IOException, OpsGenieClientException, ParseException {
        MultipartEntity entity = new MultipartEntity(HttpMultipartMode.BROWSER_COMPATIBLE);
        if (inputStream != null && fileName != null) {
            entity.addPart("attachment", (ContentBody)new ByteArrayBody(this.convertInputStreamToByteArray(inputStream), new File(fileName).getName()));
        }
        if (attachRequest.getApiKey() != null) {
            entity.addPart("apiKey", (ContentBody)new StringBody(attachRequest.getApiKey(), "text/plain", Charset.forName("utf-8")));
        }
        if (attachRequest.getId() != null) {
            entity.addPart("id", (ContentBody)new StringBody(attachRequest.getId(), "text/plain", Charset.forName("utf-8")));
        }
        if (attachRequest.getAlias() != null) {
            entity.addPart("alias", (ContentBody)new StringBody(attachRequest.getAlias(), "text/plain", Charset.forName("utf-8")));
        }
        if (attachRequest.getTinyId() != null) {
            entity.addPart("tinyId", (ContentBody)new StringBody(attachRequest.getTinyId(), "text/plain", Charset.forName("utf-8")));
        }
        if (attachRequest.getIndexFile() != null) {
            entity.addPart("indexFile", (ContentBody)new StringBody(attachRequest.getIndexFile(), "text/plain", Charset.forName("utf-8")));
        }
        if (attachRequest.getUser() != null) {
            entity.addPart("user", (ContentBody)new StringBody(attachRequest.getUser(), "text/plain", Charset.forName("utf-8")));
        }
        if (attachRequest.getNote() != null) {
            entity.addPart("note", (ContentBody)new StringBody(attachRequest.getNote(), "text/plain", Charset.forName("utf-8")));
        }
        return (AttachResponse)this.httpClient.doPostRequest(attachRequest, entity);
    }

    protected byte[] convertInputStreamToByteArray(InputStream in) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        int c = -1;
        while ((c = in.read()) != -1) {
            outputStream.write(c);
        }
        outputStream.flush();
        in.close();
        return outputStream.toByteArray();
    }
}

