/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.reb.sim;

import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.lsst.ccs.drivers.reb.sim.AddressSpace;
import org.lsst.ccs.drivers.reb.sim.RegisterSet;
import org.lsst.ccs.drivers.reb.sim.SimulationException;

public class SequencerSimulation {
    private final int[] lines = new int[256];
    private final int[] times = new int[256];
    private final int[] program = new int[1024];
    private final int[] execRefs = new int[16];
    private final int[] execReps = new int[16];
    private final int[] jumpRefs = new int[16];
    private final int[] jumpReps = new int[16];
    private int programCounter;
    private int stackDepth;
    private int startAddress;
    private int errorFlag;
    private int stripes = 7;
    private int output = 0;
    private boolean patternMode = false;
    private boolean scanMode = false;
    private int maxSubroutineRepetitions = 0;
    private int maxFunctionRepetitions = 0;
    private int renormalization = 0;
    private volatile State state = State.STOPPED;
    private final List<StateListener> stateListeners = new CopyOnWriteArrayList<StateListener>();
    private final List<FunctionListener> functionListeners = new CopyOnWriteArrayList<FunctionListener>();
    private final List<SubroutineListener> subroutineListeners = new CopyOnWriteArrayList<SubroutineListener>();
    private final List<WaveformListener> waveformListeners = new CopyOnWriteArrayList<WaveformListener>();
    private final SynchronousQueue<LoopExit> loopSemaphore = new SynchronousQueue();
    private final ExecutorService executor = Executors.newSingleThreadExecutor();

    public SequencerSimulation(AddressSpace addressSpace) {
        addressSpace.add(new RegisterSet.ArrayRegisterSet(0x100000, this.lines));
        addressSpace.add(new RegisterSet.ArrayRegisterSet(0x200000, this.times));
        addressSpace.add(new RegisterSet.ArrayRegisterSet(0x300000, this.program));
        addressSpace.add(new RegisterSet.ArrayRegisterSet(0x350000, this.execRefs));
        addressSpace.add(new RegisterSet.ArrayRegisterSet(0x360000, this.execReps));
        addressSpace.add(new RegisterSet.ArrayRegisterSet(0x370000, this.jumpRefs));
        addressSpace.add(new RegisterSet.ArrayRegisterSet(0x380000, this.jumpReps));
        addressSpace.add(new StartAddressRegister(0x340000));
        addressSpace.add(new ErrorRegister(0x390000));
        addressSpace.add(new ErrorResetRegister(3735553));
        addressSpace.add(new StripeRegister(0x400007));
        addressSpace.add(new PatternRegister(0x400006));
        addressSpace.add(new ScanRegister(0x330000));
        addressSpace.add(new ScanResetRegister(0x330001));
        addressSpace.add(new StopRegister(0x320000));
        addressSpace.add(new StepRegister(0x310000));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<FinalState> start() {
        if (this.state != State.STOPPED) {
            throw new SimulationException("Attempt to start sequencer when sequencer not cleanly stopped");
        }
        ReentrantLock lock = new ReentrantLock();
        Condition sequencerStarted = lock.newCondition();
        Callable<FinalState> callable = () -> {
            try {
                this.programCounter = this.startAddress;
                this.stackDepth = 0;
                lock.lock();
                try {
                    this.stateChanged(State.RUNNING);
                    sequencerStarted.signalAll();
                }
                finally {
                    lock.unlock();
                }
                this.runSequencer();
            }
            catch (EndOfProgramException x) {
                this.stateChanged(State.STOPPED);
                FinalState finalState = new FinalState(this.state, this.programCounter, null);
                return finalState;
            }
            catch (InterruptedException | SimulationException ex) {
                this.errorFlag = this.programCounter + 0x10000000;
                this.stateChanged(State.ERROR);
                FinalState finalState = new FinalState(this.state, this.programCounter, ex);
                return finalState;
            }
            finally {
                if (this.output != this.lines[0]) {
                    this.waveformListeners.stream().forEach(w -> w.transition(this.output, this.lines[0], 0));
                    this.output = this.lines[0];
                }
            }
            return null;
        };
        lock.lock();
        try {
            Future<FinalState> future = this.executor.submit(callable);
            sequencerStarted.awaitUninterruptibly();
            Future<FinalState> future2 = future;
            return future2;
        }
        finally {
            lock.unlock();
        }
    }

    private void stop() throws InterruptedException {
        if (this.state != State.LOOPING) {
            throw new SimulationException("Sequencer received STOP command when not in infinite loop");
        }
        this.loopSemaphore.put(LoopExit.STOP);
    }

    private void step() throws InterruptedException {
        if (this.state != State.LOOPING) {
            throw new SimulationException("Sequencer received STEP command when not in infinite loop");
        }
        this.loopSemaphore.put(LoopExit.STEP);
    }

    public void shutdown() {
        this.executor.shutdownNow();
    }

    private void stateChanged(State newState) {
        if (newState != this.state) {
            State oldState = this.state;
            this.state = newState;
            this.stateListeners.stream().forEach(l -> l.stateChanged(oldState, newState));
        }
    }

    public State getState() {
        return this.state;
    }

    private void runSequencer() throws EndOfProgramException, InterruptedException {
        while (true) {
            if (this.executor.isShutdown()) {
                throw new InterruptedException("Sequencer is being shutdown");
            }
            int code = this.program[this.programCounter];
            int opCode = code >>> 28;
            switch (opCode) {
                case 1: {
                    int function = code >> 24 & 0xF;
                    boolean infiniteLoop = (code >> 23 & 1) != 0;
                    int repetitions = code & 0x7FFFFF;
                    this.callFunction(function, infiniteLoop, repetitions);
                    break;
                }
                case 2: {
                    int functionPointer = code >> 24 & 0xF;
                    int function = this.dereferenceFunctionPointer(functionPointer);
                    boolean infiniteLoop = (code >> 23 & 1) != 0;
                    int repetitions = code & 0x7FFFFF;
                    this.callFunction(function, infiniteLoop, repetitions);
                    break;
                }
                case 3: {
                    int function = code >> 24 & 0xF;
                    int repetitionsPointer = code & 0xF;
                    boolean infiniteLoop = this.dereferenceInfiniteLoop(repetitionsPointer);
                    int repetitions = this.dereferenceRepetitions(repetitionsPointer);
                    this.callFunction(function, infiniteLoop, repetitions);
                    break;
                }
                case 4: {
                    int functionPointer = code >> 24 & 0xF;
                    int repetitionsPointer = code & 0xF;
                    int function = this.dereferenceFunctionPointer(functionPointer);
                    boolean infiniteLoop = this.dereferenceInfiniteLoop(repetitionsPointer);
                    int repetitions = this.dereferenceRepetitions(repetitionsPointer);
                    this.callFunction(function, infiniteLoop, repetitions);
                    break;
                }
                case 5: {
                    int jumpAddress = code >> 16 & 0x3FF;
                    int repetitions = code & 0xFFFF;
                    this.callSubroutine(jumpAddress, repetitions);
                    break;
                }
                case 6: {
                    int jumpPointer = code >> 16 & 0xF;
                    int jumpAddress = this.dereferenceJumpPointer(jumpPointer);
                    int repetitions = code & 0xFFFF;
                    this.callSubroutine(jumpAddress, repetitions);
                    break;
                }
                case 7: {
                    int jumpAddress = code >> 16 & 0x3FF;
                    int repetitionsPointer = code & 0xF;
                    int repetitions = this.dereferenceJumpRepetitions(repetitionsPointer);
                    this.callSubroutine(jumpAddress, repetitions);
                    break;
                }
                case 8: {
                    int jumpPointer = code >> 16 & 0xF;
                    int repetitionsPointer = code & 0xF;
                    int repetitions = this.dereferenceJumpRepetitions(repetitionsPointer);
                    int jumpAddress = this.dereferenceJumpPointer(jumpPointer);
                    this.callSubroutine(jumpAddress, repetitions);
                    break;
                }
                case 14: {
                    return;
                }
                case 15: {
                    this.endProgram();
                }
                default: {
                    throw new SimulationException("Illegal opcode %08x at address %08x", opCode, this.programCounter);
                }
            }
            ++this.programCounter;
        }
    }

    private void callFunction(int function, boolean infiniteLoop, int repetitions) throws InterruptedException, EndOfProgramException {
        if (repetitions == 0) {
            return;
        }
        this.functionListeners.stream().forEach(f -> f.functionCalled(function, infiniteLoop, repetitions));
        if (!this.waveformListeners.isEmpty()) {
            int actualRepetitions = repetitions;
            if (this.maxFunctionRepetitions > 0 && actualRepetitions > this.maxFunctionRepetitions) {
                actualRepetitions = this.maxFunctionRepetitions;
            }
            if (infiniteLoop) {
                actualRepetitions = this.renormalization > 0 ? this.renormalization : 0;
            }
            if (infiniteLoop) {
                this.stateChanged(State.LOOPING);
            }
            for (int i = 0; actualRepetitions == 0 || i < actualRepetitions; ++i) {
                int address;
                if (this.executor.isShutdown()) {
                    throw new InterruptedException("Sequencer is being shutdown");
                }
                if (infiniteLoop) {
                    LoopExit exit = this.loopSemaphore.poll();
                    if (exit == LoopExit.STEP) {
                        this.stateChanged(State.RUNNING);
                        break;
                    }
                    if (exit == LoopExit.STOP) {
                        throw new EndOfProgramException();
                    }
                }
                for (int slice = 0; slice < 16 && this.times[address = slice + function * 16] != 0; ++slice) {
                    boolean isFirstSlice = slice == 0;
                    boolean isLastSlice = slice == 15 || this.times[address + 1] == 0;
                    int time = this.times[address] + (isFirstSlice ? 1 : 0) + (isLastSlice ? 2 : 0);
                    int line = this.lines[address];
                    this.waveformListeners.stream().forEach(w -> w.transition(this.output, line, time * 10));
                    this.output = line;
                }
            }
        } else if (infiniteLoop) {
            LoopExit exit;
            this.stateChanged(State.LOOPING);
            LoopExit loopExit = exit = this.renormalization > 0 ? this.loopSemaphore.poll(this.renormalization, TimeUnit.MICROSECONDS) : this.loopSemaphore.take();
            if (exit == null || exit == LoopExit.STEP) {
                this.stateChanged(State.RUNNING);
            } else if (exit == LoopExit.STOP) {
                throw new EndOfProgramException();
            }
        }
    }

    private void callSubroutine(int jumpAddress, int repetitions) throws EndOfProgramException, InterruptedException {
        if (this.stackDepth >= 16) {
            throw new SimulationException("Maximum stack depth exceeded");
        }
        if (repetitions == 0) {
            return;
        }
        this.subroutineListeners.stream().forEach(f -> f.subroutineCalled(jumpAddress, repetitions));
        int actualRepetitions = repetitions;
        if (this.maxSubroutineRepetitions > 0 && actualRepetitions > this.maxSubroutineRepetitions) {
            actualRepetitions = this.maxSubroutineRepetitions;
        }
        ++this.stackDepth;
        int saveProgramCounter = this.programCounter;
        for (int i = 0; i < actualRepetitions; ++i) {
            this.programCounter = jumpAddress;
            this.runSequencer();
        }
        --this.stackDepth;
        this.subroutineListeners.stream().forEach(f -> f.subroutineReturned(jumpAddress));
        this.programCounter = saveProgramCounter;
    }

    private int dereferenceFunctionPointer(int functionPointer) {
        return this.execRefs[functionPointer];
    }

    private boolean dereferenceInfiniteLoop(int repetitionsPointer) {
        return (this.execReps[repetitionsPointer] & 0x800000) != 0;
    }

    private int dereferenceRepetitions(int repetitionsPointer) {
        return this.execReps[repetitionsPointer] & 0x7FFFFF;
    }

    private int dereferenceJumpPointer(int jumpPointer) {
        return this.jumpRefs[jumpPointer];
    }

    private int dereferenceJumpRepetitions(int jumpPointer) {
        return this.jumpReps[jumpPointer];
    }

    private void endProgram() throws EndOfProgramException {
        throw new EndOfProgramException();
    }

    public int getMaxSubroutineRepetitions() {
        return this.maxSubroutineRepetitions;
    }

    public void setMaxSubroutineRepetitions(int maxSubroutineRepetitions) {
        this.maxSubroutineRepetitions = maxSubroutineRepetitions;
    }

    public int getMaxFunctionRepetitions() {
        return this.maxFunctionRepetitions;
    }

    public void setMaxFunctionRepetitions(int maxFunctionRepetitions) {
        this.maxFunctionRepetitions = maxFunctionRepetitions;
    }

    public int getRenormalization() {
        return this.renormalization;
    }

    public void setRenormalization(int renormalization) {
        this.renormalization = renormalization;
    }

    public void addStateListener(StateListener l) {
        this.stateListeners.add(l);
    }

    public void removeStateListener(StateListener l) {
        this.stateListeners.remove(l);
    }

    public void addSubroutineListener(SubroutineListener l) {
        this.subroutineListeners.add(l);
    }

    public void removeSubroutineListener(SubroutineListener l) {
        this.subroutineListeners.remove(l);
    }

    public void addFunctionListener(FunctionListener l) {
        this.functionListeners.add(l);
    }

    public void removeFunctionListener(FunctionListener l) {
        this.functionListeners.remove(l);
    }

    public void addWaveformListener(WaveformListener l) {
        this.waveformListeners.add(l);
    }

    public void removeWaveformListener(WaveformListener l) {
        this.waveformListeners.remove(l);
    }

    public class FinalState {
        private final State stateAtEnd;
        private final Exception exception;
        private final int programCounter;

        private FinalState(State stateAtEnd, int programCounter, Exception exception) {
            this.stateAtEnd = stateAtEnd;
            this.exception = exception;
            this.programCounter = programCounter;
        }

        public State getStateAtEnd() {
            return this.stateAtEnd;
        }

        public Exception getException() {
            return this.exception;
        }

        public int getProgramCounter() {
            return this.programCounter;
        }
    }

    public static interface WaveformListener {
        public void transition(int var1, int var2, int var3);
    }

    public static interface FunctionListener {
        public void functionCalled(int var1, boolean var2, int var3);
    }

    public static interface SubroutineListener {
        public void subroutineCalled(int var1, int var2);

        public void subroutineReturned(int var1);
    }

    public static interface StateListener {
        public void stateChanged(State var1, State var2);
    }

    private static class EndOfProgramException
    extends Exception {
    }

    private class ScanResetRegister
    extends RegisterSet.WriteOnlyRegister {
        ScanResetRegister(int address) {
            super(address);
        }

        @Override
        public void write(int value) {
        }
    }

    private class ScanRegister
    extends RegisterSet.Register {
        ScanRegister(int address) {
            super(address);
        }

        @Override
        public void write(int value) {
            SequencerSimulation.this.scanMode = (value & 1) != 0;
        }

        @Override
        public int read() {
            return SequencerSimulation.this.scanMode ? 1 : 0;
        }
    }

    private class PatternRegister
    extends RegisterSet.Register {
        PatternRegister(int address) {
            super(address);
        }

        @Override
        public void write(int value) {
            SequencerSimulation.this.patternMode = (value & 1) != 0;
        }

        @Override
        public int read() {
            return SequencerSimulation.this.patternMode ? 1 : 0;
        }
    }

    private class StripeRegister
    extends RegisterSet.Register {
        StripeRegister(int address) {
            super(address);
        }

        @Override
        public void write(int value) {
            SequencerSimulation.this.stripes = value;
        }

        @Override
        public int read() {
            return SequencerSimulation.this.stripes;
        }
    }

    private class StepRegister
    extends RegisterSet.WriteOnlyRegister {
        StepRegister(int address) {
            super(address);
        }

        @Override
        public void write(int value) {
            try {
                SequencerSimulation.this.step();
            }
            catch (InterruptedException ex) {
                throw new SimulationException("Interupted while stepping", new Object[]{ex});
            }
        }
    }

    private class StopRegister
    extends RegisterSet.WriteOnlyRegister {
        StopRegister(int address) {
            super(address);
        }

        @Override
        public void write(int value) {
            try {
                SequencerSimulation.this.stop();
            }
            catch (InterruptedException ex) {
                throw new SimulationException("Interupted while stopping", new Object[]{ex});
            }
        }
    }

    private class ErrorResetRegister
    extends RegisterSet.WriteOnlyRegister {
        ErrorResetRegister(int address) {
            super(address);
        }

        @Override
        public void write(int value) {
            SequencerSimulation.this.errorFlag = 0;
            if (SequencerSimulation.this.state == State.ERROR) {
                SequencerSimulation.this.stateChanged(State.STOPPED);
            }
        }
    }

    private class ErrorRegister
    extends RegisterSet.ReadOnlyRegister {
        ErrorRegister(int address) {
            super(address);
        }

        @Override
        public int read() {
            return SequencerSimulation.this.errorFlag;
        }
    }

    private class StartAddressRegister
    extends RegisterSet.Register {
        StartAddressRegister(int address) {
            super(address);
        }

        @Override
        public void write(int value) {
            if (SequencerSimulation.this.startAddress < 0 || SequencerSimulation.this.startAddress >= SequencerSimulation.this.program.length) {
                throw new SimulationException("Illegal start address %08x", value);
            }
            SequencerSimulation.this.startAddress = value;
        }

        @Override
        public int read() {
            return SequencerSimulation.this.startAddress;
        }
    }

    private static enum LoopExit {
        STEP,
        STOP;

    }

    public static enum State {
        STOPPED(false),
        RUNNING(true),
        LOOPING(true),
        ERROR(false);

        private final boolean running;

        private State(boolean running) {
            this.running = running;
        }

        public boolean isRunning() {
            return this.running;
        }
    }
}

