/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.auxelex;

import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.auxelex.Ipc;
import org.lsst.ccs.drivers.auxelex.TestSrp;
import org.lsst.ccs.drivers.commons.DriverException;

public class TestIpc
extends TestSrp {
    protected final Ipc ipc;

    public TestIpc() {
        super(new Ipc());
        this.ipc = (Ipc)this.srp;
    }

    @Command(description="Set a channel's voltage")
    public void setVoltage(@Argument(description="Channel number") int chan, @Argument(description="Voltage") double volts) throws DriverException {
        this.ipc.setVoltage(chan, volts);
    }

    @Command(description="Set a named channel's voltage")
    public void setVoltageN(@Argument(description="Channel name") String chan, @Argument(description="Voltage") double volts) throws DriverException {
        this.ipc.setVoltage(chan, volts);
    }

    @Command(description="Set a channel's current")
    public void setCurrent(@Argument(description="Channel number") int chan, @Argument(description="Current") double amps) throws DriverException {
        this.ipc.setCurrent(chan, amps);
    }

    @Command(description="Set a named channel's current")
    public void setCurrentN(@Argument(description="Channel name") String chan, @Argument(description="Current") double amps) throws DriverException {
        this.ipc.setCurrent(chan, amps);
    }

    @Command(description="Set a channel's power")
    public void setPower(@Argument(description="Channel number") int chan, @Argument(description="Power") double watts) throws DriverException {
        this.ipc.setPower(chan, watts);
    }

    @Command(description="Set a named channel's power")
    public void setPowerN(@Argument(description="Channel name") String chan, @Argument(description="Power") double watts) throws DriverException {
        this.ipc.setPower(chan, watts);
    }

    @Command(description="Turn on a channel")
    public void powerOn(@Argument(description="Channel number") int chan) throws DriverException {
        this.ipc.powerOn(chan);
    }

    @Command(description="Turn on a named channel")
    public void powerOnN(@Argument(description="Channel name") String chan) throws DriverException {
        this.ipc.powerOn(chan);
    }

    @Command(description="Turn off a channel")
    public void powerOff(@Argument(description="Channel number") int chan) throws DriverException {
        this.ipc.powerOff(chan);
    }

    @Command(description="Turn off a named channel")
    public void powerOffN(@Argument(description="Channel name") String chan) throws DriverException {
        this.ipc.powerOff(chan);
    }

    @Command(description="Show the powered state of a channel")
    public boolean isPowered(@Argument(description="Channel number") int chan) throws DriverException {
        return this.ipc.isPowered(chan);
    }

    @Command(description="Show the state of a named channel")
    public boolean isPoweredN(@Argument(description="Channel name") String chan) throws DriverException {
        return this.ipc.isPowered(chan);
    }

    @Command(description="Show the overall powered status")
    public String showPoweredStatus() throws DriverException {
        return String.format("0x%03x", this.ipc.getPoweredStatus());
    }

    @Command(description="Show the overall voltage limit status")
    public String showVlimitStatus() throws DriverException {
        return String.format("0x%03x", this.ipc.getVlimitStatus());
    }

    @Command(description="Show the overall current limit status")
    public String showiLimitStatus() throws DriverException {
        return String.format("0x%03x", this.ipc.getIlimitStatus());
    }

    @Command(description="Show the overall power limit status")
    public String showPlimitStatus() throws DriverException {
        return String.format("0x%03x", this.ipc.getPlimitStatus());
    }

    @Command(description="Read a channel's voltage")
    public String readVoltage(@Argument(description="Channel number") int chan) throws DriverException {
        return String.format("%.1f", this.ipc.readVoltage(chan));
    }

    @Command(description="Read a named channel's voltage")
    public String readVoltageN(@Argument(description="Channel name") String chan) throws DriverException {
        return String.format("%.1f", this.ipc.readVoltage(chan));
    }

    @Command(description="Read a channel's current")
    public String readCurrent(@Argument(description="Channel number") int chan) throws DriverException {
        return String.format("%.3f", this.ipc.readCurrent(chan));
    }

    @Command(description="Read a named channel's current")
    public String readCurrentN(@Argument(description="Channel name") String chan) throws DriverException {
        return String.format("%.3f", this.ipc.readCurrent(chan));
    }

    @Command(description="Read a channel's power")
    public String readPower(@Argument(description="Channel number") int chan) throws DriverException {
        return String.format("%.2f", this.ipc.readPower(chan));
    }

    @Command(description="Read a named channel's power")
    public String readPowerN(@Argument(description="Channel name") String chan) throws DriverException {
        return String.format("%.2f", this.ipc.readPower(chan));
    }

    @Command(description="Show whether a channel is voltage limited")
    public boolean isVoltageLimited(@Argument(description="Channel number") int chan) throws DriverException {
        return this.ipc.isVoltageLimited(chan);
    }

    @Command(description="Show whether a named channel is voltage limited")
    public boolean isVoltageLimitedN(@Argument(description="Channel number") String chan) throws DriverException {
        return this.ipc.isVoltageLimited(chan);
    }

    @Command(description="Show whether a channel is current limited")
    public boolean isCurrentLimited(@Argument(description="Channel number") int chan) throws DriverException {
        return this.ipc.isCurrentLimited(chan);
    }

    @Command(description="Show whether a named channel is current limited")
    public boolean isCurrentLimitedN(@Argument(description="Channel number") String chan) throws DriverException {
        return this.ipc.isCurrentLimited(chan);
    }

    @Command(description="Show whether a channel is power limited")
    public boolean isPowerLimited(@Argument(description="Channel number") int chan) throws DriverException {
        return this.ipc.isPowerLimited(chan);
    }

    @Command(description="Show whether a named channel is power limited")
    public boolean isPowerLimitedN(@Argument(description="Channel number") String chan) throws DriverException {
        return this.ipc.isPowerLimited(chan);
    }

    @Command(description="Show the channel names")
    public String showChannelNames() throws DriverException {
        StringBuilder text = new StringBuilder();
        String[] names = this.ipc.getChannelNames();
        String prefix = "";
        for (String name : names) {
            text.append(prefix).append(name == null ? "-" : name);
            prefix = " ";
        }
        return text.toString();
    }

    @Command(description="Show the complete power state")
    public String showAllPower() throws DriverException {
        String[] names = this.ipc.getChannelNames();
        int lName = 0;
        for (String name : names) {
            lName = Math.max(lName, name.length());
        }
        lName = Math.max(lName, 4);
        int lPref = (lName - 4) / 2;
        int lSuff = lName - lPref - 4;
        StringBuilder text = new StringBuilder();
        text.append(String.format("Chan %" + ++lPref + "sName%" + ++lSuff + "s State  Vlim  Ilim  Plim   Volts   mAmps  Watts", "", ""));
        int vLimits = this.ipc.getVlimitStatus();
        int iLimits = this.ipc.getIlimitStatus();
        int pLimits = this.ipc.getPlimitStatus();
        int chan = 0;
        while (chan < 9) {
            text.append(String.format("\n %2s   %-" + lName + "s   %3s    %3s   %3s   %3s  %6.1f  %6.3f  %5.2f", chan, names[chan], this.ipc.isPowered(chan) ? " on" : "off", (vLimits & 1) != 0 ? " on" : "off", (iLimits & 1) != 0 ? " on" : "off", (pLimits & 1) != 0 ? " on" : "off", this.ipc.readVoltage(chan), 1000.0 * this.ipc.readCurrent(chan), this.ipc.readPower(chan)));
            ++chan;
            vLimits >>= 1;
            iLimits >>= 1;
            pLimits >>= 1;
        }
        return text.toString();
    }
}

