/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.metrology;

import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.usb.UsbException;
import jline.console.ConsoleReader;
import org.lsst.ccs.drivers.ad.Ad7747Eval;
import org.lsst.ccs.utilities.sa.CmndProcess;

public class CapTest
implements CmndProcess.Dispatch {
    private static final int CHAN_CAP = 0;
    private static final int CHAN_TEMP = 1;
    private static final int CHAN_VOLT = 2;
    private static final int CHAN_VDD = 3;
    private static final int MONITOR_PERIOD = 500;
    private static final int SEL_NONE = 256;
    private static final int SEL_ALL = 257;
    private static final int SEP_ON = 1;
    private static final int SEP_OFF = 0;
    private static final String DEFAULT_NAME = "Captest";
    private static final int CMD_SAMPLE = 0;
    private static final int CMD_RATE = 1;
    private static final int CMD_GO = 2;
    private static final int CMD_LOG = 3;
    private static final int CMD_DAC = 4;
    private static final int CMD_MONITOR = 5;
    private static final int CMD_LOAD = 6;
    private static final int CMD_SELECT = 7;
    private static final int CMD_SEPARATE = 8;
    private static final int NUM_CMDS = 9;
    private static final String[] helpSample = new String[]{"Show or set the number of samples to be read each DAQ cycle", "sample [<count>]", "count  The number of samples to set"};
    private static final String[] helpRate = new String[]{"Show or set the nominal rate at which samples are acquired", "rate [<value>]", "value  The rate to set (45.5, 41.9, 25.0, 13.2, 8.1, 6.5, 5.5 or 4.6)"};
    private static final String[] helpSelect = new String[]{"Show or select the boards to be used for DAQ", "select [<id1> | all | none] [<id2>]... [<id10>]", "idn  The id of a board to be used"};
    private static final String[] helpSeparate = new String[]{"Show or set separate DAQ mode", "separate [<onoff>]", "onoff  If 'on', DAQ is performed separately for each board", "       If 'off', DAQ is performed on all selected boards simultaneously"};
    private static final String[] helpGo = new String[]{"Perform a data acquisition cycle", "go"};
    private static final String[] helpLog = new String[]{"Close the log file, and optionally set the name for the next one", "log  [<name>]", "name  The new stem name of the log file: a time stamp is appended"};
    private static final String[] helpDac = new String[]{"Show or set the state of the capacitance offset DACs", "dac <id> [<dac>] [<enab>] [<value>]", "id     The ID of the board to use, or -1 for all", "dac    The DAC to use, a or b (default is both when showing)", "enab   Enable the DAC if non-zero, disable it if zero", "value  The value to set, 0 - 63: 1 unit ~= 0.28 pF"};
    private static final String[] helpMonitor = new String[]{"Continuously monitor a sensor on each selected board", "monitor [<sensor>]", "sensor  The sensor to read: capacitance, temperature, voltage or vdd"};
    private static final String[] helpLoad = new String[]{"Load a board with its firmware", "load <board>", "board  The index of the board to be loaded"};
    private static final CmndProcess.Lookup rateNames = new CmndProcess.Lookup(8);
    private static final CmndProcess.Lookup chanNames;
    private static final CmndProcess.Lookup selNames;
    private static final CmndProcess.Lookup sepNames;
    private static final CmndProcess.Command cmnd;
    private static final PrintStream out;
    private final CmndProcess proc = new CmndProcess();
    private final MonitorData monData = new MonitorData();
    private final Timer monTimer = new Timer();
    private final ConsThread consThread = new ConsThread();
    private ConsoleReader reader;
    private int idMask;
    private int nsamp;
    private int rate;
    private int actvMask;
    private int daqChan;
    private int daqNsamp;
    private int nEvent;
    private int nToss;
    private DaqThread[] daqThreads;
    private ArrayList<Ad7747Eval> boards = new ArrayList();
    private ArrayBlockingQueue<Integer> doneQueue;
    private Exception[] excptn;
    private double[] data;
    private double[] mean;
    private double[] sigma;
    private double[] error;
    private double[] drift;
    private int[] id;
    private int[] nvalue;
    private int[] nexcptn;
    private boolean debug;
    private boolean monActive;
    private boolean sepDaq = true;
    private boolean stopMon;
    private String logName = "Captest";
    private PrintStream logFile;

    static {
        rateNames.add("45.5", 0);
        rateNames.add("41.9", 1);
        rateNames.add("25.0", 2);
        rateNames.add("13.2", 3);
        rateNames.add("8.1", 4);
        rateNames.add("6.5", 5);
        rateNames.add("5.5", 6);
        rateNames.add("4.6", 7);
        chanNames = new CmndProcess.Lookup(4);
        chanNames.add("capacitance", 0);
        chanNames.add("temperature", 1);
        chanNames.add("voltage", 2);
        chanNames.add("vdd", 3);
        selNames = new CmndProcess.Lookup(2);
        selNames.add("all", 257);
        selNames.add("none", 256);
        sepNames = new CmndProcess.Lookup(2);
        sepNames.add("on", 1);
        sepNames.add("off", 0);
        cmnd = new CmndProcess.Command(9);
        cmnd.add("sample", 0, helpSample, "i", new CmndProcess.Lookup[0]);
        cmnd.add("rate", 1, helpRate, "k", new CmndProcess.Lookup[]{rateNames});
        cmnd.add("select", 7, helpSelect, "jiiiiiii", new CmndProcess.Lookup[]{selNames});
        cmnd.add("separate", 8, helpSeparate, "k", new CmndProcess.Lookup[]{sepNames});
        cmnd.add("go", 2, helpGo, "e", new CmndProcess.Lookup[0]);
        cmnd.add("log", 3, helpLog, "s", new CmndProcess.Lookup[0]);
        cmnd.add("dac", 4, helpDac, "Isii", new CmndProcess.Lookup[0]);
        cmnd.add("monitor", 5, helpMonitor, "k", new CmndProcess.Lookup[]{chanNames});
        cmnd.add("load", 6, helpLoad, "Is", new CmndProcess.Lookup[0]);
        out = System.out;
    }

    public CapTest(int nsamp, int rate, boolean debug) {
        this.nsamp = nsamp;
        this.rate = rate;
        this.debug = debug;
    }

    public static void main(String[] args) {
        int rate;
        int nsamp;
        int n = nsamp = args.length >= 1 ? Integer.decode(args[0]) : 1;
        if (nsamp <= 0) {
            nsamp = 1;
        }
        int n2 = rate = args.length >= 2 ? rateNames.encode(args[1], true) : 0;
        if (rate < 0) {
            rate = 0;
        }
        boolean debug = args.length >= 3;
        try {
            new CapTest(nsamp, rate, debug).run();
        }
        catch (Exception e) {
            out.println(e);
        }
        System.exit(0);
    }

    public void run() throws Exception {
        String line;
        this.reader = new ConsoleReader();
        int j = 0;
        while (true) {
            try {
                this.boards.add(new Ad7747Eval(j));
            }
            catch (UsbException usbException) {
                break;
            }
            ++j;
        }
        int nboard = this.boards.size();
        if (nboard == 0) {
            out.println("No AD7747 boards found");
            return;
        }
        out.println(String.valueOf(nboard) + " AD7747 board" + (nboard == 1 ? "" : "s") + " found");
        out.format("Sample count = %s, rate = %s Hz\n", this.nsamp, rateNames.decode(this.rate));
        this.id = new int[nboard];
        this.data = new double[nboard];
        this.mean = new double[nboard];
        this.sigma = new double[nboard];
        this.error = new double[nboard];
        this.drift = new double[nboard];
        this.nvalue = new int[nboard];
        this.nexcptn = new int[nboard];
        this.excptn = new Exception[nboard];
        this.actvMask = (1 << nboard) - 1;
        this.doneQueue = new ArrayBlockingQueue(nboard);
        this.daqThreads = new DaqThread[nboard];
        int j2 = 0;
        while (j2 < nboard) {
            Ad7747Eval ad = this.boards.get(j2);
            ad.load(false);
            ad.setupStandard();
            ad.setExcEnabled(false);
            ad.setVtEnabled(true);
            this.id[j2] = this.readBoardId(ad);
            ad.setConvMode(1);
            this.daqThreads[j2] = new DaqThread(ad, j2);
            this.daqThreads[j2].start();
            ++j2;
        }
        out.print("Board IDs:");
        j2 = 0;
        while (j2 < nboard) {
            out.format(" %s", this.id[j2]);
            this.idMask |= 1 << this.id[j2];
            ++j2;
        }
        out.println();
        this.consThread.start();
        this.monTimer.schedule((TimerTask)this.monData, 0L, 500L);
        this.proc.add((CmndProcess.Dispatch)this, cmnd);
        while ((line = this.reader.readLine(">> ")) != null && this.proc.process(line)) {
        }
    }

    public boolean dispatch(int code, int found, Object[] args) {
        try {
            switch (code) {
                case 2: {
                    this.procGo(found, args);
                    break;
                }
                case 5: {
                    this.procMonitor(found, args);
                    break;
                }
                case 0: {
                    this.procSample(found, args);
                    break;
                }
                case 1: {
                    this.procRate(found, args);
                    break;
                }
                case 7: {
                    this.procSelect(found, args);
                    break;
                }
                case 8: {
                    this.procSeparate(found, args);
                    break;
                }
                case 4: {
                    this.procDac(found, args);
                    break;
                }
                case 3: {
                    this.procLog(found, args);
                    break;
                }
                case 6: {
                    this.procLoad(found, args);
                    break;
                }
                default: {
                    out.println("Command not fully implemented");
                    break;
                }
            }
        }
        catch (UsbException e) {
            out.println((Object)e);
        }
        return true;
    }

    private void procGo(int found, Object[] args) throws UsbException {
        int j = 0;
        while (j < this.boards.size()) {
            this.data[j] = 0.0;
            ++j;
        }
        this.monActive = true;
        this.nToss = 2;
        j = 0;
        while (j < this.boards.size()) {
            if ((this.actvMask & 1 << j) != 0) {
                Ad7747Eval ad = this.boards.get(j);
                ad.setExcEnabled(true);
                ad.setCapEnabled(true);
                ad.setVtEnabled(false);
                ad.setCapConvRate(this.rate);
                if (this.sepDaq) {
                    this.doDaq(0, this.nsamp, j);
                    ad.setExcEnabled(false);
                }
            }
            ++j;
        }
        if (!this.sepDaq) {
            this.doDaq(0, this.nsamp);
        }
        this.monActive = false;
        out.println();
        this.logEvent((found & 1) != 0 ? (String)args[0] : "");
        j = 0;
        while (j < this.boards.size()) {
            if ((this.actvMask & 1 << j) != 0) {
                if (!this.sepDaq) {
                    this.boards.get(j).setExcEnabled(false);
                }
                if (this.nvalue[j] != 0) {
                    out.format("   %s %.6g %.6g", this.id[j], this.mean[j], this.sigma[j]);
                } else {
                    out.format("   %s --------- -----------", this.id[j]);
                }
            }
            ++j;
        }
        out.println();
        j = 0;
        while (j < this.boards.size()) {
            if ((this.actvMask & 1 << j) != 0 && this.nexcptn[j] != 0) {
                out.format("Board %s had %s USB exceptions.  First was: %s\n", this.id[j], this.nexcptn[j], this.excptn[j]);
            }
            ++j;
        }
    }

    private void procMonitor(int found, Object[] args) throws UsbException {
        int chan = (found & 1) != 0 ? (Integer)args[0] : 0;
        int j = 0;
        while (j < this.boards.size()) {
            if ((this.actvMask & 1 << j) != 0) {
                Ad7747Eval ad = this.boards.get(j);
                if (chan == 0) {
                    if (!this.sepDaq) {
                        ad.setExcEnabled(true);
                        ad.setCapConvRate(7);
                    } else {
                        ad.setCapConvRate(this.rate);
                    }
                    ad.setCapEnabled(true);
                    ad.setVtEnabled(false);
                } else {
                    ad.setCapEnabled(false);
                    ad.setVtEnabled(true);
                    ad.setVtConvRate(3);
                    int mode = chan == 1 ? 0 : (chan == 2 ? 3 : 2);
                    ad.setVtMode(mode);
                }
            }
            ++j;
        }
        out.println("Monitoring " + chanNames.decode(chan) + ".  Press <return> to stop.");
        this.stopMon = false;
        this.consThread.interrupt();
        int[] nexcpt = new int[this.boards.size()];
        while (!this.stopMon) {
            if (chan != 0 || !this.sepDaq) {
                this.nToss = 0;
                this.doDaq(chan, 1);
            } else {
                this.nToss = 2;
                int j2 = 0;
                while (j2 < this.boards.size()) {
                    Ad7747Eval ad = this.boards.get(j2);
                    ad.setExcEnabled(true);
                    this.doDaq(chan, 1, j2);
                    ad.setExcEnabled(false);
                    ++j2;
                }
            }
            if (this.stopMon) break;
            out.print("\r");
            int j3 = 0;
            while (j3 < this.boards.size()) {
                if ((this.actvMask & 1 << j3) != 0) {
                    out.format("%s %.5g  ", this.id[j3], this.mean[j3]);
                    int n = j3;
                    nexcpt[n] = nexcpt[n] + this.nexcptn[j3];
                }
                ++j3;
            }
            if (!this.stopMon) continue;
            out.println();
        }
        int j4 = 0;
        while (j4 < this.boards.size()) {
            if ((this.actvMask & 1 << j4) != 0) {
                if (chan == 0 && !this.sepDaq) {
                    this.boards.get(j4).setExcEnabled(false);
                }
                if (nexcpt[j4] != 0) {
                    out.format("Board %s had %s USB exceptions.  Last was: %s\n", this.id[j4], nexcpt[j4], this.excptn[j4]);
                }
            }
            ++j4;
        }
    }

    private void procLoad(int found, Object[] args) throws UsbException {
        int index = (Integer)args[0];
        Ad7747Eval ad = this.boards.get(index);
        if ((found & 2) == 0) {
            ad.load(false);
        } else {
            ad.load((String)args[1], false);
        }
        ad.setupStandard();
        ad.setVtEnabled(true);
        this.id[index] = this.readBoardId(ad);
    }

    private void procSample(int found, Object[] args) {
        if ((found & 1) == 0) {
            out.println("Sample count = " + this.nsamp);
        } else {
            int value = (Integer)args[0];
            if (value > 0) {
                this.nsamp = value;
            } else {
                out.println("Invalid sample count");
            }
        }
    }

    private void procRate(int found, Object[] args) throws UsbException {
        if ((found & 1) == 0) {
            out.println("Sampling rate = " + rateNames.decode(this.rate) + " Hz");
        } else {
            this.rate = (Integer)args[0];
            int j = 0;
            while (j < this.boards.size()) {
                this.boards.get(j).setCapConvRate(this.rate);
                ++j;
            }
        }
    }

    private void procSelect(int found, Object[] args) {
        if (found == 0) {
            out.print("Selected boards:");
            if (this.actvMask == 0) {
                out.format(" %s\n", selNames.decode(256));
            } else {
                int j = 0;
                while (j < this.boards.size()) {
                    if ((this.actvMask & 1 << j) != 0) {
                        out.format(" %s", this.id[j]);
                    }
                    ++j;
                }
                if (this.actvMask == (1 << this.boards.size()) - 1) {
                    out.format(" (%s)", selNames.decode(257));
                }
                out.println();
            }
        } else {
            int mask = 0;
            int j = 0;
            while (j < 16) {
                if ((found & 1 << j) != 0) {
                    int value = (Integer)args[j];
                    if (j == 0 && (value == 257 || value == 256)) {
                        if ((found & 0xFFFFFFFE) != 0) {
                            out.println("Too many arguments");
                            mask = -1;
                            break;
                        }
                        if (value == 257) {
                            mask = (1 << this.boards.size()) - 1;
                            break;
                        }
                        mask = 0;
                        break;
                    }
                    if ((this.idMask & 1 << value) == 0) {
                        out.println("Invalid board ID: " + value);
                        mask = -1;
                        break;
                    }
                    mask |= 1 << this.getBoardIndex(value);
                }
                ++j;
            }
            if (mask >= 0) {
                this.actvMask = mask;
            }
        }
    }

    private void procSeparate(int found, Object[] args) {
        if (found == 0) {
            out.println("Separate DAQ = " + sepNames.decode(this.sepDaq ? 1 : 0));
        } else {
            this.sepDaq = (Integer)args[0] == 1;
        }
    }

    private void procDac(int found, Object[] args) throws UsbException {
        int index = this.getBoardIndex((Integer)args[0]);
        if (index == -2) {
            return;
        }
        int first = index == -1 ? 0 : index;
        int last = index == -1 ? this.id.length : index + 1;
        int dacs = 3;
        if ((found & 2) != 0) {
            String dac = (String)args[1];
            if (dac.equalsIgnoreCase("a")) {
                dacs = 1;
            } else if (dac.equalsIgnoreCase("b")) {
                dacs = 2;
            } else {
                out.println("Invalid DAC id");
                return;
            }
        }
        if ((found & 0xC) == 0) {
            int j = first;
            while (j < last) {
                Ad7747Eval ad = this.boards.get(j);
                out.print("ID " + this.id[j] + ":");
                if ((dacs & 1) != 0) {
                    out.print("  DAC A: " + (ad.isDacAEnabled() ? "En" : "Dis") + "abled, value = " + ad.getDacAValue());
                }
                if ((dacs & 2) != 0) {
                    out.print("  DAC B: " + (ad.isDacBEnabled() ? "En" : "Dis") + "abled, value = " + ad.getDacBValue());
                }
                out.println();
                ++j;
            }
        } else {
            if (dacs == 3) {
                out.println("DAC id not specified");
                return;
            }
            int j = first;
            while (j < last) {
                Ad7747Eval ad = this.boards.get(j);
                if ((found & 4) != 0) {
                    boolean enable;
                    boolean bl = enable = (Integer)args[2] != 0;
                    if (dacs == 1) {
                        ad.setDacAEnabled(enable);
                    } else {
                        ad.setDacBEnabled(enable);
                    }
                }
                if ((found & 8) != 0) {
                    int value = (Integer)args[3];
                    if (dacs == 1) {
                        ad.setDacAValue(value);
                    } else {
                        ad.setDacBValue(value);
                    }
                }
                ++j;
            }
        }
    }

    private void procLog(int found, Object[] args) {
        if ((found & 1) != 0) {
            this.logName = (String)args[0];
        }
        if (this.nEvent != 0) {
            this.logFile.close();
            this.nEvent = 0;
        }
    }

    private void doDaq(int chan, int nsamp, int index) {
        if ((this.actvMask & 1 << index) == 0) {
            return;
        }
        this.daqChan = chan;
        this.daqNsamp = nsamp;
        this.daqThreads[index].interrupt();
        int done = 0;
        while (done != 1 << index) {
            try {
                Integer value = this.doneQueue.poll(10L, TimeUnit.SECONDS);
                if (value == null) continue;
                done |= 1 << value;
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void doDaq(int chan, int nsamp) {
        this.daqChan = chan;
        this.daqNsamp = nsamp;
        int j = 0;
        while (j < this.boards.size()) {
            if ((this.actvMask & 1 << j) != 0) {
                this.daqThreads[j].interrupt();
            }
            ++j;
        }
        int done = 0;
        while (done != this.actvMask) {
            try {
                Integer value = this.doneQueue.poll(10L, TimeUnit.SECONDS);
                if (value == null) continue;
                done |= 1 << value;
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void logEvent(String comment) {
        Date ts = new Date();
        if (this.nEvent == 0) {
            String name = String.valueOf(this.logName) + "_" + String.format("%tY%<tm%<td_%<tH%<tM%<tS", ts) + ".dat";
            try {
                this.logFile = new PrintStream(name);
            }
            catch (IOException e) {
                out.println("Cannot open log file: " + e);
                return;
            }
        }
        this.logFile.format("%tY-%<tm-%<td\t%<tH:%<tM:%<tS\t%s\t%s", ts, comment, rateNames.decode(this.rate));
        int j = 0;
        while (j < this.id.length) {
            this.logFile.format("\t%s\t%s\t%.6g\t%.6g\t%.6g\t%.6g", this.id[j], this.nvalue[j], this.mean[j], this.sigma[j], this.error[j], this.drift[j]);
            ++j;
        }
        this.logFile.println("\r");
        ++this.nEvent;
    }

    private int readBoardId(Ad7747Eval ad) throws UsbException {
        float value = ad.readVoltage(7);
        return (int)(10.0f * value + 0.5f);
    }

    private int getBoardIndex(int bid) {
        if (bid == -1) {
            return -1;
        }
        int j = 0;
        while (j < this.id.length) {
            if (this.id[j] == bid) {
                return j;
            }
            ++j;
        }
        out.println("Unknown board ID");
        return -2;
    }

    static /* synthetic */ int access$0(CapTest capTest) {
        return capTest.nToss;
    }

    static /* synthetic */ int access$1(CapTest capTest) {
        return capTest.daqNsamp;
    }

    static /* synthetic */ int access$2(CapTest capTest) {
        return capTest.daqChan;
    }

    static /* synthetic */ Exception[] access$4(CapTest capTest) {
        return capTest.excptn;
    }

    static /* synthetic */ double[] access$5(CapTest capTest) {
        return capTest.mean;
    }

    static /* synthetic */ double[] access$6(CapTest capTest) {
        return capTest.sigma;
    }

    static /* synthetic */ double[] access$7(CapTest capTest) {
        return capTest.error;
    }

    static /* synthetic */ double[] access$8(CapTest capTest) {
        return capTest.drift;
    }

    static /* synthetic */ int[] access$9(CapTest capTest) {
        return capTest.nvalue;
    }

    static /* synthetic */ int[] access$10(CapTest capTest) {
        return capTest.nexcptn;
    }

    static /* synthetic */ ArrayBlockingQueue access$11(CapTest capTest) {
        return capTest.doneQueue;
    }

    class ConsThread
    extends Thread {
        ConsThread() {
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        Thread.sleep(1000000L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    try {
                        CapTest.this.reader.readLine("");
                    }
                    catch (IOException iOException) {}
                    CapTest.this.stopMon = true;
                    continue;
                }
                break;
            }
        }
    }

    class DaqThread
    extends Thread {
        private Ad7747Eval ad;
        private int index;

        public DaqThread(Ad7747Eval ad, int index) {
            this.ad = ad;
            this.index = index;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        Thread.sleep(1000000L);
                    }
                }
                catch (InterruptedException v0) {
                    vsum = 0.0;
                    vsqsum = 0.0;
                    tsum = 0.0;
                    tsqsum = 0.0;
                    vtsum = 0.0;
                    count = 0;
                    nexcpt = 0;
                    millis0 = 0L;
                    j = -CapTest.access$0(CapTest.this);
                    ** while (j < CapTest.access$1((CapTest)CapTest.this))
                }
lbl-1000:
                // 1 sources

                {
                    block11: {
                        try {
                            value = CapTest.access$2(CapTest.this) == 0 ? (double)this.ad.readCapacitance(0) : (CapTest.access$2(CapTest.this) == 1 ? (double)this.ad.readTemperature(0) : (CapTest.access$2(CapTest.this) == 2 ? (double)this.ad.readVoltage(2) : (double)this.ad.readVoltage(0)));
                            if (j >= 0) {
                                millis = System.currentTimeMillis();
                                if (j == 0) {
                                    millis0 = millis;
                                }
                                time = (double)(millis - millis0) / 1000.0;
                                CapTest.access$3((CapTest)CapTest.this)[this.index] = value;
                                vsum += value;
                                vsqsum += value * value;
                                tsum += time;
                                tsqsum += time * time;
                                vtsum += value * time;
                                ++count;
                            }
                        }
                        catch (UsbException e) {
                            if (nexcpt++ != 0) break block11;
                            CapTest.access$4((CapTest)CapTest.this)[this.index] = e;
                        }
                    }
                    ++j;
                    continue;
                }
lbl38:
                // 1 sources

                if (count > 0) {
                    CapTest.access$5((CapTest)CapTest.this)[this.index] = avg = vsum / (double)count;
                    CapTest.access$6((CapTest)CapTest.this)[this.index] = Math.sqrt(vsqsum / (double)count - avg * avg);
                    CapTest.access$7((CapTest)CapTest.this)[this.index] = CapTest.access$6(CapTest.this)[this.index] / (double)count;
                } else {
                    CapTest.access$5((CapTest)CapTest.this)[this.index] = 0.0;
                    CapTest.access$6((CapTest)CapTest.this)[this.index] = 0.0;
                    CapTest.access$7((CapTest)CapTest.this)[this.index] = 0.0;
                }
                CapTest.access$8((CapTest)CapTest.this)[this.index] = count > 1 ? ((double)count * vtsum - vsum * tsum) / ((double)count * tsqsum - tsum * tsum) : 0.0;
                CapTest.access$9((CapTest)CapTest.this)[this.index] = count;
                CapTest.access$10((CapTest)CapTest.this)[this.index] = nexcpt;
                CapTest.access$11(CapTest.this).offer(this.index);
            }
        }
    }

    private class MonitorData
    extends TimerTask {
        private MonitorData() {
        }

        @Override
        public void run() {
            if (!CapTest.this.monActive) {
                return;
            }
            out.print("\r");
            int j = 0;
            while (j < CapTest.this.boards.size()) {
                if ((CapTest.this.actvMask & 1 << j) != 0) {
                    out.format("%s %.5g  ", CapTest.this.id[j], CapTest.this.data[j]);
                }
                ++j;
            }
        }
    }
}

