package org.lsst.ccs.subsystem.metrology;
import org.lsst.ccs.drivers.commons.DriverException;

/**
 ******************************************************************************
 **
 ** Defines an Aerotech device interface. * * @author Homer Neal *
 * *****************************************************************************
 */
public interface AerotechDevice {

    void abort() throws DriverException ;

    void enableAxes() throws DriverException ;

    void disableAxes() throws DriverException ;

    String getVersion() throws DriverException ;
    
    void rampRate(double rampRate) throws DriverException ;

    void setSpeed(double speed) throws DriverException ;

    void moveInc_x(double dx) throws DriverException ;
    void moveInc_y(double dy) throws DriverException ;
    void moveInc_z(double dz) throws DriverException ;
    
    void moveInc_xy(double dx, double dy) throws DriverException ;
    void moveInc_xyz(double dx, double dy, double dz) throws DriverException ;

    void moveAbs_x(double x) throws DriverException ;
    void moveAbs_y(double y) throws DriverException ;
    void moveAbs_z(double z) throws DriverException ;
    
    void moveAbs_xy(double x, double y) throws DriverException ;
    void moveAbs_xyz(double x, double y, double z) throws DriverException ;
    
    double getPos_x() throws DriverException ;
    double getPos_y() throws DriverException ;
    double getPos_z() throws DriverException ;
    double[] getPos_xyz() throws DriverException ;
    
    double getLastPos_x();
    double getLastPos_y();
    double getLastPos_z();
    
    String getError() throws DriverException ;
    
    void reset() throws DriverException ;
    
    void goHome() throws DriverException ;

}
