/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.metrology.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.time.Duration;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.text.NumberFormatter;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.bus.messages.CommandRequest;
import org.lsst.ccs.messaging.AgentMessagingLayer;
import org.lsst.ccs.messaging.ConcurrentMessagingUtils;
import org.lsst.ccs.subsystem.metrology.data.MetrologyConfig;

public class MetrologyConfigurableSubsystemMainPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final Map<String, MetrologyConfigurablePanel> panelMap = new TreeMap<String, MetrologyConfigurablePanel>();
    private static AgentMessagingLayer agentMessagingLayer;
    private final JLabel descriptionNameLbl = new JLabel();
    private static String metrology_dest;
    private static final Logger log;

    public MetrologyConfigurableSubsystemMainPanel(AgentMessagingLayer aml, String DEST) {
        agentMessagingLayer = aml;
        metrology_dest = DEST;
        this.setLayout(new BoxLayout(this, 0));
        this.add(this.descriptionNameLbl);
        for (MetrologyConfigurablePanel panel : panelMap.values()) {
            this.add(panel);
        }
    }

    public void updateWithConfigInfo(ConfigurationInfo configurationInfo) {
        log.info("updating config info");
        for (Map.Entry<String, MetrologyConfigurablePanel> entry : panelMap.entrySet()) {
            Map configForComponent = configurationInfo.getCurrentValuesFor(entry.getKey());
            log.info("updating for " + entry.getKey());
            if (configForComponent.isEmpty()) continue;
            entry.getValue().updateWithConfigInfo(configForComponent);
        }
        log.info("Done updating config info");
    }

    public void setDescriptionName(final String descriptionName) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MetrologyConfigurableSubsystemMainPanel.this.descriptionNameLbl.setText(descriptionName);
            }
        });
    }

    static {
        metrology_dest = "metrology";
        log = Logger.getLogger("org.lsst.ccs.subsystem.metrology.ui.MetrologyGUI");
        for (MetrologyConfig.configuration_states componentState : MetrologyConfig.configuration_states.values()) {
            String componentName = componentState.name();
            panelMap.put(componentName, new MetrologyConfigurablePanel(componentName));
        }
    }

    private static class MetrologyConfigurablePanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private final String componentName;
        private final NumberFormatter fmt5 = new NumberFormatter(new DecimalFormat("####0"));
        private final NumberFormatter fmt5d = new NumberFormatter(new DecimalFormat("###0.##"));
        private final NumberFormatter fmt5e = new NumberFormatter(new DecimalFormat("0.####E00"));
        private final JLabel stateLbl = new JLabel();
        private final JFormattedTextField startxLbl = new JFormattedTextField(this.fmt5d);
        private final JFormattedTextField stopxLbl = new JFormattedTextField(this.fmt5d);
        private final JFormattedTextField widthxLbl = new JFormattedTextField(this.fmt5d);
        private final JFormattedTextField dxLbl = new JFormattedTextField(this.fmt5d);
        private final JFormattedTextField startyLbl = new JFormattedTextField(this.fmt5d);
        private final JFormattedTextField stopyLbl = new JFormattedTextField(this.fmt5d);
        private final JFormattedTextField heightyLbl = new JFormattedTextField(this.fmt5d);
        private final JFormattedTextField dyLbl = new JFormattedTextField(this.fmt5d);
        private final JFormattedTextField zLbl = new JFormattedTextField(this.fmt5d);
        private final JFormattedTextField rotationLbl = new JFormattedTextField(this.fmt5d);
        private final JFormattedTextField cornerangLbl = new JFormattedTextField(this.fmt5d);
        private final JFormattedTextField nsampsLbl = new JFormattedTextField(this.fmt5);
        private final JFormattedTextField measmodeLbl = new JFormattedTextField(this.fmt5);
        private final JFormattedTextField accelerationLbl = new JFormattedTextField(this.fmt5d);
        private final JFormattedTextField speedLbl = new JFormattedTextField(this.fmt5d);
        private static final JButton btsavechanges = new JButton("Save Changes");

        private MetrologyConfigurablePanel(final String componentName) {
            super(new GridBagLayout());
            this.componentName = componentName;
            this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLACK), componentName));
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.anchor = 17;
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.gridwidth = 1;
            gbc.gridheight = 1;
            gbc.weightx = 0.0;
            gbc.weighty = 0.0;
            gbc.fill = 0;
            this.add((Component)new JLabel("State : "), gbc);
            gbc.gridy = 1;
            this.add((Component)new JLabel("Scan X start : "), gbc);
            gbc.gridy = 2;
            this.add((Component)new JLabel("Scan X stop : "), gbc);
            ++gbc.gridy;
            ++gbc.gridx;
            this.add((Component)new JLabel("Scan X width : "), gbc);
            --gbc.gridx;
            ++gbc.gridy;
            this.add((Component)new JLabel("Scan dX : "), gbc);
            ++gbc.gridy;
            this.add((Component)new JLabel("Scan Y start : "), gbc);
            ++gbc.gridy;
            this.add((Component)new JLabel("Scan Y stop : "), gbc);
            ++gbc.gridy;
            ++gbc.gridx;
            this.add((Component)new JLabel("Scan Y height : "), gbc);
            --gbc.gridx;
            ++gbc.gridy;
            this.add((Component)new JLabel("Scan dY : "), gbc);
            ++gbc.gridy;
            this.add((Component)new JLabel("Scan Z : "), gbc);
            ++gbc.gridy;
            this.add((Component)new JLabel("Rotation : "), gbc);
            ++gbc.gridy;
            this.add((Component)new JLabel("Corner Angle : "), gbc);
            ++gbc.gridy;
            this.add((Component)new JLabel("Cycle Mode : "), gbc);
            ++gbc.gridy;
            this.add((Component)new JLabel("Surface Mode : "), gbc);
            ++gbc.gridy;
            this.add((Component)new JLabel("Acceleration : "), gbc);
            ++gbc.gridy;
            this.add((Component)new JLabel("Speed : "), gbc);
            gbc.gridx += 3;
            this.add((Component)btsavechanges, gbc);
            btsavechanges.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    System.out.println("Saving all changes");
                    this.sendSyncMetrologyCommand(null, "saveAllChanges", new Object[0]);
                }
            });
            gbc.gridx = 1;
            gbc.gridy = 0;
            gbc.gridwidth = 1;
            gbc.weightx = 1.0;
            this.add((Component)this.stateLbl, gbc);
            Dimension d = this.startxLbl.getPreferredSize();
            d.width = 100;
            d.height = 20;
            this.startxLbl.setPreferredSize(d);
            this.stopxLbl.setPreferredSize(d);
            this.widthxLbl.setPreferredSize(d);
            this.startyLbl.setPreferredSize(d);
            this.stopyLbl.setPreferredSize(d);
            this.heightyLbl.setPreferredSize(d);
            this.cornerangLbl.setPreferredSize(d);
            this.rotationLbl.setPreferredSize(d);
            this.dxLbl.setPreferredSize(d);
            this.dyLbl.setPreferredSize(d);
            this.zLbl.setPreferredSize(d);
            this.nsampsLbl.setPreferredSize(d);
            this.measmodeLbl.setPreferredSize(d);
            this.accelerationLbl.setPreferredSize(d);
            this.speedLbl.setPreferredSize(d);
            gbc.gridx = 1;
            gbc.gridy = 1;
            gbc.gridwidth = 1;
            this.add((Component)this.startxLbl, gbc);
            gbc.gridy = 2;
            gbc.gridwidth = 1;
            this.add((Component)this.stopxLbl, gbc);
            ++gbc.gridy;
            ++gbc.gridx;
            this.add((Component)this.widthxLbl, gbc);
            --gbc.gridx;
            ++gbc.gridy;
            gbc.gridwidth = 1;
            this.add((Component)this.dxLbl, gbc);
            ++gbc.gridy;
            gbc.gridwidth = 1;
            this.add((Component)this.startyLbl, gbc);
            ++gbc.gridy;
            this.add((Component)this.stopyLbl, gbc);
            ++gbc.gridy;
            ++gbc.gridx;
            this.add((Component)this.heightyLbl, gbc);
            --gbc.gridx;
            ++gbc.gridy;
            this.add((Component)this.dyLbl, gbc);
            ++gbc.gridy;
            this.add((Component)this.zLbl, gbc);
            ++gbc.gridy;
            this.add((Component)this.rotationLbl, gbc);
            ++gbc.gridy;
            this.add((Component)this.cornerangLbl, gbc);
            ++gbc.gridy;
            this.add((Component)this.nsampsLbl, gbc);
            ++gbc.gridy;
            this.add((Component)this.measmodeLbl, gbc);
            ++gbc.gridy;
            this.add((Component)this.accelerationLbl, gbc);
            ++gbc.gridy;
            this.add((Component)this.speedLbl, gbc);
            this.startxLbl.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    System.out.println("changing startx value");
                    this.sendSyncMetrologyCommand(componentName, "change", "startx", startxLbl.getText());
                    Double new_stopx = Double.valueOf(widthxLbl.getText()) + Double.valueOf(startxLbl.getText());
                    stopxLbl.setText(Double.toString(new_stopx));
                    this.sendSyncMetrologyCommand(componentName, "change", "stopx", Double.toString(new_stopx));
                }
            });
            this.stopxLbl.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.sendSyncMetrologyCommand(componentName, "change", "stopx", stopxLbl.getText());
                    widthxLbl.setText(Double.toString(Double.valueOf(stopxLbl.getText()) - Double.valueOf(startxLbl.getText())));
                }
            });
            this.widthxLbl.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Double new_stopx = Double.valueOf(widthxLbl.getText()) + Double.valueOf(startxLbl.getText());
                    stopxLbl.setText(Double.toString(new_stopx));
                    this.sendSyncMetrologyCommand(componentName, "change", "stopx", stopxLbl.getText());
                }
            });
            this.dxLbl.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.sendSyncMetrologyCommand(componentName, "change", "dx", dxLbl.getText());
                }
            });
            this.startyLbl.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.sendSyncMetrologyCommand(componentName, "change", "starty", startyLbl.getText());
                    Double new_stopy = Double.valueOf(heightyLbl.getText()) + Double.valueOf(startyLbl.getText());
                    stopyLbl.setText(Double.toString(new_stopy));
                    this.sendSyncMetrologyCommand(componentName, "change", "stopy", stopyLbl.getText());
                }
            });
            this.stopyLbl.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.sendSyncMetrologyCommand(componentName, "change", "stopy", stopyLbl.getText());
                    heightyLbl.setText(Double.toString(Double.valueOf(stopyLbl.getText()) - Double.valueOf(startyLbl.getText())));
                }
            });
            this.heightyLbl.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Double new_stopy = Double.valueOf(heightyLbl.getText()) + Double.valueOf(startyLbl.getText());
                    stopyLbl.setText(Double.toString(new_stopy));
                    this.sendSyncMetrologyCommand(componentName, "change", "stopy", stopyLbl.getText());
                }
            });
            this.dyLbl.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.sendSyncMetrologyCommand(componentName, "change", "dy", dyLbl.getText());
                }
            });
            this.zLbl.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.sendSyncMetrologyCommand(componentName, "change", "z", zLbl.getText());
                }
            });
            this.rotationLbl.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.sendSyncMetrologyCommand(componentName, "change", "rotation", rotationLbl.getText());
                }
            });
            this.cornerangLbl.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.sendSyncMetrologyCommand(componentName, "change", "cornerang", cornerangLbl.getText());
                }
            });
            this.nsampsLbl.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.sendSyncMetrologyCommand(componentName, "change", "nsamples", nsampsLbl.getText());
                }
            });
            this.measmodeLbl.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.sendSyncMetrologyCommand(componentName, "change", "measmode", measmodeLbl.getText());
                }
            });
            this.accelerationLbl.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.sendSyncMetrologyCommand(componentName, "change", "acceleration", accelerationLbl.getText());
                }
            });
            this.speedLbl.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.sendSyncMetrologyCommand(componentName, "change", "speed", speedLbl.getText());
                }
            });
        }

        private void updateWithConfigInfo(final Map<String, String> configForComponent) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    stateLbl.setText((String)configForComponent.get("state"));
                    startxLbl.setText((String)configForComponent.get("startx"));
                    stopxLbl.setText((String)configForComponent.get("stopx"));
                    dxLbl.setText((String)configForComponent.get("dx"));
                    startyLbl.setText((String)configForComponent.get("starty"));
                    stopyLbl.setText((String)configForComponent.get("stopy"));
                    dyLbl.setText((String)configForComponent.get("dy"));
                    zLbl.setText((String)configForComponent.get("z"));
                    rotationLbl.setText((String)configForComponent.get("rotation"));
                    cornerangLbl.setText((String)configForComponent.get("cornerang"));
                    nsampsLbl.setText((String)configForComponent.get("nsamples"));
                    measmodeLbl.setText((String)configForComponent.get("measmode"));
                    accelerationLbl.setText((String)configForComponent.get("acceleration"));
                    speedLbl.setText((String)configForComponent.get("speed"));
                    widthxLbl.setText(Double.toString(Double.valueOf(stopxLbl.getText()) - Double.valueOf(startxLbl.getText())));
                    heightyLbl.setText(Double.toString(Double.valueOf(stopyLbl.getText()) - Double.valueOf(startyLbl.getText())));
                }
            });
        }

        protected Object sendSyncMetrologyCommand(String target, String name, Object ... params) {
            String dest = target == null ? metrology_dest : metrology_dest + "/" + target;
            ConcurrentMessagingUtils cmu = new ConcurrentMessagingUtils(agentMessagingLayer);
            CommandRequest cmd = new CommandRequest(dest, name, params);
            try {
                return cmu.sendSynchronousCommand(cmd, Duration.ofMillis(1440000L));
            }
            catch (Exception e) {
                log.warning("Unable to perform jgroup communication with destination " + dest + " - Exception " + e);
                return null;
            }
        }
    }
}

