/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.mcm.shuttersim;

import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import org.lsst.ccs.subsystem.mcm.data.InvalidStateException;
import org.lsst.ccs.subsystem.mcm.data.ShutterReadinessState;
import org.lsst.ccs.subsystem.mcm.data.ShutterState;
import org.lsst.ccs.subsystem.mcm.shuttersim.ShutterSim;

public abstract class ShutterInternalState
implements Serializable {
    private static final long serialVersionUID = -5903797676508388449L;
    private static final Duration preparationTime = Duration.ofMillis(150L);
    private static final Duration readyDuration = Duration.ofMillis(4000L);
    private static final Duration moveTime = Duration.ofMillis(980L);
    private static Instant startOpeningTime;
    private static Instant endOpeningTime;
    private static Instant startClosingTime;
    private static Instant endClosingTime;
    private String value;
    private static Map<String, ShutterInternalState> fromValues;
    public static final ShutterInternalState OPEN;
    public static final ShutterInternalState OPENING;
    public static final ShutterInternalState CLOSING;
    public static final ShutterInternalState CLOSED_OFF;
    public static final ShutterInternalState CLOSED_PREP;
    public static final ShutterInternalState CLOSED_PREP_EXPOSE;
    public static final ShutterInternalState CLOSED_ON;

    protected ShutterInternalState(String value) {
        this.value = value;
        fromValues.put(value, this);
    }

    public static ShutterInternalState valueOf(String n) {
        return fromValues.get(n);
    }

    public String toString() {
        return this.value;
    }

    public static synchronized void setStartClosingTime(Instant startClosingTime) {
        ShutterInternalState.startClosingTime = startClosingTime;
    }

    public static synchronized void setStartOpeningTime(Instant startOpeningTime) {
        ShutterInternalState.startOpeningTime = startOpeningTime;
    }

    public static synchronized void setEndClosingTime(Instant endClosingTime) {
        ShutterInternalState.endClosingTime = endClosingTime;
    }

    public static synchronized void setEndOpeningTime(Instant endOpeningTime) {
        ShutterInternalState.endOpeningTime = endOpeningTime;
    }

    public long getLastEffectiveExposureTime() {
        throw new InvalidStateException(this.toString(), "cannot get effective exposure time when not closed");
    }

    public long getLastTotalOpeningTime() {
        throw new InvalidStateException(this.toString(), "cannot get total opening time when not closed");
    }

    public ShutterState getPublicState() {
        return ShutterState.valueOf((String)this.toString());
    }

    public ShutterReadinessState getPublicReadinessState() {
        return ShutterReadinessState.READY;
    }

    public ShutterInternalState prepare(ShutterSim s) {
        s.getLogger().error((Object)("invalid prepare command, from state " + this));
        throw new InvalidStateException("SHUTTER:" + this.toString(), "prepare");
    }

    public ShutterInternalState expose(ShutterSim s, Duration integrationTime) {
        s.getLogger().error((Object)("invalid expose command, from state " + this));
        throw new InvalidStateException("SHUTTER:" + this.toString(), "expose");
    }

    public ShutterInternalState close(ShutterSim s) {
        s.getLogger().error((Object)("invalid close command, from state " + this));
        throw new InvalidStateException("SHUTTER:" + this.toString(), "prepare");
    }

    public void enter(ShutterSim s) {
    }

    public void exit(ShutterSim s) {
    }

    public static synchronized ShutterInternalState scheduled(ShutterSim s, ShutterInternalState from, ShutterInternalState to) {
        s.getLogger().info((Object)("scheduled from " + from + " to " + to + " actual " + s.getState()));
        if (s.getState() != from) {
            s.getLogger().info((Object)(" ignored scheduled: " + to + " because state is now " + s.getState() + " expecting " + from));
            return s.getState();
        }
        s.getLogger().debug((Object)(" scheduled: " + to));
        s.setState(to);
        return to;
    }

    public ScheduledFuture<ShutterInternalState> scheduleTransition(ShutterSim s, Duration delay, ShutterInternalState from, ShutterInternalState to) {
        return s.scheduleTransition(delay, from, to);
    }

    static {
        fromValues = new HashMap<String, ShutterInternalState>();
        OPEN = new ShutterInternalState("OPEN"){
            private static final long serialVersionUID = -4150157131229089583L;

            @Override
            public ShutterInternalState close(ShutterSim s) {
                return CLOSING;
            }
        };
        OPENING = new ShutterInternalState("OPENING"){
            private static final long serialVersionUID = -8748630599392814682L;

            @Override
            public void enter(ShutterSim s) {
                2.setStartOpeningTime(Instant.now());
                this.scheduleTransition(s, moveTime, OPENING, OPEN);
            }

            @Override
            public void exit(ShutterSim s) {
                2.setEndOpeningTime(Instant.now());
            }
        };
        CLOSING = new ShutterInternalState("CLOSING"){
            private static final long serialVersionUID = -5859735401510512904L;

            @Override
            public void enter(ShutterSim s) {
                3.setStartClosingTime(Instant.now());
                this.scheduleTransition(s, moveTime, CLOSING, CLOSED_ON);
            }

            @Override
            public void exit(ShutterSim s) {
                3.setEndClosingTime(Instant.now());
            }
        };
        CLOSED_OFF = new ClosedState("CLOSED_OFF"){
            private static final long serialVersionUID = -1129935528677774917L;

            @Override
            public ShutterReadinessState getPublicReadinessState() {
                return ShutterReadinessState.NOT_READY;
            }

            @Override
            public ShutterInternalState prepare(ShutterSim s) {
                return CLOSED_PREP;
            }

            @Override
            public ShutterInternalState expose(ShutterSim s, Duration integrationTime) {
                this.scheduleTransition(s, preparationTime, CLOSED_PREP_EXPOSE, OPENING);
                this.scheduleTransition(s, integrationTime.plus(preparationTime).plus(moveTime), OPEN, CLOSING);
                return CLOSED_PREP_EXPOSE;
            }
        };
        CLOSED_PREP = new ClosedState("CLOSED_PREP"){
            private static final long serialVersionUID = 6020461273102907209L;
            private Instant readyTime;

            @Override
            public ShutterReadinessState getPublicReadinessState() {
                return ShutterReadinessState.GETTING_READY;
            }

            @Override
            public ShutterInternalState prepare(ShutterSim s) {
                return this;
            }

            @Override
            public ShutterInternalState expose(ShutterSim s, Duration integrationTime) {
                Duration remaining = Duration.ofMillis(Instant.now().until(this.readyTime, ChronoUnit.MILLIS));
                s.getLogger().info((Object)("ShutterSim: expose while preparing, remaining prep time " + remaining.toMillis() + " ms."));
                remaining = remaining.plus(Duration.ofMillis(5L));
                this.scheduleTransition(s, remaining, CLOSED_ON, OPENING);
                this.scheduleTransition(s, integrationTime.plus(remaining).plus(moveTime), OPEN, CLOSING);
                return this;
            }

            @Override
            public void enter(ShutterSim s) {
                this.scheduleTransition(s, preparationTime, CLOSED_PREP, CLOSED_ON);
                this.readyTime = Instant.now().plus(preparationTime);
                s.getLogger().info((Object)("ShutterSim will be ready at " + this.readyTime));
            }
        };
        CLOSED_PREP_EXPOSE = new ClosedState("CLOSED_PREP_EXPOSE"){
            private static final long serialVersionUID = -4697199143872341749L;

            @Override
            public ShutterReadinessState getPublicReadinessState() {
                return ShutterReadinessState.GETTING_READY;
            }

            @Override
            public ShutterInternalState prepare(ShutterSim s) {
                return this;
            }
        };
        CLOSED_ON = new ClosedState("CLOSED_ON"){
            private static final long serialVersionUID = 5636147668726170551L;
            private transient ScheduledFuture<ShutterInternalState> powerOffTransition = null;

            @Override
            public ShutterInternalState expose(ShutterSim s, Duration integrationTime) {
                this.scheduleTransition(s, integrationTime.plus(moveTime), OPEN, CLOSING);
                return OPENING;
            }

            @Override
            public synchronized ShutterInternalState prepare(ShutterSim s) {
                if (this.powerOffTransition != null) {
                    this.powerOffTransition.cancel(false);
                }
                this.powerOffTransition = this.scheduleTransition(s, readyDuration, CLOSED_ON, CLOSED_OFF);
                return CLOSED_ON;
            }

            @Override
            public synchronized void enter(ShutterSim s) {
                if (this.powerOffTransition != null) {
                    this.powerOffTransition.cancel(false);
                }
                this.powerOffTransition = this.scheduleTransition(s, readyDuration, CLOSED_ON, CLOSED_OFF);
                if (endClosingTime != null) {
                    s.getLogger().info((Object)("ShutterSim: exposure time " + super.getLastEffectiveExposureTime() + " total " + super.getLastTotalOpeningTime()));
                }
            }

            @Override
            public synchronized void exit(ShutterSim s) {
                if (this.powerOffTransition != null) {
                    this.powerOffTransition.cancel(false);
                }
                this.powerOffTransition = null;
            }
        };
    }

    public static abstract class ClosedState
    extends ShutterInternalState {
        private static final long serialVersionUID = -1639448622856470993L;

        protected ClosedState(String value) {
            super(value);
        }

        @Override
        public ShutterState getPublicState() {
            return ShutterState.CLOSED;
        }

        @Override
        public long getLastEffectiveExposureTime() {
            return this.getLastTotalOpeningTime() - startOpeningTime.until(endOpeningTime, ChronoUnit.MILLIS) - startClosingTime.until(endClosingTime, ChronoUnit.MILLIS);
        }

        @Override
        public long getLastTotalOpeningTime() {
            return startOpeningTime.until(endClosingTime, ChronoUnit.MILLIS);
        }
    }
}

