/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.taitime;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Map;
import java.util.TreeMap;

class LeapSecondReader {
    private static final long EPOCH_OFFSET = 2208988800L;
    private final TreeMap<Long, Integer> leapMap;

    LeapSecondReader() throws IOException {
        this(new URL("https://www.ietf.org/timezones/data/leap-seconds.list"));
    }

    LeapSecondReader(URL source) throws IOException {
        this.leapMap = this.readLeaps(source);
    }

    private TreeMap<Long, Integer> readLeaps(URL source) throws IOException {
        try (BufferedReader in = new BufferedReader(new InputStreamReader(source.openStream()));){
            String inputLine;
            TreeMap<Long, Integer> localLeapMap = new TreeMap<Long, Integer>();
            while ((inputLine = in.readLine()) != null) {
                String[] split = inputLine.split("#", 2);
                if (split[0].isEmpty()) continue;
                String[] tokens = split[0].split("\\s+");
                if (tokens.length != 2) {
                    throw new IOException("Malformed line in leap second file: " + inputLine);
                }
                long leap = 1000L * (Long.parseLong(tokens[0]) - 2208988800L);
                int nSeconds = Integer.parseInt(tokens[1]);
                localLeapMap.put(leap, nSeconds);
            }
            TreeMap<Long, Integer> treeMap = localLeapMap;
            return treeMap;
        }
    }

    int getNumberOfLeapSeconds() {
        return this.getNumberOfLeapSeconds(System.currentTimeMillis());
    }

    int getNumberOfLeapSeconds(long timestamp) {
        Map.Entry<Long, Integer> leapSecond = this.leapMap.floorEntry(timestamp);
        if (leapSecond == null) {
            throw new RuntimeException("Cannot compute leap-second offset for timestamp before beginning of leap second file");
        }
        return leapSecond.getValue();
    }

    TreeMap<Long, Integer> getLeapMap() {
        return this.leapMap;
    }
}

