/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.mcm.alerts;

import java.util.HashMap;
import org.lsst.ccs.bus.data.Alert;

public enum McmAlerts {
    MissingSubsystem("MissingSubsystems", "Alert raised by the MCM when subsystems are missing");

    private final String id;
    private final String description;

    private McmAlerts(String id, String description) {
        this.id = id;
        this.description = description;
    }

    public String getAlertId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public Alert getAlert(Enum group, Object ... parameters) {
        String alertId = this.id + "/" + group;
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("group", group.name());
        if (this.id.equals(McmAlerts.MissingSubsystem.id)) {
            data.put("missing", parameters[0]);
        }
        return new Alert(alertId, this.description, data);
    }
}

