package org.lsst.ccs.subsystem.mcm;

import java.io.Serializable;

import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.states.AlertState;

public class AlertNotification implements Serializable {

    private static final long serialVersionUID = 7961750855058095737L;

    public AlertNotification(String origin, Enum group, Enum type, String cause, Alert alert, AlertState severity, long timestamp) {
        super();
        this.origin = origin;
        this.cause = cause;
        this.alert = alert;
        this.severity = severity;
        this.group = group;
        this.type = type;
        this.timestamp = timestamp;
    }

    @Override
    public String toString() {
        return "alert[" + severity + "] from " + origin + " id " + alert.getAlertId() + " (" + alert.getDescription()
                + "): " + cause;
    }

    private final Enum group;
    private final Enum type;
    private String origin;
    private String cause;
    private Alert alert;
    private AlertState severity;
    private long timestamp;

    public String getOrigin() {
        return origin;
    }

    public String getCause() {
        return cause;
    }

    public Alert getAlert() {
        return alert;
    }

    public AlertState getSeverity() {
        return severity;
    }
    
    public Enum getSubsystemGroup() {
        return group;
    }
    
    public Enum getSubsystemType() {
        return type;
    }
    
    public long getTimestamp() {
        return timestamp;
    }
}
